/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.init.ConfigInit;
import net.dehydration.init.EffectInit;
import net.dehydration.item.LeatherFlask;
import net.dehydration.misc.ThirstTooltipData;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class DehydrationOverlay
extends SimpleBarOverlay {
    private int blinkTime = 0;
    private final int[] qualityColor = new int[]{-13194241, -10839632, -3938534, -8467969};
    private float dehydration = 0.0f;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(class_1657 player) {
        ThirstManager thirstManager = ((ThirstManagerAccess)player).getThirstManager();
        if (!thirstManager.hasThirst()) {
            return null;
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        int thirst = thirstManager.getThirstLevel();
        this.dehydration = thirstManager.dehydration;
        int thirstColor = -15028249;
        if (player.method_6059(EffectInit.THIRST)) {
            thirstColor = -3938534;
        }
        if (player.method_32312() > 0) {
            thirstColor = -8467969;
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (thirstManager.dehydration >= 4.0f && this.tick % (thirst * 3 + 1) == 0) {
                this.blinkTime = 2;
            }
            if (this.blinkTime > 0) {
                --this.blinkTime;
            }
        }
        int thirstQuench = 0;
        int quality = 0;
        float alpha = 1.0f;
        if (ConfigInit.CONFIG.thirst_preview && thirst < 20) {
            class_1799 itemStack = null;
            if (!player.method_6047().method_7960() && !player.method_6047().method_32347().isEmpty() && player.method_6047().method_32347().get() instanceof ThirstTooltipData) {
                itemStack = player.method_6047();
            } else if (player.method_6079().method_7960() && !player.method_6079().method_32347().isEmpty() && player.method_6079().method_32347().get() instanceof ThirstTooltipData) {
                itemStack = player.method_6079();
            }
            if (itemStack != null) {
                thirstQuench = ((ThirstTooltipData)itemStack.method_32347().get()).getThirstQuench();
                if (itemStack.method_7909() instanceof LeatherFlask) {
                    thirstQuench = ConfigInit.CONFIG.flask_thirst_quench;
                }
                quality = ((ThirstTooltipData)itemStack.method_32347().get()).getDrinkQuality();
                alpha = (float)Math.cos((double)(this.tick % 40) / 40.0 * Math.PI * 2.0) * 0.5f + 0.5f;
            }
        }
        boolean highlight = this.blinkTime > 0;
        parameters.boundColor = highlight ? Utils.mixColor(-1, thirstColor, 0.08) : Utils.mixColor(-16777216, thirstColor, 0.5);
        parameters.emptyColor = AsteorBar.config.foodEmptyColor();
        parameters.value = thirst;
        parameters.capacity = 20.0;
        if (thirstQuench > 0) {
            parameters.secondValue = thirstQuench;
            parameters.secondValueOffset = thirst;
            parameters.secondFillColor = this.qualityColor[Math.max(0, Math.min(3, quality))];
            parameters.secondFillAlpha = alpha;
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(class_332 guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        if (AsteorBar.config.displayExhaustion()) {
            int innerWidth = right - left - 2;
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int exhaustionWidth = (int)((float)innerWidth * (Math.min(4.0f, this.dehydration) / 4.0f));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    protected boolean shouldRender(class_1657 player) {
        return AsteorBar.compatibility.dehydration && AsteorBar.config.hookDehydration();
    }
}

