/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.network;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.TargetPoint;
import com.github.glodblock.extendedae.EAE;
import com.github.glodblock.extendedae.EAEServer;
import com.github.glodblock.extendedae.network.packet.CGenericPacket;
import com.github.glodblock.extendedae.network.packet.CPatternKey;
import com.github.glodblock.extendedae.network.packet.CUpdatePage;
import com.github.glodblock.extendedae.network.packet.IMessage;
import com.github.glodblock.extendedae.network.packet.SAssemblerAnimation;
import com.github.glodblock.extendedae.network.packet.SExPatternInfo;
import com.github.glodblock.extendedae.network.packet.SGenericPacket;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_2987;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class EAENetworkServer {
    protected static final class_2960 channel = EAE.id("network");
    static int id = 0;
    public static EAENetworkServer INSTANCE;
    protected static final Int2ObjectMap<Supplier<IMessage<?>>> packetFactoryMap;
    protected static final Object2IntMap<Class<?>> packetIDMap;

    public EAENetworkServer() {
        INSTANCE = this;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)channel, this::serverPacket);
        this.init();
    }

    public void init() {
        if (id != 0) {
            return;
        }
        this.registerPacket(SExPatternInfo.class, SExPatternInfo::new);
        this.registerPacket(SAssemblerAnimation.class, SAssemblerAnimation::new);
        this.registerPacket(SGenericPacket.class, SGenericPacket::new);
        this.registerPacket(CPatternKey.class, CPatternKey::new);
        this.registerPacket(CUpdatePage.class, CUpdatePage::new);
        this.registerPacket(CGenericPacket.class, CGenericPacket::new);
    }

    private void registerPacket(Class<?> clazz, Supplier<IMessage<?>> factory) {
        packetIDMap.put(clazz, id);
        packetFactoryMap.put(id, factory);
        ++id;
    }

    public void serverPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 payload, PacketSender responseSender) {
        try {
            IMessage packet = (IMessage)((Supplier)packetFactoryMap.get(payload.method_10816())).get();
            if (!packet.isClient()) {
                packet.fromBytes(payload);
                server.execute(() -> packet.onMessage((class_1657)player));
            }
        }
        catch (class_2987 class_29872) {
            // empty catch block
        }
    }

    public void sendToAll(IMessage<?> message) {
        MinecraftServer server = EAEServer.getServer();
        if (server != null) {
            PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)BasePacket.CHANNEL, (class_2540)this.toBytes(message)));
        }
    }

    public void sendTo(IMessage<?> message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)this.toBytes(message));
    }

    public void sendToAllAround(IMessage<?> message, TargetPoint point) {
        PlayerLookup.around((class_3218)((class_3218)point.level), (class_243)new class_243(point.x, point.y, point.z), (double)point.radius).forEach(player -> {
            if (player != point.excluded) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)this.toBytes(message));
            }
        });
    }

    public void sendToServer(IMessage<?> message) {
        throw new UnsupportedOperationException();
    }

    public class_2540 toBytes(IMessage<?> message) {
        class_2540 bytes = new class_2540(Unpooled.buffer((int)1024));
        int id = packetIDMap.getOrDefault(message.getPacketClass(), -1);
        if (id == -1) {
            EAE.LOGGER.error(String.format("Unregistered Packet: %s", message.getPacketClass()));
        }
        bytes.method_10804(id);
        message.toBytes(bytes);
        return bytes;
    }

    static {
        packetFactoryMap = new Int2ObjectOpenHashMap();
        packetIDMap = new Object2IntOpenHashMap();
    }
}

