/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import appeng.core.settings.TickRates;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.ConfigManager;
import appeng.util.inv.CombinedInternalInventory;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.common.me.Crankable;
import com.github.glodblock.extendedae.common.me.InscriberThread;
import com.github.glodblock.extendedae.util.FCUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TileExInscriber
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject {
    public static final int MAX_THREAD = 4;
    private final InscriberThread[] threads = new InscriberThread[4];
    private final IUpgradeInventory upgrades;
    private final ConfigManager configManager;
    private final InternalInventory topItemHandlerAll;
    private final InternalInventory bottomItemHandlerAll;
    private final InternalInventory sideItemHandlerAll;
    private final InternalInventory combinedItemHandlerExternAll;
    private final InternalInventory invAll;
    private int stackSize = 1;
    private int animationIndex = -1;

    public TileExInscriber(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileExInscriber.class, TileExInscriber::new, (class_2248)EAEItemAndBlock.EX_INSCRIBER), pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
        this.upgrades = UpgradeInventories.forMachine((class_1935)EAEItemAndBlock.EX_INSCRIBER, (int)4, () -> ((TileExInscriber)this).saveChanges());
        this.configManager = new ConfigManager(this::onConfigChanged);
        this.configManager.registerSetting(Settings.INSCRIBER_SEPARATE_SIDES, (Enum)YesNo.NO);
        this.configManager.registerSetting(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        InternalInventory[] invs = new InternalInventory[4];
        InternalInventory[] invs2 = new InternalInventory[4];
        InternalInventory[] invs3 = new InternalInventory[4];
        InternalInventory[] invs4 = new InternalInventory[4];
        InternalInventory[] invs5 = new InternalInventory[4];
        for (int x = 0; x < 4; ++x) {
            this.threads[x] = new InscriberThread(this);
            invs[x] = this.threads[x].topItemHandlerExtern;
            invs2[x] = this.threads[x].bottomItemHandlerExtern;
            invs3[x] = this.threads[x].sideItemHandlerExtern;
            invs4[x] = this.threads[x].combinedItemHandlerExtern;
            invs5[x] = this.threads[x].getInternalInventory();
        }
        this.topItemHandlerAll = new CombinedInternalInventory(invs);
        this.bottomItemHandlerAll = new CombinedInternalInventory(invs2);
        this.sideItemHandlerAll = new CombinedInternalInventory(invs3);
        this.combinedItemHandlerExternAll = new CombinedInternalInventory(invs4);
        this.invAll = new CombinedInternalInventory(invs5);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public int getMaxProcessingTime() {
        return this.threads[0].getMaxProcessingTime();
    }

    public int getProcessingTime(int index) {
        return this.threads[index].getProcessingTime();
    }

    public boolean isSmash() {
        if (this.animationIndex < 0) {
            for (int x = 0; x < 4; ++x) {
                if (!this.threads[x].isSmash() || !this.checkTime(this.threads[x].getClientStart())) continue;
                this.animationIndex = x;
                return true;
            }
        } else {
            return this.threads[this.animationIndex].isSmash();
        }
        return false;
    }

    private boolean checkTime(long clientTime) {
        long currentTime = System.currentTimeMillis();
        if (clientTime == 0L) {
            return true;
        }
        return currentTime - clientTime < 100L;
    }

    public long getClientStart() {
        if (this.animationIndex < 0) {
            return 0L;
        }
        return this.threads[this.animationIndex].getClientStart();
    }

    public void setSmash(boolean smash) {
        if (this.animationIndex < 0) {
            return;
        }
        this.threads[this.animationIndex].setSmash(smash);
        if (!smash) {
            this.animationIndex = -1;
        }
    }

    public InternalInventory getIndexInventory(int index) {
        return this.threads[index].getInternalInventory();
    }

    public InscriberRecipe getTask(int index) {
        return this.threads[index].getTask();
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }
        if (setting == Settings.INSCRIBER_SEPARATE_SIDES) {
            this.markForUpdate();
        }
        this.saveChanges();
    }

    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        if (this.isSeparateSides()) {
            if (facing == this.getTop()) {
                return this.topItemHandlerAll;
            }
            if (facing == this.getTop().method_10153()) {
                return this.bottomItemHandlerAll;
            }
            return this.sideItemHandlerAll;
        }
        return this.combinedItemHandlerExternAll;
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.configManager.writeToNBT(data);
        data.method_10569("stacksize", this.stackSize);
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.configManager.readFromNBT(data);
        this.stackSize = data.method_10545("stacksize") ? data.method_10550("stacksize") : 1;
        for (InscriberThread t : this.threads) {
            t.init();
            t.setStackSize(this.stackSize);
        }
    }

    public int getInvStackSize() {
        return this.stackSize;
    }

    public void setInvStackSize(int size) {
        this.stackSize = size;
        for (InscriberThread t : this.threads) {
            t.setStackSize(size);
        }
        this.markForUpdate();
        this.saveChanges();
    }

    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        for (InscriberThread t : this.threads) {
            t.readFromStream(data);
        }
        this.stackSize = data.method_10816();
        return c;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        for (InscriberThread t : this.threads) {
            t.writeToStream(data);
        }
        data.method_10804(this.stackSize);
    }

    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        for (int x = 0; x < 4; ++x) {
            data.method_10556("smash#" + x, this.threads[x].isSmash());
        }
    }

    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        for (int x = 0; x < 4; ++x) {
            this.threads[x].setSmash(data.method_10577("smash#" + x));
        }
    }

    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public void method_5448() {
        super.method_5448();
        this.upgrades.clear();
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation rate = TickRateModulation.SLEEP;
        for (InscriberThread t : this.threads) {
            TickRateModulation tr = t.tick();
            if (tr.ordinal() <= rate.ordinal()) continue;
            rate = tr;
        }
        return rate;
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    public boolean isSeparateSides() {
        return this.configManager.getSetting(Settings.INSCRIBER_SEPARATE_SIDES) == YesNo.YES;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public InternalInventory getInternalInventory() {
        return this.invAll;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.markForUpdate();
        this.saveChanges();
        for (InscriberThread t : this.threads) {
            if (!t.containsInv(inv)) continue;
            t.onChangeInventory(inv, slot);
            break;
        }
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean sleep = true;
        for (InscriberThread t : this.threads) {
            if (t.isSleep()) continue;
            sleep = false;
            break;
        }
        return new TickingRequest(TickRates.Inscriber, sleep, false);
    }

    public ICrankable getCrankable(class_2350 direction) {
        if (direction != this.getFront()) {
            return new Crankable((AEBasePoweredBlockEntity)this);
        }
        return null;
    }
}

