/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.util.SettingsFrom;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.container.ContainerExPatternProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PartExPatternProvider
extends AEBasePart
implements PatternProviderLogicHost {
    public static List<class_2960> MODELS = Arrays.asList(new class_2960("extendedae", "part/ex_pattern_provider_base"), new class_2960("ae2", "part/interface_on"), new class_2960("ae2", "part/interface_off"), new class_2960("ae2", "part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(3)});
    protected final PatternProviderLogic logic = this.createLogic();

    public PartExPatternProvider(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.logic.onMainNodeStateChanged();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.logic.readFromNBT(data);
    }

    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.logic.writeToNBT(data);
    }

    public void addToWorld() {
        super.addToWorld();
        this.logic.updatePatterns();
    }

    public void addAdditionalDrops(List<class_1799> drops, boolean wrenched) {
        this.logic.addDrops(drops);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public void exportSettings(SettingsFrom mode, class_2487 output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
        }
    }

    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.importSettings(input, player);
        }
    }

    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        this.logic.updateRedstoneState();
    }

    public boolean onPartActivate(class_1657 p, class_1268 hand, class_243 pos) {
        if (!p.method_5770().method_8608()) {
            this.openMenu(p, MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void openMenu(class_1657 player, MenuLocator locator) {
        MenuOpener.open(ContainerExPatternProvider.TYPE, (class_1657)player, (MenuLocator)locator);
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExPatternProvider.TYPE, (class_1657)player, (MenuLocator)subMenu.getLocator());
    }

    protected PatternProviderLogic createLogic() {
        return new PatternProviderLogic(this.getMainNode(), (PatternProviderLogicHost)this, 36);
    }

    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    public EnumSet<class_2350> getTargets() {
        return EnumSet.of(this.getSide());
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    public AEItemKey getTerminalIcon() {
        return AEItemKey.of((class_1935)this.getPartItem());
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        return this.isPowered() ? MODELS_ON : MODELS_OFF;
    }

    public class_1799 getMainMenuIcon() {
        return new class_1799(EAEItemAndBlock.EX_PATTERN_PROVIDER_PART);
    }
}

