/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.me.wireless;

import appeng.api.features.Locatables;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.me.service.helpers.ConnectionWrapper;
import com.github.glodblock.extendedae.EAE;
import com.github.glodblock.extendedae.common.tileentities.TileWirelessConnector;
import com.github.glodblock.extendedae.config.EPPConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class WirelessConnect
implements IActionHost {
    private static final Set<WirelessConnect> ACTIVE_CONNECTOR = new HashSet<WirelessConnect>();
    private static final Locatables.Type<IActionHost> CONNECTORS = new Locatables.Type();
    private boolean isDestroyed = false;
    private boolean registered;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private boolean shutdown;
    private double dis;
    private TileWirelessConnector host;

    public WirelessConnect(TileWirelessConnector connector) {
        this.host = connector;
        this.registered = true;
        ACTIVE_CONNECTOR.add(this);
    }

    public void onUnload(class_3218 e) {
        if (this.host != null && this.host.method_10997() == e.method_8410()) {
            this.destroy();
        }
    }

    public void active() {
        ACTIVE_CONNECTOR.add(this);
        this.registered = true;
    }

    public void updateStatus() {
        long f = this.host.getFrequency();
        if (this.thisSide != f && this.thisSide != -f) {
            if (f != 0L) {
                if (this.thisSide != 0L) {
                    CONNECTORS.unregister(this.host.method_10997(), this.thisSide);
                }
                if (this.canUseNode(-f)) {
                    this.otherSide = f;
                    this.thisSide = -f;
                } else if (this.canUseNode(f)) {
                    this.thisSide = f;
                    this.otherSide = -f;
                }
                CONNECTORS.register(this.host.method_10997(), this.getLocatableKey(), (Object)this);
            } else {
                CONNECTORS.unregister(this.host.method_10997(), this.getLocatableKey());
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        IActionHost myOtherSide = this.otherSide == 0L ? null : (IActionHost)CONNECTORS.get(this.host.method_10997(), this.otherSide);
        this.shutdown = false;
        this.dis = 0.0;
        if (myOtherSide instanceof WirelessConnect) {
            WirelessConnect sideB = (WirelessConnect)myOtherSide;
            WirelessConnect sideA = this;
            this.dis = Math.sqrt(sideA.host.method_11016().method_10262((class_2382)sideB.host.method_11016()));
            if (sideA.isActive() && sideB.isActive() && this.dis <= EPPConfig.INSTANCE.wirelessConnectorMaxRange && sideA.host.method_10997() == sideB.host.method_10997()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    if (sideA.getNode() != null && sideB.getNode() != null) {
                        sideA.connection = sideB.connection = new ConnectionWrapper(GridHelper.createConnection((IGridNode)sideA.getNode(), (IGridNode)sideB.getNode()));
                    }
                }
                catch (IllegalStateException e) {
                    EAE.LOGGER.debug(e.getMessage());
                }
            } else {
                this.shutdown = true;
            }
        } else {
            this.shutdown = true;
        }
        if (this.shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    public double getDistance() {
        return this.dis;
    }

    public boolean isConnected() {
        return !this.shutdown;
    }

    private boolean canUseNode(long qe) {
        IActionHost locatable = (IActionHost)CONNECTORS.get(this.host.method_10997(), qe);
        if (locatable instanceof WirelessConnect) {
            WirelessConnect qc = (WirelessConnect)locatable;
            class_1937 world = qc.host.method_10997();
            if (!qc.isDestroyed && world != null) {
                if (world.method_22340(qc.host.method_11016())) {
                    class_3218 cur = Objects.requireNonNull(world.method_8503()).method_3847(world.method_27983());
                    class_2586 te = world.method_8321(qc.host.method_11016());
                    return te != qc.host || world != cur;
                }
                EAE.LOGGER.warn(String.format("Found a registered Wireless Connector with serial %s whose chunk seems to be unloaded: %s", qe, qc));
            }
        }
        return true;
    }

    @Nullable
    public class_2338 getOtherSide() {
        class_2338 class_23382;
        if (this.otherSide == 0L) {
            return null;
        }
        IActionHost o = (IActionHost)CONNECTORS.get(this.host.method_10997(), this.otherSide);
        if (o instanceof WirelessConnect) {
            WirelessConnect c = (WirelessConnect)o;
            class_23382 = c.host.method_11016();
        } else {
            class_23382 = null;
        }
        return class_23382;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.hasFreq();
    }

    private IGridNode getNode() {
        return this.host.getGridNode();
    }

    private boolean hasFreq() {
        return this.thisSide != 0L;
    }

    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        try {
            if (this.registered) {
                ACTIVE_CONNECTOR.remove(this);
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus();
                CONNECTORS.unregister(this.host.method_10997(), this.getLocatableKey());
            }
            this.host = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getLocatableKey() {
        return this.thisSide;
    }

    public IGridNode getActionableNode() {
        return this.host.getMainNode().getNode();
    }

    static {
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ACTIVE_CONNECTOR.clear());
        ServerWorldEvents.UNLOAD.register((server, world) -> ACTIVE_CONNECTOR.forEach(o -> o.onUnload(world)));
    }
}

