/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import com.github.glodblock.extendedae.common.items.InfinityCell;
import com.github.glodblock.extendedae.config.EPPConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class InfinityCellInventory
implements StorageCell {
    private final class_1799 stack;
    private final AEKey record;
    public static final ICellHandler HANDLER = new Handler();

    public InfinityCellInventory(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof InfinityCell)) {
            throw new IllegalArgumentException("Cell isn't an infinity cell!");
        }
        InfinityCell cell = (InfinityCell)class_17922;
        this.stack = stack;
        this.record = cell.getRecord(stack);
    }

    public CellState getStatus() {
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return EPPConfig.INSTANCE.infCellCost;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.record.equals(what)) {
            return amount;
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.record.equals(what)) {
            return amount;
        }
        return 0L;
    }

    public void persist() {
    }

    public class_2561 getDescription() {
        return this.stack.method_7964();
    }

    public void getAvailableStacks(KeyCounter out) {
        out.add(this.record, InfinityCell.getAsIntMax(this.record));
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return this.record.equals(what);
    }

    private static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(class_1799 is) {
            return is != null && is.method_7909() instanceof InfinityCell;
        }

        @Nullable
        public StorageCell getCellInventory(class_1799 is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new InfinityCellInventory(is) : null;
        }
    }
}

