/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.networking.IGrid;
import appeng.block.qnb.QuantumBaseBlock;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;

public final class QnbTestPlots {
    private QnbTestPlots() {
    }

    @TestPlot(value="simple_qnb_link")
    public static void simpleQnbLink(PlotBuilder plot) {
        class_2338 qnbA = class_2338.field_10980.method_10084();
        class_2338 qnbB = qnbA.method_10089(4);
        QnbTestPlots.qnbRing(plot, qnbA);
        QnbTestPlots.qnbRing(plot, qnbB);
        plot.test(helper -> helper.method_36041().method_36079(() -> {
            QnbTestPlots.ringAround(qnbA, pos -> helper.method_35987((class_2338)pos, (class_2769)QuantumBaseBlock.FORMED, Boolean.valueOf(true)));
            helper.method_35987(qnbA, (class_2769)QuantumBaseBlock.FORMED, Boolean.valueOf(true));
            QnbTestPlots.ringAround(qnbB, pos -> helper.method_35987((class_2338)pos, (class_2769)QuantumBaseBlock.FORMED, Boolean.valueOf(true)));
            helper.method_35987(qnbB, (class_2769)QuantumBaseBlock.FORMED, Boolean.valueOf(true));
        }).method_36085(() -> {
            class_1799 singularities = AEItems.QUANTUM_ENTANGLED_SINGULARITY.stack();
            QuantumBridgeBlockEntity.assignFrequency(singularities);
            QuantumBridgeBlockEntity coreA = QnbTestPlots.getCore(helper, qnbA);
            helper.check(coreA.getExposedInventoryForSide(class_2350.field_11035).addItems(singularities.method_7972()).method_7960(), "failed to add singularity", qnbA);
            QuantumBridgeBlockEntity coreB = QnbTestPlots.getCore(helper, qnbB);
            helper.check(coreB.getExposedInventoryForSide(class_2350.field_11035).addItems(singularities.method_7972()).method_7960(), "failed to add singularity", qnbB);
        }).method_36079(() -> {
            IGrid gridB;
            IGrid gridA = helper.getGrid(qnbA);
            if (gridA != (gridB = helper.getGrid(qnbB))) {
                helper.method_35997("not same grid", qnbA);
                helper.method_35997("not same grid", qnbB);
            }
        }).method_36079(() -> {
            IGrid gridB;
            IGrid gridA = helper.getGrid(qnbA);
            if (gridA != (gridB = helper.getGrid(qnbB))) {
                helper.method_35997("not same grid", qnbA);
                helper.method_35997("not same grid", qnbB);
            }
        }).method_36085(() -> QnbTestPlots.getCore(helper, qnbA).method_5448()).method_36079(() -> {
            QuantumBridgeBlockEntity coreA = QnbTestPlots.getCore(helper, qnbA);
            helper.check(!coreA.hasQES(), "still has singularity", qnbA);
            IGrid gridA = helper.getGrid(qnbA);
            IGrid gridB = helper.getGrid(qnbB);
            helper.check(gridA != gridB, "still same grid", qnbA);
        }).method_36075());
    }

    private static QuantumBridgeBlockEntity getCore(PlotTestHelper helper, class_2338 pos) {
        class_2586 be = helper.method_36014(pos);
        helper.check(be instanceof QuantumBridgeBlockEntity, "is not a QNB", pos);
        QuantumBridgeBlockEntity qnb = (QuantumBridgeBlockEntity)be;
        helper.check(qnb.isFormed(), "not formed", pos);
        helper.check(!qnb.isCorner(), "is corner", pos);
        return qnb;
    }

    private static void qnbRing(PlotBuilder plot, class_2338 origin) {
        plot.block(origin, AEBlocks.QUANTUM_LINK);
        QnbTestPlots.ringAround(origin, pos -> plot.block((class_2338)pos, (BlockDefinition<?>)AEBlocks.QUANTUM_RING));
    }

    private static void ringAround(class_2338 origin, Consumer<class_2338> consumer) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                class_2338 pos = origin.method_10069(x, y, 0);
                if (x == 0 && y == 0) continue;
                consumer.accept(pos);
            }
        }
    }
}

