/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

class StateApplier<T extends Comparable<T>> {
    private final class_2769<T> property;
    private final T value;

    private StateApplier(class_2769<T> property, String valueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, valueName);
    }

    <SH extends class_2688<O, SH>, O> SH apply(SH state) {
        return (SH)((class_2688)state.method_11657(this.property, this.value));
    }

    void writeToPacket(class_2540 buffer) {
        buffer.method_10814(this.property.method_11899());
        buffer.method_10814(this.property.method_11901(this.value));
    }

    static StateApplier<?> create(class_2689<?, ?> stateDefinition, String propertyName, String value) {
        class_2769<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new StateApplier(property, value);
    }

    @Environment(value=EnvType.CLIENT)
    static StateApplier<?> readFromPacket(class_2689<?, ?> stateDefinition, class_2540 buffer) {
        String propertyName = buffer.method_19772();
        String value = buffer.method_19772();
        return StateApplier.create(stateDefinition, propertyName, value);
    }

    public class_2769<T> getProperty() {
        return this.property;
    }

    public String getValueName() {
        return this.property.method_11901(this.value);
    }
}

