/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark;

import appeng.libs.micromark.DefaultExtension;
import appeng.libs.micromark.Extension;
import appeng.libs.micromark.Extensions;
import appeng.libs.micromark.InitialConstruct;
import appeng.libs.micromark.InitializeContent;
import appeng.libs.micromark.InitializeDocument;
import appeng.libs.micromark.InitializeFlow;
import appeng.libs.micromark.InitializeText;
import appeng.libs.micromark.ParseContext;
import appeng.libs.micromark.Preprocessor;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.commonmark.Subtokenize;
import appeng.libs.micromark.html.ParseOptions;
import java.util.ArrayList;
import java.util.List;

public final class Micromark {
    private Micromark() {
    }

    public static ParseContext parse(List<Extension> extensions) {
        ArrayList<Extension> actualExtensions = new ArrayList<Extension>();
        actualExtensions.add(DefaultExtension.create());
        actualExtensions.addAll(extensions);
        Extension constructs = Extensions.combineExtensions(actualExtensions);
        ParseContext parser = new ParseContext();
        parser.constructs = constructs;
        parser.content = Micromark.create(parser, InitializeContent.content);
        parser.document = Micromark.create(parser, InitializeDocument.document);
        parser.flow = Micromark.create(parser, InitializeFlow.flow);
        parser.string = Micromark.create(parser, InitializeText.string);
        parser.text = Micromark.create(parser, InitializeText.text);
        return parser;
    }

    public static ParseContext.Create create(ParseContext parser, InitialConstruct initial) {
        return from -> Tokenizer.create(parser, initial, from);
    }

    public static List<Tokenizer.Event> parse(String text) {
        return Micromark.parse(text, new ParseOptions());
    }

    public static List<Tokenizer.Event> parse(String text, ParseOptions options) {
        return Micromark.parse(options.getExtensions()).document.create().write(Preprocessor.preprocess(text, true));
    }

    public static List<Tokenizer.Event> parseAndPostprocess(String text) {
        return Micromark.parseAndPostprocess(text, new ParseOptions());
    }

    public static List<Tokenizer.Event> parseAndPostprocess(String text, ParseOptions options) {
        List<Tokenizer.Event> events = Micromark.parse(text, options);
        while (!Subtokenize.subtokenize(events)) {
        }
        return events;
    }
}

