/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.crafting.pattern.EncodedPatternItem;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class GuiGraphicsHooks {
    private static final ThreadLocal<class_1799> OVERRIDING_FOR = new ThreadLocal();

    private GuiGraphicsHooks() {
    }

    public static boolean onRenderGuiItem(class_332 guiGraphics, @Nullable class_1309 livingEntity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed, int z) {
        GenericStack unwrapped;
        class_310 minecraft = class_310.method_1551();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof EncodedPatternItem) {
            class_1799 output;
            EncodedPatternItem encodedPattern = (EncodedPatternItem)class_17922;
            if (OVERRIDING_FOR.get() == stack) {
                return false;
            }
            boolean shiftHeld = class_437.method_25442();
            if (shiftHeld && level != null && !(output = encodedPattern.getOutput(stack)).method_7960() && output != stack) {
                GuiGraphicsHooks.renderInstead(guiGraphics, livingEntity, level, output, x, y, seed, z);
                return true;
            }
        }
        if ((unwrapped = GenericStack.unwrapItemStack(stack)) != null) {
            AEKeyRendering.drawInGui(minecraft, guiGraphics, x, y, unwrapped.what());
            if (unwrapped.amount() > 0L) {
                String amtText = unwrapped.what().formatAmount(unwrapped.amount(), AmountFormat.SLOT);
                StackSizeRenderer.renderSizeLabel(guiGraphics, minecraft.field_1772, (float)x, (float)y, amtText, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderInstead(class_332 guiGraphics, @Nullable class_1309 livingEntity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed, int z) {
        OVERRIDING_FOR.set(stack);
        try {
            guiGraphics.method_51425(livingEntity, level, stack, x, y, seed, z);
        }
        finally {
            OVERRIDING_FOR.remove();
        }
    }
}

