/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.models;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.core.AppEng;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.models.VariantsBuilder;
import com.google.gson.JsonPrimitive;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4938;
import net.minecraft.class_7784;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AE2BlockStateProvider
extends BlockStateProvider
implements IAE2DataProvider {
    private static final class_4938<class_4936.class_4937> Z_ROT = new class_4938("ae2:z", r -> new JsonPrimitive((Number)(r.ordinal() * 90)));

    public AE2BlockStateProvider(class_7784 output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block) {
        ModelFile model = this.cubeAll((class_2248)block.block());
        this.simpleBlock((class_2248)block.block(), model);
        this.simpleBlockItem((class_2248)block.block(), model);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block, ModelFile model) {
        this.simpleBlock((class_2248)block.block(), model);
        this.simpleBlockItem((class_2248)block.block(), model);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block, String textureName) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(block.id().method_12832(), AppEng.makeId(textureName));
        this.simpleBlock((class_2248)block.block(), (ModelFile)model);
        this.simpleBlockItem((class_2248)block.block(), (ModelFile)model);
    }

    protected void wall(BlockDefinition<class_2544> block, String texture) {
        this.wallBlock(block.block(), AppEng.makeId(texture));
        this.itemModels().wallInventory(block.id().method_12832(), AppEng.makeId(texture));
    }

    protected void slabBlock(BlockDefinition<class_2482> slab, BlockDefinition<?> base) {
        String texture = this.blockTexture((class_2248)base.block()).method_12832();
        this.slabBlock(slab, base, texture, texture, texture);
    }

    protected void slabBlock(BlockDefinition<class_2482> slab, BlockDefinition<?> base, String bottomTexture, String sideTexture, String topTexture) {
        class_2960 side = AppEng.makeId(sideTexture);
        class_2960 bottom = AppEng.makeId(bottomTexture);
        class_2960 top = AppEng.makeId(topTexture);
        BlockModelBuilder bottomModel = (BlockModelBuilder)this.models().slab(slab.id().method_12832(), side, bottom, top);
        this.simpleBlockItem((class_2248)slab.block(), (ModelFile)bottomModel);
        this.slabBlock(slab.block(), (ModelFile)bottomModel, (ModelFile)this.models().slabTop(slab.id().method_12832() + "_top", side, bottom, top), (ModelFile)this.models().getExistingFile(base.id()));
    }

    protected void stairsBlock(BlockDefinition<class_2510> stairs, BlockDefinition<?> base) {
        String texture = "block/" + base.id().method_12832();
        this.stairsBlock(stairs, texture, texture, texture);
    }

    protected void stairsBlock(BlockDefinition<class_2510> stairs, String bottomTexture, String sideTexture, String topTexture) {
        String baseName = stairs.id().method_12832();
        class_2960 side = AppEng.makeId(sideTexture);
        class_2960 bottom = AppEng.makeId(bottomTexture);
        class_2960 top = AppEng.makeId(topTexture);
        ModelBuilder stairsModel = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(stairs.block(), (ModelFile)stairsModel, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((class_2248)stairs.block(), (ModelFile)stairsModel);
    }

    protected VariantsBuilder rotatedVariants(BlockDefinition<?> blockDef) {
        Object block = blockDef.block();
        VariantsBuilder builder = new VariantsBuilder((class_2248)block);
        this.registeredBlocks.put(block, builder);
        return builder;
    }

    protected final class_4925 multiVariantGenerator(BlockDefinition<?> blockDef, class_4935 ... variants) {
        if (variants.length == 0) {
            variants = new class_4935[]{class_4935.method_25824()};
        }
        class_4925 builder = class_4925.method_25771(blockDef.block(), (class_4935[])variants);
        this.registeredBlocks.put(blockDef.block(), () -> builder.method_25780().getAsJsonObject());
        return builder;
    }

    protected static class_4926 createFacingDispatch(int baseRotX, int baseRotY) {
        return class_4926.method_25783((class_2769)class_2741.field_12525).method_25793((Comparable)class_2350.field_11033, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX + 90, baseRotY, 0)).method_25793((Comparable)class_2350.field_11036, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX + 270, baseRotY, 0)).method_25793((Comparable)class_2350.field_11043, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX, baseRotY, 0)).method_25793((Comparable)class_2350.field_11035, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX, baseRotY + 180, 0)).method_25793((Comparable)class_2350.field_11039, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX, baseRotY + 270, 0)).method_25793((Comparable)class_2350.field_11034, AE2BlockStateProvider.applyRotation(class_4935.method_25824(), baseRotX, baseRotY + 90, 0));
    }

    protected static class_4926 createFacingSpinDispatch(int baseRotX, int baseRotY) {
        return class_4926.method_25784((class_2769)class_2741.field_12525, (class_2769)IOrientationStrategy.SPIN).method_25800((facing, spin) -> {
            BlockOrientation orientation = BlockOrientation.get(facing, spin);
            return AE2BlockStateProvider.applyRotation(class_4935.method_25824(), orientation.getAngleX() + baseRotX, orientation.getAngleY() + baseRotY, orientation.getAngleZ());
        });
    }

    protected static class_4926 createFacingSpinDispatch() {
        return AE2BlockStateProvider.createFacingSpinDispatch(0, 0);
    }

    protected static void withOrientations(class_4922 multipart, class_4935 baseVariant) {
        AE2BlockStateProvider.withOrientations(multipart, class_4918::method_25744, baseVariant);
    }

    protected static void withOrientations(class_4922 multipart, Supplier<class_4918.class_4921> baseCondition, class_4935 baseVariant) {
        class_2680 defaultState = multipart.method_25743().method_9564();
        IOrientationStrategy strategy = IOrientationStrategy.get(defaultState);
        strategy.getAllStates(defaultState).forEach(blockState -> {
            class_4918.class_4921 condition = (class_4918.class_4921)baseCondition.get();
            for (class_2769<?> property : strategy.getProperties()) {
                AE2BlockStateProvider.addConditionTerm(condition, blockState, property);
            }
            BlockOrientation orientation = BlockOrientation.get(strategy, blockState);
            class_4935 variant = class_4935.method_25827((class_4935)baseVariant, (class_4935)baseVariant);
            multipart.method_25760((class_4918)condition, AE2BlockStateProvider.applyOrientation(variant, orientation));
        });
    }

    protected static class_4935 applyOrientation(class_4935 variant, BlockOrientation orientation) {
        return AE2BlockStateProvider.applyRotation(variant, orientation.getAngleX(), orientation.getAngleY(), orientation.getAngleZ());
    }

    protected static class_4935 applyRotation(class_4935 variant, int angleX, int angleY, int angleZ) {
        angleX = AE2BlockStateProvider.normalizeAngle(angleX);
        angleY = AE2BlockStateProvider.normalizeAngle(angleY);
        angleZ = AE2BlockStateProvider.normalizeAngle(angleZ);
        if (angleX != 0) {
            variant = variant.method_25828(class_4936.field_22885, (Object)AE2BlockStateProvider.rotationByAngle(angleX));
        }
        if (angleY != 0) {
            variant = variant.method_25828(class_4936.field_22886, (Object)AE2BlockStateProvider.rotationByAngle(angleY));
        }
        if (angleZ != 0) {
            variant = variant.method_25828(Z_ROT, (Object)AE2BlockStateProvider.rotationByAngle(angleZ));
        }
        return variant;
    }

    private static int normalizeAngle(int angle) {
        return angle - angle / 360 * 360;
    }

    private static class_4936.class_4937 rotationByAngle(int angle) {
        return switch (angle) {
            case 0 -> class_4936.class_4937.field_22890;
            case 90 -> class_4936.class_4937.field_22891;
            case 180 -> class_4936.class_4937.field_22892;
            case 270 -> class_4936.class_4937.field_22893;
            default -> throw new IllegalArgumentException("Invalid angle: " + angle);
        };
    }

    protected final class_4922 multiPartGenerator(BlockDefinition<?> blockDef) {
        class_4922 multipart = class_4922.method_25758(blockDef.block());
        this.registeredBlocks.put(blockDef.block(), () -> multipart.method_25765().getAsJsonObject());
        return multipart;
    }

    private static <T extends Comparable<T>> class_4918 addConditionTerm(class_4918.class_4921 condition, class_2680 blockState, class_2769<T> property) {
        return condition.method_25751(property, blockState.method_11654(property));
    }

    public String method_10321() {
        return super.getName() + " " + this.getClass().getName();
    }
}

