/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.annotation;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.client.guidebook.scene.annotation.AnnotationTagCompiler;
import appeng.client.guidebook.scene.annotation.InWorldBoxAnnotation;
import appeng.client.guidebook.scene.annotation.SceneAnnotation;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BoxAnnotationElementCompiler
extends AnnotationTagCompiler {
    public static final String TAG_NAME = "BoxAnnotation";

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    @Nullable
    protected SceneAnnotation createAnnotation(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Vector3f min = MdxAttrs.getVector3(compiler, errorSink, el, "min", (Vector3fc)new Vector3f());
        Vector3f max = MdxAttrs.getVector3(compiler, errorSink, el, "max", (Vector3fc)new Vector3f());
        this.ensureMinMax(min, max);
        ColorValue color = MdxAttrs.getColor(compiler, errorSink, el, "color", ConstantColor.WHITE);
        float thickness = MdxAttrs.getFloat(compiler, errorSink, el, "thickness", 0.03125f);
        boolean alwaysOnTop = MdxAttrs.getBoolean(compiler, errorSink, el, "alwaysOnTop", false);
        InWorldBoxAnnotation annotation = new InWorldBoxAnnotation(min, max, color, thickness);
        annotation.setAlwaysOnTop(alwaysOnTop);
        return annotation;
    }

    private void ensureMinMax(Vector3f min, Vector3f max) {
        for (int i = 0; i < 3; ++i) {
            float maxVal;
            float minVal = min.get(i);
            if (!(minVal > (maxVal = max.get(i)))) continue;
            min.setComponent(i, maxVal);
            max.setComponent(i, minVal);
        }
    }
}

