/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.FrameworkNetworkBuilder;
import com.mrcrayfish.framework.api.network.MessageDirection;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.platform.network.FabricHandshakeMessage;
import com.mrcrayfish.framework.platform.network.FabricMessage;
import com.mrcrayfish.framework.platform.network.FabricNetwork;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkBuilder
implements FrameworkNetworkBuilder {
    private final class_2960 id;
    private final int version;
    private final AtomicInteger idCount = new AtomicInteger(1);
    private final List<FabricMessage<?>> playMessages = new ArrayList();
    private final List<FabricHandshakeMessage<?>> handshakeMessages = new ArrayList();

    public FabricNetworkBuilder(class_2960 id, int version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public <T extends PlayMessage<T>> FrameworkNetworkBuilder registerPlayMessage(Class<T> messageClass) {
        return this.registerPlayMessage(messageClass, null);
    }

    @Override
    public <T extends PlayMessage<T>> FrameworkNetworkBuilder registerPlayMessage(Class<T> messageClass, @Nullable MessageDirection direction) {
        try {
            Constructor<T> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            PlayMessage message = (PlayMessage)constructor.newInstance(new Object[0]);
            this.playMessages.add(new FabricMessage<PlayMessage>(this.idCount.getAndIncrement(), messageClass, message::encode, message::decode, message::handle, null));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public <T extends HandshakeMessage<T>> FrameworkNetworkBuilder registerHandshakeMessage(Class<T> messageClass, boolean sendOnHandshake) {
        return this.registerHandshakeMessage(messageClass, sendOnHandshake ? FrameworkNetworkBuilder.createHandshakeMessageSupplier(messageClass) : null);
    }

    @Override
    public <T extends HandshakeMessage<T>> FrameworkNetworkBuilder registerHandshakeMessage(Class<T> messageClass, @Nullable Function<Boolean, List<Pair<String, T>>> messages) {
        try {
            Constructor<T> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            HandshakeMessage message = (HandshakeMessage)constructor.newInstance(new Object[0]);
            this.handshakeMessages.add(new FabricHandshakeMessage<HandshakeMessage>(this.idCount.getAndIncrement(), messageClass, message::encode, message::decode, message::handle, null, messages));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public FrameworkNetworkBuilder ignoreClient() {
        return this;
    }

    @Override
    public FrameworkNetworkBuilder ignoreServer() {
        return this;
    }

    @Override
    public FrameworkNetwork build() {
        if (this.handshakeMessages.size() > 0) {
            this.registerHandshakeMessage(HandshakeMessage.Acknowledge.class, false);
        }
        return new FabricNetwork(this.id, this.version, this.playMessages, this.handshakeMessages);
    }
}

