/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.LogicalEnvironment;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.ConfigProperty;
import com.mrcrayfish.framework.api.config.ConfigType;
import com.mrcrayfish.framework.api.config.FrameworkConfig;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.ServerEvents;
import com.mrcrayfish.framework.api.util.EnvironmentHelper;
import com.mrcrayfish.framework.config.ConfigWatcher;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.handshake.S2CLoginConfigData;
import com.mrcrayfish.framework.network.message.play.S2CSyncConfigData;
import com.mrcrayfish.framework.platform.Services;
import com.mrcrayfish.framework.util.ConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FrameworkConfigManager {
    private static final class_5218 WORLD_CONFIG = FrameworkConfigManager.createLevelResource("serverconfig");
    private static FrameworkConfigManager instance;
    private final Map<class_2960, FrameworkConfigImpl> configs;

    public static FrameworkConfigManager getInstance() {
        if (instance == null) {
            instance = new FrameworkConfigManager();
        }
        return instance;
    }

    private FrameworkConfigManager() {
        HashMap configs = new HashMap();
        Services.CONFIG.getAllFrameworkConfigs().forEach(pair -> {
            ConfigScanData data = ConfigScanData.analyze((FrameworkConfig)pair.getLeft(), pair.getRight());
            FrameworkConfigImpl entry = new FrameworkConfigImpl(data);
            configs.put(entry.getName(), entry);
        });
        this.configs = ImmutableMap.copyOf(configs);
        ServerEvents.STARTING.register(this::onServerStarting);
        ServerEvents.STOPPED.register(this::onServerStopped);
        ClientConnectionEvents.LOGGING_OUT.register(this::onClientDisconnect);
    }

    public List<FrameworkConfigImpl> getConfigs() {
        return ImmutableList.copyOf(this.configs.values());
    }

    @Nullable
    public FrameworkConfigImpl getConfig(class_2960 id) {
        return this.configs.get(id);
    }

    public List<Pair<String, S2CLoginConfigData>> getMessagesForLogin(boolean local) {
        if (local) {
            return Collections.emptyList();
        }
        return this.configs.values().stream().filter(entry -> entry.getType().isSync()).map(entry -> {
            class_2960 key = entry.getName();
            byte[] data = ConfigHelper.getBytes(entry.config);
            return Pair.of((Object)("FrameworkConfig " + String.valueOf(key)), (Object)new S2CLoginConfigData(key, data));
        }).collect(Collectors.toList());
    }

    public boolean processConfigData(S2CLoginConfigData message) {
        Constants.LOG.info("Loading synced config from server: " + String.valueOf(message.getKey()));
        FrameworkConfigImpl entry = this.configs.get(message.getKey());
        if (entry != null && entry.getType().isSync()) {
            return entry.loadFromData(message.getData());
        }
        return false;
    }

    public void onClientDisconnect(@Nullable class_2535 connection) {
        if (connection != null && !connection.method_10756()) {
            Constants.LOG.info("Unloading synced configs from server");
            this.configs.values().stream().filter(entry -> entry.getType().isSync()).forEach(entry -> entry.unload(true));
        }
    }

    public boolean processSyncData(S2CSyncConfigData message) {
        FrameworkConfigImpl frameworkConfig = this.configs.get(message.id());
        if (frameworkConfig == null) {
            Constants.LOG.error("Server sent data for a config that doesn't exist: {}", (Object)message.id());
            return false;
        }
        if (frameworkConfig.isReadOnly()) {
            Constants.LOG.error("Server sent data for a read-only config '{}'. This should not happen!", (Object)message.id());
            return false;
        }
        if (!frameworkConfig.getType().isSync()) {
            Constants.LOG.error("Server sent data for non-sync config '{}'. This should not happen!", (Object)message.id());
            return false;
        }
        if (!frameworkConfig.isLoaded()) {
            Constants.LOG.error("Tried to perform sync update on an unloaded config. Something went wrong...");
            return false;
        }
        try {
            UnmodifiableConfig unmodifiableConfig;
            CommentedConfig config = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            if (!frameworkConfig.isCorrect((UnmodifiableConfig)config)) {
                Constants.LOG.warn("Correcting synced config data during update for config: {}", (Object)frameworkConfig.getFileName());
                frameworkConfig.correct((UnmodifiableConfig)config);
            }
            if ((unmodifiableConfig = frameworkConfig.config) instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.putAll((UnmodifiableConfig)config);
                frameworkConfig.allProperties.forEach(AbstractProperty::invalidateCache);
                FrameworkConfigEvents.RELOAD.post().handle(frameworkConfig.source);
                Constants.LOG.debug("Successfully processed sync update for config: {}", (Object)message.id());
                return true;
            }
        }
        catch (ParsingException e) {
            Constants.LOG.error("Received malformed config data");
            e.printStackTrace();
        }
        catch (Exception e) {
            Constants.LOG.error("An exception was thrown when processing config data: {}", (Object)e.toString());
            e.printStackTrace();
        }
        return false;
    }

    private void onServerStarting(MinecraftServer server) {
        Constants.LOG.info("Loading server configs...");
        Path serverConfig = server.method_27050(WORLD_CONFIG);
        FrameworkConfigManager.createDirectory(serverConfig);
        this.configs.values().forEach(entry -> {
            switch (entry.configType) {
                case WORLD: 
                case WORLD_SYNC: {
                    entry.load(serverConfig, true);
                    break;
                }
                case SERVER: 
                case SERVER_SYNC: {
                    entry.load(Services.CONFIG.getConfigPath(), true);
                    break;
                }
                case DEDICATED_SERVER: {
                    if (EnvironmentHelper.getEnvironment() != Environment.DEDICATED_SERVER) break;
                    entry.load(Services.CONFIG.getConfigPath(), true);
                }
            }
        });
    }

    private void onServerStopped(MinecraftServer server) {
        Constants.LOG.info("Unloading server configs...");
        this.configs.values().stream().filter(config -> {
            if (server.method_3816()) {
                return true;
            }
            return config.getType().isServer();
        }).forEach(entry -> entry.unload(true));
        Constants.LOG.info("Finished unloading server configs");
        if (server.method_3816()) {
            ConfigWatcher.get().stop();
        }
    }

    public void loadDefaultSyncConfigsIfUnloaded() {
        this.configs.values().stream().filter(config -> config.getType().isSync()).forEach(config -> {
            if (!config.isLoaded()) {
                config.loadWithDefaults();
            }
        });
    }

    private static boolean isValidSeparator(char c) {
        return c == '.' || c == '-';
    }

    private static CommentedConfig createFrameworkConfig(@Nullable Path folder, String id, char separator, String name) {
        if (folder != null) {
            String fileName = String.format("%s%s%s.toml", id, Character.valueOf(separator), name);
            File file = new File(folder.toFile(), fileName);
            return (CommentedConfig)CommentedFileConfig.builder((File)file).autosave().sync().onFileNotFound((file1, configFormat) -> FrameworkConfigManager.initConfig(file1, configFormat, fileName)).build();
        }
        return CommentedConfig.inMemory();
    }

    private static UnmodifiableCommentedConfig createReadOnlyConfig(Path folder, String id, char separator, String name, Consumer<Config> corrector) {
        CommentedFileConfig temp = FrameworkConfigManager.createTempConfig(folder, id, separator, name);
        ConfigHelper.loadConfig((UnmodifiableConfig)temp);
        corrector.accept((Config)temp);
        CommentedConfig config = CommentedConfig.inMemory();
        config.putAll((UnmodifiableConfig)temp);
        temp.close();
        return config.unmodifiable();
    }

    private static CommentedFileConfig createTempConfig(Path folder, String id, char separator, String name) {
        String fileName = String.format("%s%s%s.toml", id, Character.valueOf(separator), name);
        File file = new File(folder.toFile(), fileName);
        return (CommentedFileConfig)CommentedFileConfig.builder((File)file).sync().onFileNotFound((file1, configFormat) -> FrameworkConfigManager.initConfig(file1, configFormat, fileName)).build();
    }

    private static boolean initConfig(Path file, ConfigFormat<?> format, String fileName) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path defaultConfigPath = Services.CONFIG.getGamePath().resolve(Services.CONFIG.getDefaultConfigPath());
        Path defaultConfigFile = defaultConfigPath.resolve(fileName);
        if (Files.exists(defaultConfigFile, new LinkOption[0])) {
            Files.copy(defaultConfigFile, file, new CopyOption[0]);
            return true;
        }
        Files.createFile(file, new FileAttribute[0]);
        format.initEmptyFile(file);
        return false;
    }

    private static ConfigSpec createSpec(Set<AbstractProperty<?>> properties) {
        ConfigSpec spec = new ConfigSpec();
        properties.forEach(p -> p.defineSpec(spec));
        return spec;
    }

    private static CommentedConfig createComments(ConfigSpec spec, Map<List<String>, String> comments) {
        CommentedConfig config = CommentedConfig.inMemory();
        spec.correct((Config)config);
        comments.forEach((arg_0, arg_1) -> ((CommentedConfig)config).setComment(arg_0, arg_1));
        return config;
    }

    private static void createDirectory(Path path) {
        try {
            PathUtils.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class_5218 createLevelResource(String path) {
        try {
            Constructor constructor = class_5218.class.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (class_5218)constructor.newInstance(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final class FrameworkConfigImpl {
        private final Object source;
        private final String id;
        private final String name;
        private final boolean readOnly;
        private final char separator;
        private final ConfigType configType;
        private final Set<AbstractProperty<?>> allProperties;
        private final ConfigSpec spec;
        private final ClassLoader classLoader;
        private final CommentedConfig comments;
        @Nullable
        private UnmodifiableConfig config;
        private boolean watched;
        private final Lock lock;

        private FrameworkConfigImpl(ConfigScanData data) {
            Preconditions.checkArgument((!data.getConfig().id().trim().isEmpty() ? 1 : 0) != 0, (Object)"The 'id' of the config cannot be empty");
            Preconditions.checkArgument((boolean)Services.PLATFORM.isModLoaded(data.getConfig().id()), (Object)"The 'id' of the config must match a mod id");
            Preconditions.checkArgument((!data.getConfig().name().trim().isEmpty() ? 1 : 0) != 0, (Object)"The 'name' of the config cannot be empty");
            Preconditions.checkArgument((data.getConfig().name().length() <= 64 ? 1 : 0) != 0, (Object)"The 'name' of the config must be 64 characters or less");
            Preconditions.checkArgument((boolean)FrameworkConfigManager.isValidSeparator(data.getConfig().separator()), (Object)"The 'separator' of the config is invalid. It can only be '.' or '-'");
            this.source = data.getSource();
            this.id = data.getConfig().id();
            this.name = data.getConfig().name();
            this.readOnly = data.getConfig().readOnly();
            this.configType = data.getConfig().type();
            this.separator = data.getConfig().separator();
            this.allProperties = ImmutableSet.copyOf(data.getProperties());
            this.spec = FrameworkConfigManager.createSpec(this.allProperties);
            this.comments = FrameworkConfigManager.createComments(this.spec, data.getComments());
            this.classLoader = Thread.currentThread().getContextClassLoader();
            this.lock = new ReentrantLock();
            if (!this.configType.isServer()) {
                if (this.configType == ConfigType.MEMORY) {
                    this.load(null, true);
                } else {
                    this.load(Services.CONFIG.getConfigPath(), true);
                }
            }
        }

        public void load(@Nullable Path configDir, boolean watch) {
            Optional<Environment> env = this.getType().getEnv();
            if (env.isPresent() && !EnvironmentHelper.getEnvironment().equals((Object)env.get())) {
                return;
            }
            if (this.config != null) {
                Constants.LOG.warn("Attempting to load the config '{}', however it is already loaded. This should not happen, however it will simply be reloaded.", (Object)this.getName());
                this.unload(true);
            }
            this.lock(() -> {
                UnmodifiableConfig config = this.createConfig(configDir);
                ConfigHelper.loadConfig(config);
                this.correct(config);
                this.allProperties.forEach(p -> p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly)));
                this.config = config;
            });
            if (!this.readOnly && this.configType != ConfigType.MEMORY && watch && ConfigWatcher.get().watch(this.config, this::changeCallback)) {
                this.watched = true;
            }
        }

        public boolean loadFromData(byte[] data) {
            Preconditions.checkState((boolean)EnvironmentHelper.getEnvironment().isClient(), (Object)"Configs can only be loaded from data on the client");
            this.unload(false);
            try {
                Preconditions.checkState((boolean)this.configType.isServer(), (Object)"Only server configs can be loaded from data");
                CommentedConfig commentedConfig = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(data));
                if (!this.spec.isCorrect((Config)commentedConfig)) {
                    Constants.LOG.warn("Correcting config data from server for config: {}", (Object)this.getFileName());
                    this.correct((UnmodifiableConfig)commentedConfig);
                }
                this.lock(() -> {
                    CommentedConfig config = this.isReadOnly() ? commentedConfig.unmodifiable() : commentedConfig;
                    this.allProperties.forEach(arg_0 -> this.lambda$loadFromData$2((UnmodifiableConfig)config, arg_0));
                    this.config = config;
                });
                FrameworkConfigEvents.LOAD.post().handle(this.source);
                return true;
            }
            catch (ParsingException e) {
                Constants.LOG.info("Failed to parse config data: {}", (Object)e.toString());
                return false;
            }
            catch (Exception e) {
                Constants.LOG.info("An exception occurred when loading config data: {}", (Object)e.toString());
                this.unload(false);
                return false;
            }
        }

        private void loadWithDefaults() {
            this.unload(false);
            Constants.LOG.info("Loading default config for {}", (Object)this.getName());
            this.lock(() -> {
                CommentedConfig commentedConfig = CommentedConfig.inMemory();
                this.correct((UnmodifiableConfig)commentedConfig);
                CommentedConfig config = this.isReadOnly() ? commentedConfig.unmodifiable() : commentedConfig;
                this.allProperties.forEach(arg_0 -> this.lambda$loadWithDefaults$4((UnmodifiableConfig)config, arg_0));
                this.config = config;
            });
            FrameworkConfigEvents.LOAD.post().handle(this.source);
        }

        public UnmodifiableConfig createConfig(@Nullable Path configDir) {
            if (this.readOnly) {
                Preconditions.checkArgument((configDir != null ? 1 : 0) != 0, (Object)"Config dir must not be null for read only configs");
                return FrameworkConfigManager.createReadOnlyConfig(configDir, this.id, this.separator, this.name, this::correct);
            }
            return FrameworkConfigManager.createFrameworkConfig(configDir, this.id, this.separator, this.name);
        }

        public void unload(boolean sendEvent) {
            if (this.config != null) {
                this.lock(() -> {
                    this.allProperties.forEach(p -> p.updateProxy(ValueProxy.EMPTY));
                    if (this.watched) {
                        ConfigWatcher.get().unwatch(this.config);
                        this.watched = false;
                    }
                    ConfigHelper.closeConfig(this.config);
                    this.config = null;
                });
                if (sendEvent) {
                    Constants.LOG.info("Sending config unload event for {}", (Object)this.getFileName());
                    FrameworkConfigEvents.UNLOAD.post().handle(this.source);
                }
            }
        }

        private void changeCallback() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.config != null && !this.isReadOnly()) {
                this.lock(() -> {
                    ConfigHelper.loadConfig(this.config);
                    this.correct(this.config);
                    this.allProperties.forEach(AbstractProperty::invalidateCache);
                });
                EnvironmentHelper.submitOn(EnvironmentHelper.getEnvironment(), () -> () -> FrameworkConfigEvents.RELOAD.post().handle(this.source));
                EnvironmentHelper.submitOn(LogicalEnvironment.SERVER, () -> () -> {
                    if (this.getType().isSync()) {
                        Network.getPlayChannel().sendToAll(new S2CSyncConfigData(this.getName(), this.getData()));
                    }
                });
            }
        }

        public boolean isCorrect(UnmodifiableConfig config) {
            if (config instanceof CommentedConfig) {
                CommentedConfig c = (CommentedConfig)config;
                for (AbstractProperty<?> prop : this.allProperties) {
                    String configComment;
                    String propComment = prop.getComment();
                    if (propComment.isBlank() || propComment.equals(configComment = c.getComment(prop.getPath()))) continue;
                    return false;
                }
            }
            if (config instanceof Config) {
                return this.spec.isCorrect((Config)config);
            }
            return true;
        }

        public void correct(UnmodifiableConfig config) {
            if (config instanceof Config && !this.isCorrect(config)) {
                Constants.LOG.debug("Correcting config: {}", (Object)this.getFileName());
                ConfigHelper.createBackup(config);
                this.spec.correct((Config)config, (action, path, incorrectValue, correctedValue) -> {
                    switch (action) {
                        case ADD: {
                            Constants.LOG.debug("Adding config value at path '{}' with {}", (Object)String.join((CharSequence)".", path), correctedValue);
                            break;
                        }
                        case REPLACE: {
                            Constants.LOG.debug("Replacing config value at path '{}' from '{}' with '{}'", new Object[]{String.join((CharSequence)".", path), incorrectValue, correctedValue});
                            break;
                        }
                        case REMOVE: {
                            Constants.LOG.debug("Removing config value at path '{}'", (Object)String.join((CharSequence)".", path));
                        }
                    }
                });
                if (config instanceof CommentedConfig) {
                    CommentedConfig c = (CommentedConfig)config;
                    c.putAllComments((UnmodifiableCommentedConfig)this.comments);
                }
                ConfigHelper.saveConfig(config);
            }
        }

        public boolean isChanged() {
            if ((this.configType == ConfigType.WORLD || this.configType == ConfigType.WORLD_SYNC) && this.config == null) {
                return false;
            }
            if (this.getType() == ConfigType.MEMORY && this.config == null) {
                return false;
            }
            if (this.config != null) {
                return this.allProperties.stream().anyMatch(property -> !property.isDefault());
            }
            CommentedFileConfig tempConfig = FrameworkConfigManager.createTempConfig(Services.CONFIG.getConfigPath(), this.id, this.separator, this.name);
            ConfigHelper.loadConfig((UnmodifiableConfig)tempConfig);
            this.correct((UnmodifiableConfig)tempConfig);
            tempConfig.putAllComments((UnmodifiableCommentedConfig)this.comments);
            this.allProperties.forEach(p -> p.updateProxy(new ValueProxy((UnmodifiableConfig)tempConfig, p.getPath(), this.readOnly)));
            boolean changed = this.allProperties.stream().anyMatch(property -> !property.isDefault());
            this.allProperties.forEach(p -> p.updateProxy(ValueProxy.EMPTY));
            tempConfig.close();
            return changed;
        }

        public void restoreDefaults() {
            if (this.readOnly) {
                return;
            }
            if ((this.configType == ConfigType.WORLD || this.configType == ConfigType.WORLD_SYNC) && this.config == null) {
                return;
            }
            if (this.config != null) {
                this.allProperties.forEach(AbstractProperty::restoreDefault);
                return;
            }
            CommentedFileConfig tempConfig = FrameworkConfigManager.createTempConfig(Services.CONFIG.getConfigPath(), this.id, this.separator, this.name);
            ConfigHelper.loadConfig((UnmodifiableConfig)tempConfig);
            this.correct((UnmodifiableConfig)tempConfig);
            tempConfig.putAllComments((UnmodifiableCommentedConfig)this.comments);
            this.allProperties.forEach(property -> tempConfig.set(property.getPath(), property.getDefaultValue()));
            ConfigHelper.saveConfig((UnmodifiableConfig)tempConfig);
            tempConfig.close();
        }

        private void lock(Runnable runnable) {
            this.lock.lock();
            try {
                runnable.run();
            }
            finally {
                this.lock.unlock();
            }
        }

        public class_2960 getName() {
            return new class_2960(this.id, this.name);
        }

        public ConfigType getType() {
            return this.configType;
        }

        public String getFileName() {
            return String.format("%s%s%s.toml", this.id, Character.valueOf(this.separator), this.name);
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isLoaded() {
            return this.config != null;
        }

        @Nullable
        public byte[] getData() {
            return this.config != null ? ConfigHelper.getBytes(this.config) : null;
        }

        public Object getSource() {
            return this.source;
        }

        @Nullable
        public UnmodifiableConfig getConfig() {
            return this.config;
        }

        public Set<AbstractProperty<?>> getAllProperties() {
            return this.allProperties;
        }

        public ConfigSpec getSpec() {
            return this.spec;
        }

        public CommentedConfig getComments() {
            return this.comments;
        }

        public char getSeparator() {
            return this.separator;
        }

        private /* synthetic */ void lambda$loadWithDefaults$4(UnmodifiableConfig config, AbstractProperty p) {
            p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly));
        }

        private /* synthetic */ void lambda$loadFromData$2(UnmodifiableConfig config, AbstractProperty p) {
            p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly));
        }
    }

    private static class ConfigScanData {
        private final FrameworkConfig config;
        private final Object source;
        private final Set<AbstractProperty<?>> properties = new HashSet();
        private final Map<List<String>, String> comments = new HashMap<List<String>, String>();

        private ConfigScanData(FrameworkConfig config, Object source) {
            this.config = config;
            this.source = source;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }

        public Object getSource() {
            return this.source;
        }

        public Set<AbstractProperty<?>> getProperties() {
            return this.properties;
        }

        public Map<List<String>, String> getComments() {
            return this.comments;
        }

        private static ConfigScanData analyze(FrameworkConfig config, Object source) {
            Preconditions.checkArgument((!source.getClass().isPrimitive() ? 1 : 0) != 0, (Object)"FrameworkConfig annotation can only be applied to objects");
            ConfigScanData data = new ConfigScanData(config, source);
            data.scan(new Stack<String>(), source);
            return data;
        }

        private void scan(Stack<String> stack, Object instance) {
            Field[] fields = instance.getClass().getDeclaredFields();
            Stream.of(fields).forEach(field -> Optional.ofNullable(field.getDeclaredAnnotation(ConfigProperty.class)).ifPresent(prop -> {
                stack.push(prop.name());
                try {
                    field.setAccessible(true);
                    Object obj = field.get(instance);
                    String comment = this.pushComment(stack, (ConfigProperty)prop, obj);
                    if (obj instanceof AbstractProperty) {
                        AbstractProperty property = (AbstractProperty)obj;
                        ArrayList<String> path = new ArrayList<String>(stack);
                        String key = String.format("framework_config.%s.%s.%s", this.config.id(), this.config.name(), StringUtils.join(path, (char)'.'));
                        property.initProperty(new PropertyData(prop.name(), path, key, comment, prop.worldRestart(), prop.gameRestart()));
                        this.properties.add(property);
                    } else {
                        this.scan(stack, obj);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                stack.pop();
            }));
        }

        private String pushComment(Stack<String> stack, ConfigProperty prop, Object obj) {
            if (!prop.comment().isBlank()) {
                AbstractProperty property;
                String hint;
                Object comment = prop.comment();
                if (obj instanceof AbstractProperty && !(hint = (property = (AbstractProperty)obj).getAllowedValuesString()).isBlank()) {
                    comment = (String)comment + "\n" + hint;
                }
                comment = " " + ((String)comment).replace("\n", "\n ");
                this.comments.put(new ArrayList<String>(stack), (String)comment);
                return comment;
            }
            return "";
        }
    }

    public static interface IMapEntry {
    }

    public static class PropertyData {
        private final String name;
        private final List<String> path;
        private final String translationKey;
        private final String comment;
        private final boolean worldRestart;
        private final boolean gameRestart;

        private PropertyData(String name, List<String> path, String translationKey, String comment, boolean worldRestart, boolean gameRestart) {
            this.name = name;
            this.path = ImmutableList.copyOf(path);
            this.translationKey = translationKey;
            this.comment = comment;
            this.worldRestart = worldRestart;
            this.gameRestart = gameRestart;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean requiresWorldRestart() {
            return this.worldRestart;
        }

        public boolean requiresGameRestart() {
            return this.gameRestart;
        }
    }

    public static class ValueProxy {
        private static final ValueProxy EMPTY = new ValueProxy();
        private final UnmodifiableConfig config;
        private final List<String> path;
        private final boolean readOnly;

        private ValueProxy() {
            this.config = null;
            this.path = null;
            this.readOnly = true;
        }

        private ValueProxy(UnmodifiableConfig config, List<String> path, boolean readOnly) {
            this.config = config;
            this.path = path;
            this.readOnly = readOnly;
        }

        public boolean isLinked() {
            return this != EMPTY;
        }

        public boolean isWritable() {
            return !this.readOnly;
        }

        @Nullable
        public <T> T get(BiFunction<UnmodifiableConfig, List<String>, T> function) {
            if (this.isLinked() && this.config != null) {
                return function.apply(this.config, this.path);
            }
            return null;
        }

        public <T> void set(T value) {
            UnmodifiableConfig unmodifiableConfig;
            if (this.isLinked() && this.isWritable() && (unmodifiableConfig = this.config) instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.set(this.path, value);
            }
        }
    }
}

