/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid;

import dev.architectury.fluid.fabric.FluidStackImpl;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FluidStack {
    private static final FluidStackAdapter<Object> ADAPTER = FluidStack.adapt(FluidStack::getValue, FluidStack::new);
    private static final FluidStack EMPTY = FluidStack.create(class_3612.field_15906, 0L);
    private Object value;

    private FluidStack(Supplier<class_3611> fluid, long amount, class_2487 tag) {
        this(ADAPTER.create(fluid, amount, tag));
    }

    private FluidStack(Object value) {
        this.value = Objects.requireNonNull(value);
    }

    private Object getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static FluidStackAdapter<Object> adapt(Function<FluidStack, Object> toValue, Function<Object, FluidStack> fromValue) {
        void var1_1;
        return FluidStackImpl.adapt(toValue, (Function<Object, FluidStack>)var1_1);
    }

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return FluidStack.create(() -> fluid, amount, tag);
    }

    public static FluidStack create(class_3611 fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(Supplier<class_3611> fluid, long amount, @Nullable class_2487 tag) {
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack create(Supplier<class_3611> fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getRawFluidSupplier(), amount, stack.getTag());
    }

    public static long bucketAmount() {
        return FluidStackHooks.bucketAmount();
    }

    public class_3611 getFluid() {
        return this.isEmpty() ? class_3612.field_15906 : this.getRawFluid();
    }

    @Nullable
    public class_3611 getRawFluid() {
        return ADAPTER.getFluid(this.value);
    }

    public Supplier<class_3611> getRawFluidSupplier() {
        return ADAPTER.getRawFluidSupplier(this.value);
    }

    public boolean isEmpty() {
        return this.getRawFluid() == class_3612.field_15906 || ADAPTER.getAmount(this.value) <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : ADAPTER.getAmount(this.value);
    }

    public void setAmount(long amount) {
        ADAPTER.setAmount(this.value, amount);
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public boolean hasTag() {
        return this.getTag() != null;
    }

    @Nullable
    public class_2487 getTag() {
        return ADAPTER.getTag(this.value);
    }

    public void setTag(@Nullable class_2487 tag) {
        ADAPTER.setTag(this.value, tag);
    }

    public class_2487 getOrCreateTag() {
        class_2487 tag = this.getTag();
        if (tag == null) {
            tag = new class_2487();
            this.setTag(tag);
            return tag;
        }
        return tag;
    }

    @Nullable
    public class_2487 getChildTag(String childName) {
        class_2487 tag = this.getTag();
        if (tag == null) {
            return null;
        }
        return tag.method_10562(childName);
    }

    public class_2487 getOrCreateChildTag(String childName) {
        class_2487 tag = this.getOrCreateTag();
        class_2487 child = tag.method_10562(childName);
        if (!tag.method_10573(childName, 10)) {
            tag.method_10566(childName, (class_2520)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        class_2487 tag = this.getTag();
        if (tag != null) {
            tag.method_10551(childName);
        }
    }

    public class_2561 getName() {
        return FluidStackHooks.getName(this);
    }

    public String getTranslationKey() {
        return FluidStackHooks.getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(ADAPTER.copy(this.value));
    }

    public int hashCode() {
        return ADAPTER.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidStackEqual((FluidStack)o);
    }

    public boolean isFluidStackEqual(FluidStack other) {
        return this.getFluid() == other.getFluid() && this.getAmount() == other.getAmount() && this.isTagEqual(other);
    }

    public boolean isFluidEqual(FluidStack other) {
        return this.getFluid() == other.getFluid();
    }

    public boolean isTagEqual(FluidStack other) {
        class_2487 tag = this.getTag();
        class_2487 otherTag = other.getTag();
        return Objects.equals(tag, otherTag);
    }

    public static FluidStack read(class_2540 buf) {
        return FluidStackHooks.read(buf);
    }

    public static FluidStack read(class_2487 tag) {
        return FluidStackHooks.read(tag);
    }

    public void write(class_2540 buf) {
        FluidStackHooks.write(this, buf);
    }

    public class_2487 write(class_2487 tag) {
        return FluidStackHooks.write(this, tag);
    }

    public FluidStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return this;
        }
        return new FluidStack(this.getRawFluidSupplier(), amount, this.getTag());
    }

    @ApiStatus.Internal
    public static void init() {
    }

    @ApiStatus.Internal
    public static interface FluidStackAdapter<T> {
        public T create(Supplier<class_3611> var1, long var2, class_2487 var4);

        public Supplier<class_3611> getRawFluidSupplier(T var1);

        public class_3611 getFluid(T var1);

        public long getAmount(T var1);

        public void setAmount(T var1, long var2);

        public class_2487 getTag(T var1);

        public void setTag(T var1, class_2487 var2);

        public T copy(T var1);

        public int hashCode(T var1);
    }
}

