/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.MIPipesClient;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class PipeBakedModel
implements class_1087,
FabricBakedModel {
    private final class_1058 particleSprite;
    private final Map<PipeRenderer.Factory, PipeRenderer> renderers;
    private final class_1087[] meWireConnectors;
    private final RenderMaterial translucentMaterial;
    private static final RenderContext.QuadTransform ITEM_TRANSFORM = quad -> {
        for (int i = 0; i < 4; ++i) {
            Vector3f pos = quad.copyPos(i, null);
            quad.pos(i, pos.x(), pos.y() * 2.0f - 0.5f, pos.z() * 2.0f - 0.5f);
        }
        return quad.tag() != 1;
    };

    public PipeBakedModel(class_1058 particleSprite, Map<PipeRenderer.Factory, PipeRenderer> renderers, @Nullable class_1087[] meWireConnectors, RenderMaterial translucentMaterial) {
        this.particleSprite = particleSprite;
        this.renderers = renderers;
        this.meWireConnectors = meWireConnectors;
        this.translucentMaterial = translucentMaterial;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockRenderView, class_2680 state, class_2338 pos, Supplier<class_5819> supplier, RenderContext renderContext) {
        Object maybeAttachment = ((RenderAttachedBlockView)blockRenderView).getBlockEntityRenderAttachment(pos);
        if (maybeAttachment instanceof PipeBlockEntity.RenderAttachment) {
            PipeBlockEntity.RenderAttachment attachment = (PipeBlockEntity.RenderAttachment)maybeAttachment;
            class_2680 camouflage = attachment.camouflage();
            if (camouflage == null || MIPipesClient.transparentCamouflage) {
                int centerSlots = attachment.types().length;
                for (int slot = 0; slot < centerSlots; ++slot) {
                    int color = attachment.types()[slot].getColor();
                    renderContext.pushTransform(PipeBakedModel.getColorTransform(color));
                    this.renderers.get(PipeRenderer.get(attachment.types()[slot])).draw(blockRenderView, pos, renderContext, slot, attachment.renderedConnections(), attachment.customData()[slot]);
                    renderContext.popTransform();
                }
                boolean hasMeWire = false;
                if (this.meWireConnectors != null) {
                    for (PipeNetworkType type : attachment.types()) {
                        if (!type.getIdentifier().method_12832().endsWith("me_wire")) continue;
                        hasMeWire = true;
                    }
                }
                if (hasMeWire) {
                    for (class_2350 direction : class_2350.values()) {
                        boolean renderConnector = false;
                        for (int slot = 0; slot < attachment.types().length; ++slot) {
                            PipeEndpointType conn = attachment.renderedConnections()[slot][direction.method_10146()];
                            if (conn != PipeEndpointType.BLOCK || !attachment.types()[slot].getIdentifier().method_12832().endsWith("me_wire")) continue;
                            renderConnector = true;
                        }
                        if (!renderConnector) continue;
                        this.meWireConnectors[direction.method_10146()].emitBlockQuads(blockRenderView, state, pos, supplier, renderContext);
                    }
                }
            }
            if (camouflage != null) {
                renderContext.pushTransform(quad -> {
                    if (quad.colorIndex() != -1) {
                        class_324 blockColorMap = class_310.method_1551().method_1505();
                        int color = 0xFF000000 | blockColorMap.method_1697(camouflage, blockRenderView, pos, quad.colorIndex());
                        quad.colorIndex(-1);
                        for (int vertex = 0; vertex < 4; ++vertex) {
                            quad.color(vertex, PipeBakedModel.multiplyColor(color, quad.color(vertex)));
                        }
                    }
                    if (MIPipesClient.transparentCamouflage) {
                        quad.material(this.translucentMaterial);
                        for (int vertex = 0; vertex < 4; ++vertex) {
                            quad.color(vertex, PipeBakedModel.multiplyColor(-1610612737, quad.color(vertex)));
                        }
                    }
                    return true;
                });
                class_1087 camouflageModel = class_310.method_1551().method_1541().method_3349(camouflage);
                camouflageModel.emitBlockQuads(blockRenderView, state, pos, supplier, renderContext);
                renderContext.popTransform();
            }
        }
    }

    private static int multiplyColor(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        if (color2 == -1) {
            return color1;
        }
        int alpha = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        int red = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int green = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int blue = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public void emitItemQuads(class_1799 itemStack, Supplier<class_5819> supplier, RenderContext renderContext) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof PipeItem) {
            PipeNetworkType type = ((PipeItem)item).type;
            int color = type.getColor();
            renderContext.pushTransform(PipeBakedModel.getColorTransform(color));
            renderContext.pushTransform(ITEM_TRANSFORM);
            PipeEndpointType[][] connections = new PipeEndpointType[][]{{null, null, null, null, PipeEndpointType.BLOCK, PipeEndpointType.BLOCK}};
            this.renderers.get(PipeRenderer.get(type)).draw(null, null, renderContext, 0, connections, new class_2487());
            renderContext.popTransform();
            renderContext.popTransform();
        }
    }

    private static RenderContext.QuadTransform getColorTransform(int color) {
        return quad -> {
            if (quad.tag() == 0) {
                quad.color(color, color, color, color);
            }
            return true;
        };
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, class_5819 random) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleSprite;
    }

    public class_809 method_4709() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

