/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TemperatureBarClient
implements GuiComponentClient {
    public final TemperatureBar.Parameters params;
    public int temperature;

    public TemperatureBarClient(class_2540 buf) {
        this.params = new TemperatureBar.Parameters(buf.readInt(), buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.temperature = buf.readInt();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        private final MIIdentifier TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
        private final int WIDTH = 100;
        private final int HEIGHT = 2;

        @Override
        public void renderBackground(class_332 guiGraphics, int x, int y) {
            guiGraphics.method_25290((class_2960)this.TEXTURE, x + TemperatureBarClient.this.params.renderX - 1, y + TemperatureBarClient.this.params.renderY - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            int barPixels = (int)((float)TemperatureBarClient.this.temperature / (float)TemperatureBarClient.this.params.temperatureMax * 100.0f);
            guiGraphics.method_25290((class_2960)this.TEXTURE, x + TemperatureBarClient.this.params.renderX, y + TemperatureBarClient.this.params.renderY, 0.0f, 0.0f, barPixels, 2, 102, 6);
            guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, x + TemperatureBarClient.this.params.renderX - 22, y + TemperatureBarClient.this.params.renderY + 1 - 10, 144, 0, 20, 20);
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_327 font, class_332 guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(TemperatureBarClient.this.params.renderX, TemperatureBarClient.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                guiGraphics.method_51438(font, (class_2561)MIText.Temperature.text(TemperatureBarClient.this.temperature), cursorX, cursorY);
            }
        }
    }
}

