/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.LargeTankFluidDisplay;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelectionClient;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class LargeTankFluidDisplayClient
implements GuiComponentClient {
    LargeTankFluidDisplay.Data fluidData;

    public LargeTankFluidDisplayClient(class_2540 buf) {
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.fluidData = new LargeTankFluidDisplay.Data(FluidVariant.fromPacket((class_2540)buf), buf.readLong(), buf.readLong());
    }

    @Override
    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){
            private static final int posX = 70;
            private static final int posY = 12;

            @Override
            public void renderBackground(class_332 guiGraphics, int leftPos, int topPos) {
                FluidVariant fluid = LargeTankFluidDisplayClient.this.fluidData.fluid();
                float fracFull = (float)LargeTankFluidDisplayClient.this.fluidData.amount() / (float)LargeTankFluidDisplayClient.this.fluidData.capacity();
                guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, leftPos + 70, topPos + 12, 92, 38, 46, 62);
                RenderSystem.disableBlend();
                if (!fluid.isBlank()) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            float localFullness = Math.min(Math.max(3.0f * fracFull - (float)(2 - j), 0.0f), 1.0f);
                            RenderHelper.drawFluidInGui(guiGraphics, fluid, leftPos + 70 + 7 + i * 16, (float)(topPos + 12 + 7 + j * 16) + (1.0f - localFullness) * 16.0f, 16, localFullness);
                        }
                    }
                }
                RenderSystem.enableBlend();
                guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, leftPos + 70 + 7, topPos + 12 + 7, 60, 38, 32, 48);
                ShapeSelectionClient shapeSelection = ((MachineMenuClient)machineScreen.method_17577()).getComponent(ShapeSelectionClient.class);
                ShapeSelectionClient.Renderer renderer = Objects.requireNonNull(shapeSelection).getRenderer();
                if (renderer.isPanelOpen) {
                    Rectangle shapePanelBox = renderer.getBox(leftPos, topPos);
                    int[] selectedShape = shapeSelection.currentData;
                    long capacity = LargeTankMultiblockBlockEntity.getCapacityFromComponents(selectedShape[0], selectedShape[1], selectedShape[2]);
                    class_5250 capacityText = FluidHelper.getFluidAmountLarge(capacity);
                    guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)capacityText, shapePanelBox.x() + 14, shapePanelBox.y() + 14, 0x404040, false);
                }
            }

            @Override
            public void renderTooltip(MachineScreen screen, class_327 font, class_332 guiGraphics, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(77, 19, 32, 48, cursorX - x, cursorY - y)) {
                    guiGraphics.method_51437(font, FluidHelper.getTooltipForFluidStorage(LargeTankFluidDisplayClient.this.fluidData.fluid(), LargeTankFluidDisplayClient.this.fluidData.amount(), LargeTankFluidDisplayClient.this.fluidData.capacity()), Optional.empty(), cursorX, cursorY);
                }
            }
        };
    }
}

