/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.machine.component.FluidAccess;
import aztech.modern_industrialization.machines.IComponent;
import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class FluidStorageComponent
implements IComponent,
FluidAccess {
    private long capacity;
    SingleVariantStorage<FluidVariant> singleStorageVariant = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return FluidStorageComponent.this.capacity;
        }
    };

    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.singleStorageVariant;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        Preconditions.checkArgument((capacity >= 0L ? 1 : 0) != 0, (Object)"Fluid Capacity must be > 0");
        this.capacity = capacity;
        this.singleStorageVariant.amount = Math.min(this.singleStorageVariant.amount, capacity);
    }

    public FluidVariant getFluid() {
        return (FluidVariant)this.singleStorageVariant.variant;
    }

    @Override
    public long getAmount() {
        return this.singleStorageVariant.amount;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10566("fluid", (class_2520)((FluidVariant)this.singleStorageVariant.variant).toNbt());
        tag.method_10544("amount", this.singleStorageVariant.amount);
        tag.method_10544("capacity", this.capacity);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.singleStorageVariant.variant = FluidVariant.fromNbt((class_2487)tag.method_10562("fluid"));
        this.singleStorageVariant.amount = tag.method_10537("amount");
        this.capacity = tag.method_10537("capacity");
    }

    @Override
    public FluidVariant getVariant() {
        return this.getFluid();
    }
}

