/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.Collections;

public class ConfigurableTankMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final MIInventory inventory;

    public ConfigurableTankMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("configurable_tank", true).backgroundHeight(170).build(), new OrientationComponent.Params(true, false, true));
        ArrayList<ConfigurableFluidStack> stacks = new ArrayList<ConfigurableFluidStack>();
        for (int i = 0; i < 9; ++i) {
            stacks.add(ConfigurableFluidStack.standardIOSlot(1296000L, true));
        }
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlots(68, 20, 3, 3).build();
        this.inventory = new MIInventory(Collections.emptyList(), stacks, SlotPositions.empty(), fluidPositions);
        this.registerGuiComponent(new AutoExtract.Server(this.orientation));
        this.registerComponents(this.inventory);
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData(MachineCasings.CONFIGURABLE_TANK);
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (!this.field_11863.method_8608() && this.orientation.extractFluids) {
            this.inventory.autoExtractFluids(this.field_11863, this.field_11867, this.orientation.outputDirection);
        }
    }
}

