/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.FuelBurningComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class BoilerMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    public static final int WATER_SLOT_X = 50;
    public static final int WATER_SLOT_Y = 32;
    public static final int INPUT_SLOT_X = 15;
    public static final int INPUT_SLOT_Y = 32;
    public static final int OUTPUT_SLOT_X = 134;
    public static final int OUTPUT_SLOT_Y = 32;
    private final MIInventory inventory;
    private final boolean bronze;
    private final SteamHeaterComponent steamHeater;
    private final FuelBurningComponent fuelBurning;
    protected IsActiveComponent isActiveComponent;

    public BoilerMachineBlockEntity(BEP bep, boolean bronze) {
        super(bep, new MachineGuiParameters.Builder(bronze ? "bronze_boiler" : "steel_boiler", true).backgroundHeight(180).build(), new OrientationComponent.Params(false, false, false));
        int capacity = 81000 * (bronze ? 8 : 16);
        List<ConfigurableItemStack> itemStacks = Collections.singletonList(ConfigurableItemStack.standardInputSlot());
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(15, 32).build();
        List<ConfigurableFluidStack> fluidStacks = Arrays.asList(ConfigurableFluidStack.lockedInputSlot(capacity, (class_3611)class_3612.field_15910), ConfigurableFluidStack.lockedOutputSlot(capacity, MIFluids.STEAM.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(50, 32).addSlot(134, 32).build();
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.bronze = bronze;
        this.steamHeater = new SteamHeaterComponent(1500.0, bronze ? 8L : 16L, 8L, true, false, false);
        this.fuelBurning = new FuelBurningComponent(this.steamHeater, 1L);
        this.isActiveComponent = new IsActiveComponent();
        ProgressBar.Parameters progressParams = new ProgressBar.Parameters(133, 50, "furnace", true);
        TemperatureBar.Parameters temperatureParams = new TemperatureBar.Parameters(42, 75, 1500);
        this.registerGuiComponent(new ProgressBar.Server(progressParams, () -> Float.valueOf((float)this.fuelBurning.getBurningProgress())));
        this.registerGuiComponent(new TemperatureBar.Server(temperatureParams, () -> (int)this.steamHeater.getTemperature()));
        this.registerComponents(this.inventory, this.isActiveComponent, this.steamHeater, this.fuelBurning);
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData(this.bronze ? MachineCasings.BRICKED_BRONZE : MachineCasings.BRICKED_STEEL);
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.steamHeater.tick(Collections.singletonList(this.inventory.getFluidStacks().get(0)), Collections.singletonList(this.inventory.getFluidStacks().get(1)));
        this.fuelBurning.tick(Collections.singletonList(this.inventory.getItemStacks().get(0)), Collections.emptyList());
        for (class_2350 direction : class_2350.values()) {
            this.getInventory().autoExtractFluids(this.field_11863, this.field_11867, direction);
        }
        this.isActiveComponent.updateActive(this.fuelBurning.isBurning(), this);
        this.method_5431();
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.fuelBurning.getTooltips();
    }
}

