/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.FastBlockEntity;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStorageBlockEntity<T extends TransferVariant<?>>
extends FastBlockEntity
implements SingleSlotStorage<T>,
WrenchableBlockEntity {
    protected T resource;
    protected long amount;
    private long version;
    private boolean isLocked;
    public final StorageBehaviour<T> behaviour;
    private final ResourceParticipant participant = new ResourceParticipant();

    public long getVersion() {
        return this.version;
    }

    public AbstractStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.resource = this.getBlankResource();
        this.behaviour = ((AbstractStorageBlock)state.method_26204()).behavior;
    }

    @Override
    protected boolean shouldSkipComparatorUpdate() {
        return this.behaviour.isCreative();
    }

    public void onChanged() {
        ++this.version;
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            AbstractStorageBlock block = (AbstractStorageBlock)this.method_11010().method_26204();
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, block.getStack(this)));
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
        } else if (this.behaviour.isLockable()) {
            this.toggleLocked();
            player.method_7353((class_2561)(this.isLocked() ? MIText.Locked.text() : MIText.Unlocked.text()), true);
        }
        return true;
    }

    public boolean supportsExtraction() {
        return true;
    }

    public boolean supportsInsertion() {
        return !this.behaviour.isCreative();
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction, boolean ignoreLock) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        if (this.behaviour.isCreative()) {
            return 0L;
        }
        if (this.resource.isBlank() && (ignoreLock || !this.isLocked()) || this.resource.equals(resource)) {
            long inserted = Math.min(maxAmount, this.behaviour.getCapacityForResource(resource) - this.amount);
            if (inserted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount += inserted;
                this.resource = resource;
            }
            return inserted;
        }
        return 0L;
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        return this.insert(resource, maxAmount, transaction, false);
    }

    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        if (this.behaviour.isCreative()) {
            return maxAmount;
        }
        if (resource.equals(this.resource)) {
            long extracted = Math.min(maxAmount, this.amount);
            if (extracted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount -= extracted;
                if (this.amount == 0L && !this.isLocked()) {
                    this.resource = this.getBlankResource();
                }
            }
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public T getResource() {
        return this.resource;
    }

    public long getAmount() {
        if (this.isResourceBlank()) {
            return 0L;
        }
        if (!this.behaviour.isCreative()) {
            return this.amount;
        }
        return Long.MAX_VALUE;
    }

    public boolean isEmpty() {
        if (!this.behaviour.isCreative()) {
            return this.amount == 0L;
        }
        return this.resource.isBlank();
    }

    public long getCapacity() {
        return this.behaviour.getCapacityForResource(this.resource);
    }

    public boolean isLocked() {
        if (!this.behaviour.isLockable()) {
            return false;
        }
        return this.isLocked;
    }

    public void toggleLocked() {
        if (this.behaviour.isLockable()) {
            boolean bl = this.isLocked = !this.isLocked;
            if (!this.isLocked && this.amount == 0L) {
                this.resource = this.getBlankResource();
            }
            this.method_5431();
        }
    }

    public void method_11014(class_2487 tag) {
        this.resource = this.loadResource(tag);
        if (this.behaviour.isLockable()) {
            this.isLocked = tag.method_10577("locked");
        }
        if (!this.behaviour.isCreative()) {
            this.amount = tag.method_10537("amt");
            if (this.resource.isBlank()) {
                this.amount = 0L;
            }
        }
    }

    public void method_11007(class_2487 tag) {
        if (this.behaviour.isLockable()) {
            tag.method_10556("locked", this.isLocked);
        }
        if (!this.behaviour.isCreative()) {
            tag.method_10544("amt", this.amount);
        }
        this.saveResource(this.resource, tag);
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    public abstract T loadResource(class_2487 var1);

    public abstract void saveResource(T var1, class_2487 var2);

    public abstract T getBlankResource();

    private class ResourceParticipant
    extends SnapshotParticipant<ResourceAmount<T>> {
        private ResourceParticipant() {
        }

        protected ResourceAmount<T> createSnapshot() {
            return new ResourceAmount(AbstractStorageBlockEntity.this.resource, AbstractStorageBlockEntity.this.amount);
        }

        protected void readSnapshot(ResourceAmount<T> snapshot) {
            AbstractStorageBlockEntity.this.resource = (TransferVariant)snapshot.resource();
            AbstractStorageBlockEntity.this.amount = snapshot.amount();
        }

        protected void onFinalCommit() {
            AbstractStorageBlockEntity.this.onChanged();
        }
    }
}

