/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.util;

import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_3532;
import software.bernie.geckolib.util.ClientUtils;

public class ParticleValueProviders {

    public static class BoundingBoxBasedParticleWidthProvider
    implements ParticleWidthProvider {
        private double maxBoundBoxSize;
        private double maxWidth;

        public BoundingBoxBasedParticleWidthProvider(double maxBoundBoxSize, double maxWidth) {
            this.maxBoundBoxSize = maxBoundBoxSize;
            this.maxWidth = maxWidth;
        }

        @Override
        public float getWidth(EffectBuilder.Context effectContext) {
            float result = (float)this.maxWidth;
            class_239 hitResult = effectContext.getHitResult();
            if (hitResult instanceof SimpleHitResult) {
                class_238 bb;
                SimpleHitResult simpleHitResult = (SimpleHitResult)hitResult;
                int entityId = simpleHitResult.getEntityId();
                class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
                if (entity != null && (bb = entity.method_5829()) != null) {
                    result = (float)class_3532.method_15350((double)(this.maxWidth * bb.method_995() / this.maxBoundBoxSize), (double)0.0, (double)this.maxWidth);
                }
            }
            return result;
        }
    }

    public static class DamageBasedParticleCountProvider
    implements ParticleCountProvider {
        private int maxCount;
        private float maxDamage;

        public DamageBasedParticleCountProvider(int maxCount, float maxDamage) {
            this.maxCount = maxCount;
            this.maxDamage = maxDamage;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            float damage = effectContext.getDamage();
            return Math.round(class_3532.method_15363((float)((float)this.maxCount * damage / this.maxDamage), (float)0.0f, (float)this.maxCount));
        }
    }

    public static class RandomParticleCountProvider
    implements ParticleCountProvider {
        private Random random = new Random();
        private int origin;
        private int bound;

        public RandomParticleCountProvider(int origin, int bound) {
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            return this.random.nextInt(this.origin, this.bound);
        }
    }

    public static class ConstantParticleCountProvider
    implements ParticleCountProvider {
        private int count;

        public ConstantParticleCountProvider(int count) {
            this.count = count;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            return this.count;
        }
    }

    public static interface ParticleWidthProvider {
        public float getWidth(EffectBuilder.Context var1);
    }

    public static interface ParticleCountProvider {
        public int getCount(EffectBuilder.Context var1);
    }
}

