/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.fabric;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.platform.fabric.BakingModelHelper;
import com.vicmatskiv.pointblank.platform.fabric.BlockModelBakingContext;
import com.vicmatskiv.pointblank.platform.fabric.ContextualBlockModelBaker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class ContextualBlockModelBakerImpl
implements ContextualBlockModelBaker {
    private final class_793 baseModel;
    private final ImmutableMap<class_811, class_793> perspectives;

    public ContextualBlockModelBakerImpl(class_793 baseModel, ImmutableMap<class_811, class_793> perspectives) {
        this.baseModel = baseModel;
        this.perspectives = perspectives;
    }

    @Override
    public class_1087 bake(BlockModelBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation, class_806 overrides) {
        return new Baked(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), spriteGetter.apply(context.getMaterial("particle")), overrides, BakingModelHelper.bakeModel2(this.baseModel, baker, spriteGetter, modelState, modelLocation, context.useBlockLight()), (ImmutableMap<class_811, class_1087>)ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> BakingModelHelper.bakeModel2(value, baker, spriteGetter, modelState, modelLocation, context.useBlockLight()))));
    }

    @Override
    public void resolveParents(Function<class_2960, class_1100> modelGetter, BlockModelBakingContext context) {
        this.baseModel.method_45785(modelGetter);
        this.perspectives.values().forEach(model -> model.method_45785(modelGetter));
    }

    public static class Baked
    implements class_1087 {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_1087 baseModel;
        private final ImmutableMap<class_811, class_1087> perspectives;

        public Baked(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_1087 baseModel, ImmutableMap<class_811, class_1087> perspectives) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
            return this.baseModel.method_4707(state, direction, random);
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return true;
        }

        public class_1058 method_4711() {
            return this.particle;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public class_809 method_4709() {
            return class_809.field_4301;
        }

        public class_1087 applyTransform(class_811 cameraTransformType, class_4587 poseStack, boolean applyLeftHandTransform) {
            if (this.perspectives.containsKey((Object)cameraTransformType)) {
                class_1087 p = (class_1087)this.perspectives.get((Object)cameraTransformType);
                if (p instanceof Baked) {
                    Baked baked = (Baked)p;
                    return baked.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
                }
                p.method_4709().method_3503(cameraTransformType).method_23075(applyLeftHandTransform, poseStack);
                return p;
            }
            this.baseModel.method_4709().method_3503(cameraTransformType).method_23075(applyLeftHandTransform, poseStack);
            return this;
        }

        public class_1087 getBaseModel() {
            return this.baseModel;
        }
    }

    public static final class Loader {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public ContextualBlockModelBakerImpl read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            class_793 baseModel = (class_793)deserializationContext.deserialize((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"base"), class_793.class);
            JsonObject perspectiveData = class_3518.method_15296((JsonObject)jsonObject, (String)"perspectives");
            HashMap<class_811, class_793> perspectives = new HashMap<class_811, class_793>();
            for (class_811 transform : class_811.values()) {
                if (!perspectiveData.has(transform.method_15434())) continue;
                class_793 perspectiveModel = (class_793)deserializationContext.deserialize((JsonElement)class_3518.method_15296((JsonObject)perspectiveData, (String)transform.method_15434()), class_793.class);
                perspectives.put(transform, perspectiveModel);
            }
            return new ContextualBlockModelBakerImpl(baseModel, (ImmutableMap<class_811, class_793>)ImmutableMap.copyOf(perspectives));
        }
    }
}

