/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.DynamicGeoListener;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStatePoseProvider;
import com.vicmatskiv.pointblank.client.LockableTarget;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.client.controller.BlendingAnimationController;
import com.vicmatskiv.pointblank.client.controller.GlowAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRandomizingAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRecoilAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunStateAnimationController;
import com.vicmatskiv.pointblank.client.controller.PlayerRecoilController;
import com.vicmatskiv.pointblank.client.controller.RotationAnimationController;
import com.vicmatskiv.pointblank.client.controller.TimerController;
import com.vicmatskiv.pointblank.client.controller.ViewShakeAnimationController;
import com.vicmatskiv.pointblank.client.controller.ViewShakeAnimationController2;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.EffectLauncher;
import com.vicmatskiv.pointblank.client.effect.MuzzleFlashEffect;
import com.vicmatskiv.pointblank.client.render.GunItemRenderer;
import com.vicmatskiv.pointblank.crafting.Craftable;
import com.vicmatskiv.pointblank.entity.ProjectileLike;
import com.vicmatskiv.pointblank.feature.AccuracyFeature;
import com.vicmatskiv.pointblank.feature.ActiveMuzzleFeature;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.AmmoCapacityFeature;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.feature.FireModeFeature;
import com.vicmatskiv.pointblank.feature.GlowFeature;
import com.vicmatskiv.pointblank.feature.MuzzleFlashFeature;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.feature.ReloadFeature;
import com.vicmatskiv.pointblank.feature.ReticleFeature;
import com.vicmatskiv.pointblank.feature.SoundFeature;
import com.vicmatskiv.pointblank.item.AmmoItem;
import com.vicmatskiv.pointblank.item.AnimationProvider;
import com.vicmatskiv.pointblank.item.ConditionalAnimationProvider;
import com.vicmatskiv.pointblank.item.FireMode;
import com.vicmatskiv.pointblank.item.FireModeInstance;
import com.vicmatskiv.pointblank.item.HurtingItem;
import com.vicmatskiv.pointblank.item.ItemExtra;
import com.vicmatskiv.pointblank.network.FireModeRequestPacket;
import com.vicmatskiv.pointblank.network.FireModeResponsePacket;
import com.vicmatskiv.pointblank.network.HitScanFireRequestPacket;
import com.vicmatskiv.pointblank.network.HitScanFireResponsePacket;
import com.vicmatskiv.pointblank.network.ProjectileFireRequestPacket;
import com.vicmatskiv.pointblank.network.ReloadRequestPacket;
import com.vicmatskiv.pointblank.network.ReloadResponsePacket;
import com.vicmatskiv.pointblank.registry.AmmoRegistry;
import com.vicmatskiv.pointblank.registry.EffectRegistry;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.Conditions;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.JsonUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import com.vicmatskiv.pointblank.util.TimeUnit;
import com.vicmatskiv.pointblank.util.Tradeable;
import com.vicmatskiv.pointblank.util.TriPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GunItem
extends HurtingItem
implements ItemExtra,
Craftable,
AttachmentHost,
Nameable,
GeoItem,
LockableTarget.TargetLocker,
Tradeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final String DEFAULT_ANIMATION_IDLE = "animation.model.idle";
    private static final String DEFAULT_ANIMATION_RELOAD = "animation.model.reload";
    private static final String DEFAULT_ANIMATION_INSPECT = "animation.model.inspect";
    private static final String DEFAULT_ANIMATION_DRAW = "animation.model.draw";
    private static final String DEFAULT_ANIMATION_ENABLE_FIRE_MODE = "animation.model.enablefiremode";
    private static final String DEFAULT_ANIMATION_COMPLETE_FIRE = "animation.model.completefire";
    private static final String DEFAULT_ANIMATION_PREPARE_FIRE = "animation.model.preparefire";
    public static final String DEFAULT_ANIMATION_FIRE = "animation.model.fire";
    public static final String DEFAULT_ANIMATION_OFF_GROUND = "animation.model.off_ground";
    public static final String DEFAULT_ANIMATION_OFF_GROUND_SPRINTING = "animation.model.off_ground_sprinting";
    public static final String DEFAULT_ANIMATION_STANDING = "animation.model.standing";
    public static final String DEFAULT_ANIMATION_WALKING = "animation.model.walking";
    public static final String DEFAULT_ANIMATION_CROUCHING = "animation.model.crouching";
    public static final String DEFAULT_ANIMATION_WALKING_AIMING = "animation.model.walking_aiming";
    public static final String DEFAULT_ANIMATION_WALKING_BACKWARDS = "animation.model.walking_backwards";
    public static final String DEFAULT_ANIMATION_WALKING_LEFT = "animation.model.walking_left";
    public static final String DEFAULT_ANIMATION_WALKING_RIGHT = "animation.model.walking_right";
    public static final String DEFAULT_ANIMATION_RUNNING = "animation.model.running";
    public static final String DEFAULT_ANIMATION_PREPARE_RUNNING = "animation.model.runningstart";
    public static final String DEFAULT_ANIMATION_COMPLETE_RUNNING = "animation.model.runningend";
    public static final int INFINITE_AMMO = Integer.MAX_VALUE;
    public static final String DEFAULT_RETICLE_OVERLAY = "textures/item/reticle.png";
    public static final String DEFAULT_RETICLE_OVERLAY_PARALLAX = "textures/item/reticle4.png";
    public static final RawAnimation RAW_ANIMATION_OFF_GROUND = RawAnimation.begin().thenPlay("animation.model.off_ground");
    public static final RawAnimation RAW_ANIMATION_OFF_GROUND_SPRINTING = RawAnimation.begin().thenPlay("animation.model.off_ground_sprinting");
    public static final RawAnimation RAW_ANIMATION_STANDING = RawAnimation.begin().thenPlay("animation.model.standing");
    public static final RawAnimation RAW_ANIMATION_WALKING = RawAnimation.begin().thenPlay("animation.model.walking");
    public static final RawAnimation RAW_ANIMATION_CROUCHING = RawAnimation.begin().thenPlay("animation.model.crouching");
    public static final RawAnimation RAW_ANIMATION_WALKING_AIMING = RawAnimation.begin().thenPlay("animation.model.walking_aiming");
    public static final RawAnimation RAW_ANIMATION_WALKING_BACKWARDS = RawAnimation.begin().thenPlay("animation.model.walking_backwards");
    public static final RawAnimation RAW_ANIMATION_WALKING_LEFT = RawAnimation.begin().thenPlay("animation.model.walking_left");
    public static final RawAnimation RAW_ANIMATION_WALKING_RIGHT = RawAnimation.begin().thenPlay("animation.model.walking_right");
    public static final RawAnimation RAW_ANIMATION_PREPARE_RUNNING = RawAnimation.begin().thenPlay("animation.model.runningstart");
    public static final RawAnimation RAW_ANIMATION_COMPLETE_RUNNING = RawAnimation.begin().thenPlay("animation.model.runningend");
    public static final RawAnimation RAW_ANIMATION_RUNNING = RawAnimation.begin().thenPlay("animation.model.running");
    private static final List<class_2960> FALLBACK_COMMON_ANIMATIONS = List.of(new class_2960("pointblank", "common"));
    private static final List<class_2960> FALLBACK_PISTOL_ANIMATIONS = List.of(new class_2960("pointblank", "pistol"), new class_2960("pointblank", "common"));
    private static Random random = new Random();
    private static final double MAX_SHOOTING_DISTANCE_WITHOUT_AIMING = 100.0;
    private static final class_2960 DEFAULT_SCOPE_OVERLAY = new class_2960("pointblank", "textures/gui/scope.png");
    private static final int MAX_ATTACHMENT_CATEGORIES = 11;
    private final String name;
    private float tradePrice;
    private int tradeLevel;
    private int tradeBundleQuantity;
    private int maxAmmoCapacity;
    private boolean requiresPhasedReload;
    private boolean isAimingEnabled;
    private final int rpm;
    private final long prepareIdleCooldownDuration;
    private final long prepareFireCooldownDuration;
    private final long completeFireCooldownDuration;
    private final long enableFireModeCooldownDuration;
    private long targetLockTimeTicks;
    private final Set<Supplier<AmmoItem>> compatibleBullets;
    private double viewRecoilAmplitude;
    private double shakeRecoilAmplitude;
    private int viewRecoilMaxPitch;
    private long viewRecoilDuration;
    private double shakeRecoilSpeed;
    private double shakeDecay;
    private long shakeRecoilDuration;
    private double gunRecoilInitialAmplitude;
    private double gunRecoilRateOfAmplitudeDecay;
    private double gunRecoilInitialAngularFrequency;
    private double gunRecoilRateOfFrequencyIncrease;
    private double gunRecoilPitchMultiplier;
    private long gunRecoilDuration;
    private int shotsPerRecoil;
    private int shotsPerTrace;
    private long idleRandomizationDuration;
    private long recoilRandomizationDuration;
    private double gunRandomizationAmplitude;
    private int burstShots;
    private class_3414 fireSound;
    private float fireSoundVolume;
    private class_3414 targetLockedSound;
    private class_3414 targetStartLockingSound;
    private long reloadCooldownTime;
    private float bobbing;
    private float bobbingOnAim;
    private float bobbingRollMultiplier;
    private double jumpMultiplier;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private double aimingCurveX;
    private double aimingCurveY;
    private double aimingCurveZ;
    private double aimingCurvePitch;
    private double aimingCurveYaw;
    private double aimingCurveRoll;
    private double aimingZoom;
    private double pipScopeZoom;
    private class_2960 scopeOverlay;
    private class_2960 targetLockOverlay;
    private class_2960 modelResourceLocation;
    private List<PhasedReload> phasedReloads;
    private AnimationProvider drawAnimationProvider;
    private AnimationProvider inspectAnimationProvider;
    private AnimationProvider idleAnimationProvider;
    private String reloadAnimation;
    private int pelletCount;
    private double pelletSpread;
    private double inaccuracy;
    private double inaccuracyAiming;
    private double inaccuracySprinting;
    private List<class_3545<Long, AbstractProceduralAnimationController>> reloadEffectControllers;
    private List<GlowAnimationController.Builder> glowEffectBuilders;
    private List<RotationAnimationController.Builder> rotationEffectBuilders;
    private EffectLauncher effectLauncher;
    private float hitScanSpeed;
    private float hitScanAcceleration;
    private float modelScale;
    private List<Supplier<Attachment>> compatibleAttachmentSuppliers;
    private List<String> compatibleAttachmentGroups;
    private Set<Attachment> compatibleAttachments;
    private List<Supplier<Attachment>> defaultAttachmentSuppliers;
    private long craftingDuration;
    private Map<Class<? extends Feature>, Feature> features;
    private AnimationType animationType;
    private class_2960 firstPersonFallbackAnimations;
    private String thirdPersonFallbackAnimations;
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    private GunItem(Builder builder, String namespace) {
        super(new class_1792.class_1793().method_7889(1), builder);
        ReloadFeature reloadFeature;
        PipFeature pipFeature;
        AimingFeature aimingFeature;
        ReticleFeature reticleFeature;
        MuzzleFlashFeature muzzleFlashFeature;
        FireModeFeature fireModeFeature;
        this.name = builder.name;
        this.modelResourceLocation = this.name.contains(":") ? new class_2960(this.name) : new class_2960(namespace, this.name);
        this.modelScale = builder.modelScale;
        this.tradePrice = builder.tradePrice;
        this.tradeLevel = builder.tradeLevel;
        this.tradeBundleQuantity = builder.tradeBundleQuantity;
        this.maxAmmoCapacity = builder.maxAmmoCapacity;
        this.rpm = builder.rpm;
        this.isAimingEnabled = builder.isAimingEnabled;
        this.compatibleBullets = builder.compatibleAmmo != null && builder.compatibleAmmo.size() > 0 ? builder.compatibleAmmo : Collections.emptySet();
        this.targetLockTimeTicks = builder.targetLockTimeTicks;
        this.hitScanSpeed = builder.hitScanSpeed;
        this.hitScanAcceleration = builder.hitScanAcceleration;
        this.viewRecoilAmplitude = builder.viewRecoilAmplitude;
        this.shakeRecoilAmplitude = builder.shakeRecoilAmplitude;
        this.viewRecoilMaxPitch = builder.viewRecoilMaxPitch;
        this.viewRecoilDuration = builder.viewRecoilDuration;
        this.shakeRecoilSpeed = builder.shakeRecoilSpeed;
        this.shakeRecoilDuration = builder.shakeRecoilDuration;
        this.shakeDecay = builder.shakeDecay;
        this.gunRecoilInitialAmplitude = builder.gunRecoilInitialAmplitude;
        this.gunRecoilRateOfAmplitudeDecay = builder.gunRecoilRateOfAmplitudeDecay;
        this.gunRecoilInitialAngularFrequency = builder.gunRecoilInitialAngularFrequency;
        this.gunRecoilRateOfFrequencyIncrease = builder.gunRecoilRateOfFrequencyIncrease;
        this.gunRecoilPitchMultiplier = builder.gunRecoilPitchMultiplier;
        this.gunRecoilDuration = builder.gunRecoilDuration;
        this.shotsPerRecoil = builder.shotsPerRecoil;
        this.shotsPerTrace = builder.shotsPerTrace;
        this.gunRandomizationAmplitude = builder.gunRandomizationAmplitude;
        this.idleRandomizationDuration = builder.idleRandomizationDuration;
        this.recoilRandomizationDuration = builder.recoilRandomizationDuration;
        this.jumpMultiplier = builder.jumpMultiplier;
        this.burstShots = builder.burstShots;
        this.fireSound = builder.fireSound != null ? builder.fireSound.get() : null;
        this.fireSoundVolume = builder.fireSoundVolume;
        this.prepareIdleCooldownDuration = builder.prepareIdleCooldownDuration;
        this.prepareFireCooldownDuration = builder.prepareFireCooldownDuration;
        this.completeFireCooldownDuration = builder.completeFireCooldownDuration;
        this.enableFireModeCooldownDuration = builder.enableFireModeCooldownDuration;
        this.craftingDuration = builder.craftingDuration;
        this.aimingCurveX = builder.aimingCurveX;
        this.aimingCurveY = builder.aimingCurveY;
        this.aimingCurveZ = builder.aimingCurveZ;
        this.aimingCurvePitch = builder.aimingCurvePitch;
        this.aimingCurveYaw = builder.aimingCurveYaw;
        this.aimingCurveRoll = builder.aimingCurveRoll;
        this.pipScopeZoom = builder.pipScopeZoom;
        this.aimingZoom = builder.aimingZoom;
        this.scopeOverlay = builder.scopeOverlay != null ? new class_2960("pointblank", builder.scopeOverlay) : null;
        this.targetLockOverlay = builder.targetLockOverlay != null ? new class_2960("pointblank", builder.targetLockOverlay) : null;
        this.targetLockedSound = builder.targetLockedSound != null ? builder.targetLockedSound.get() : null;
        this.targetStartLockingSound = builder.targetStartLockingSound != null ? builder.targetStartLockingSound.get() : null;
        this.bobbing = builder.bobbing;
        this.bobbingOnAim = builder.bobbingOnAim;
        this.bobbingRollMultiplier = builder.bobbingRollMultiplier;
        this.reloadEffectControllers = Collections.unmodifiableList(builder.reloadEffectControllers);
        this.phasedReloads = builder.phasedReloads;
        if (!builder.drawAnimationsBuilder.getAnimations().isEmpty()) {
            this.drawAnimationProvider = builder.drawAnimationsBuilder.build();
        }
        if (!builder.inspectAnimationsBuilder.getAnimations().isEmpty()) {
            this.inspectAnimationProvider = builder.inspectAnimationsBuilder.build();
        }
        if (!builder.idleAnimationBuilder.getAnimations().isEmpty()) {
            this.idleAnimationProvider = builder.idleAnimationBuilder.build();
        }
        this.animationType = builder.animationType;
        if (builder.firstPersonFallbackAnimations != null) {
            this.firstPersonFallbackAnimations = new class_2960("pointblank", builder.firstPersonFallbackAnimations);
        }
        this.thirdPersonFallbackAnimations = builder.thirdPersonFallbackAnimations;
        this.pelletSpread = builder.pelletSpread;
        if (builder.pelletCount > 1) {
            this.maxShootingDistance = Math.min(this.maxShootingDistance, 50.0);
        }
        this.inaccuracyAiming = builder.inaccuracyAiming;
        this.inaccuracy = builder.inaccuracy;
        this.inaccuracySprinting = builder.inaccuracySprinting;
        this.reloadCooldownTime = builder.reloadCooldownTime;
        this.reloadAnimation = builder.reloadAnimation;
        if (this.phasedReloads.isEmpty() && this.reloadAnimation != null) {
            this.phasedReloads.add(new PhasedReload(ReloadPhase.RELOADING, this.reloadCooldownTime, this.reloadAnimation));
        } else {
            this.requiresPhasedReload = true;
        }
        this.compatibleAttachmentSuppliers = Collections.unmodifiableList(builder.compatibleAttachments);
        this.compatibleAttachmentGroups = Collections.unmodifiableList(builder.compatibleAttachmentGroups);
        this.defaultAttachmentSuppliers = Collections.unmodifiableList(builder.defaultAttachments);
        HashMap features = new HashMap();
        for (FeatureBuilder<?, ?> featureBuilder : builder.featureBuilders) {
            Object feature = featureBuilder.build(this);
            features.put(feature.getClass(), feature);
        }
        ActiveMuzzleFeature activeMuzzleFeature = (ActiveMuzzleFeature)features.get(ActiveMuzzleFeature.class);
        if (activeMuzzleFeature == null) {
            ActiveMuzzleFeature.Builder activeMuzzleFeatureBuilder = new ActiveMuzzleFeature.Builder().withCondition(Conditions.isUsingDefaultMuzzle().and(Conditions.doesNotHaveAttachmentInCategory(AttachmentCategory.MUZZLE)));
            features.put(ActiveMuzzleFeature.class, activeMuzzleFeatureBuilder.build(this));
        }
        if ((fireModeFeature = (FireModeFeature)features.get(FireModeFeature.class)) == null) {
            FireModeFeature.Builder fireModeFeatureBuilder = new FireModeFeature.Builder();
            if (builder.fireModes != null) {
                for (FireMode fireMode : builder.fireModes) {
                    AnimationProvider fireAnimationProvider = builder.fireAnimationsBuilder.build();
                    fireModeFeatureBuilder.withFireMode(new FireModeFeature.FireModeDescriptor.Builder().withName(fireMode.name()).withType(fireMode).withDisplayName((class_2561)class_2561.method_43471((String)String.format("label.%s.fireMode.%s", "pointblank", fireMode.name().toLowerCase()))).withMaxAmmoCapacity(this.maxAmmoCapacity).withRpm(builder.rpm).withBurstShots(builder.burstShots).withDamage(this.getDamage()).withMaxShootingDistance((int)this.maxShootingDistance).withPelletCount(builder.pelletCount).withPelletSpread(builder.pelletSpread).withIsUsingDefaultMuzzle(true).withFireAnimationProvider(fireAnimationProvider).build());
                }
            }
            features.put(FireModeFeature.class, fireModeFeatureBuilder.build(this));
        }
        if ((muzzleFlashFeature = (MuzzleFlashFeature)features.get(MuzzleFlashFeature.class)) == null) {
            MuzzleFlashFeature.Builder muzzleFlashFeatureBulder = new MuzzleFlashFeature.Builder();
            List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> fbsl = builder.effectBuilders.get((Object)FirePhase.FIRING);
            if (fbsl != null) {
                for (Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>> s : fbsl) {
                    EffectBuilder<? extends EffectBuilder<?, ?>, ?> eb = s.get();
                    if (!(eb instanceof MuzzleFlashEffect.Builder)) continue;
                    muzzleFlashFeatureBulder.withEffect(FirePhase.FIRING, s);
                }
            }
            muzzleFlashFeature = muzzleFlashFeatureBulder.build(this);
            features.put(MuzzleFlashFeature.class, muzzleFlashFeature);
        }
        if ((reticleFeature = (ReticleFeature)features.get(ReticleFeature.class)) == null && builder.reticleOverlay != null && !MiscUtil.isGreaterThanZero(builder.pipScopeZoom)) {
            features.put(ReticleFeature.class, new ReticleFeature.Builder().withTexture(builder.reticleOverlay).build(this));
        }
        if ((aimingFeature = (AimingFeature)features.get(AimingFeature.class)) == null && builder.isAimingEnabled) {
            features.put(AimingFeature.class, new AimingFeature.Builder().withZoom(this.aimingZoom).build(this));
        }
        if ((pipFeature = (PipFeature)features.get(PipFeature.class)) == null && MiscUtil.isGreaterThanZero(builder.pipScopeZoom)) {
            features.put(PipFeature.class, new PipFeature.Builder().withZoom(builder.pipScopeZoom).withOverlayTexture(builder.reticleOverlay).build(this));
        }
        if ((reloadFeature = (ReloadFeature)features.get(ReloadFeature.class)) == null) {
            features.put(ReloadFeature.class, new ReloadFeature.Builder().withMaxAmmoPerReloadIteration(builder.maxAmmoPerReloadIteration).build(this));
        }
        this.glowEffectBuilders = builder.glowEffectBuilders;
        this.rotationEffectBuilders = builder.rotationEffectBuilders;
        this.effectLauncher = new EffectLauncher(builder.effectBuilders);
        if (!this.glowEffectBuilders.isEmpty() && !features.containsKey(GlowFeature.class)) {
            features.put(GlowFeature.class, new GlowFeature());
        }
        this.features = Collections.unmodifiableMap(features);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        return class_2561.method_43471((String)this.method_7866(itemStack));
    }

    public float getModelScale() {
        return this.modelScale;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"label.pointblank.damage").method_27693(": ").method_27693(String.format("%.2f", Float.valueOf(this.getDamage()))).method_27692(class_124.field_1061).method_27692(class_124.field_1056));
        tooltip.add((class_2561)class_2561.method_43471((String)"label.pointblank.rpm").method_27693(": ").method_27693(String.format("%d", this.rpm)).method_27692(class_124.field_1061).method_27692(class_124.field_1056));
        class_5250 ammoDescription = class_2561.method_43471((String)"label.pointblank.ammo").method_27693(": ");
        boolean isFirst = true;
        for (Supplier<AmmoItem> ammoItemSupplier : this.compatibleBullets) {
            AmmoItem ammoItem;
            if (!isFirst) {
                ammoDescription.method_27693(", ");
            }
            if ((ammoItem = ammoItemSupplier.get()) != null) {
                ammoDescription.method_10852((class_2561)class_2561.method_43471((String)ammoItemSupplier.get().method_7876()));
            } else {
                ammoDescription.method_10852((class_2561)class_2561.method_43471((String)"missing_ammo"));
            }
            isFirst = false;
        }
        ammoDescription.method_27692(class_124.field_1061).method_27692(class_124.field_1056);
        tooltip.add((class_2561)ammoDescription);
    }

    public class_5250 getDisplayName() {
        return class_2561.method_43471((String)(this.method_7876() + ".desc")).method_27692(class_124.field_1054);
    }

    public boolean requiresPhasedReload() {
        return this.requiresPhasedReload;
    }

    public List<FireModeInstance> getMainFireModes() {
        FireModeFeature fireModeFeature = this.getFeature(FireModeFeature.class);
        return fireModeFeature.getFireModes();
    }

    public int getRpm() {
        return this.rpm;
    }

    public boolean isAimingEnabled() {
        return this.isAimingEnabled;
    }

    public long getPrepareFireCooldownDuration() {
        return this.prepareFireCooldownDuration;
    }

    public long getCompleteFireCooldownDuration() {
        return this.completeFireCooldownDuration;
    }

    public long getEnableFireModeCooldownDuration() {
        return this.enableFireModeCooldownDuration;
    }

    public long getPrepareIdleCooldownDuration() {
        return this.prepareIdleCooldownDuration;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    public double getPelletSpread() {
        return this.pelletSpread;
    }

    public long getDrawCooldownDuration(class_1309 player, GunClientState state, class_1799 itemStack) {
        if (this.drawAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.drawAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getInspectCooldownDuration(class_1309 player, GunClientState state, class_1799 itemStack) {
        if (this.inspectAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.inspectAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getIdleCooldownDuration(class_1309 player, GunClientState state, class_1799 itemStack) {
        if (this.idleAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.idleAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getReloadingCooldownTime(ReloadPhase phase, class_1309 player, GunClientState state, class_1799 itemStack) {
        long cooldownTime = 0L;
        for (PhasedReload reload : this.phasedReloads) {
            if (phase != reload.phase || !reload.predicate.test(new ConditionContext(player, itemStack, state, null))) continue;
            cooldownTime = reload.timeUnit.toMillis(reload.cooldownTime);
            break;
        }
        return cooldownTime;
    }

    public int getBurstShots(class_1799 itemStack, FireModeInstance fireModeInstance) {
        FireModeFeature mainFireModeFeature = this.getFeature(FireModeFeature.class);
        if (mainFireModeFeature.getFireModes().contains(fireModeInstance)) {
            int burstShots = fireModeInstance.getBurstShots() == -1 ? this.burstShots : fireModeInstance.getBurstShots();
            return burstShots;
        }
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        if (allFireModes.contains(fireModeInstance)) {
            return fireModeInstance.getBurstShots();
        }
        return this.burstShots;
    }

    public int getMaxAmmoCapacity(class_1799 itemStack, FireModeInstance fireModeInstance) {
        FireModeFeature mainFireModeFeature = this.getFeature(FireModeFeature.class);
        if (mainFireModeFeature.getFireModes().contains(fireModeInstance)) {
            int ammoCapacity = fireModeInstance.getAmmo() == AmmoRegistry.DEFAULT_AMMO_POOL.get() ? this.maxAmmoCapacity : fireModeInstance.getMaxAmmoCapacity();
            return AmmoCapacityFeature.modifyAmmoCapacity(itemStack, ammoCapacity);
        }
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        if (allFireModes.contains(fireModeInstance)) {
            int ammoCapacity = fireModeInstance.getAmmo() == AmmoRegistry.DEFAULT_AMMO_POOL.get() ? this.maxAmmoCapacity : fireModeInstance.getMaxAmmoCapacity();
            return AmmoCapacityFeature.modifyAmmoCapacity(itemStack, ammoCapacity);
        }
        return 0;
    }

    public class_2960 getScopeOverlay() {
        if (this.scopeOverlay == null && MiscUtil.isGreaterThanZero(this.pipScopeZoom) && !Config.pipScopesEnabled) {
            return DEFAULT_SCOPE_OVERLAY;
        }
        return this.scopeOverlay;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GunItemRenderer renderer;

            public class_756 getCustomRenderer() {
                if (this.renderer == null) {
                    List<Object> fallbackAnimations;
                    if (GunItem.this.firstPersonFallbackAnimations != null) {
                        fallbackAnimations = new ArrayList<class_2960>();
                        fallbackAnimations.add(GunItem.this.firstPersonFallbackAnimations);
                        fallbackAnimations.addAll(GunItem.this.animationType.getFallbackFirstPersonAnimations());
                    } else {
                        fallbackAnimations = GunItem.this.animationType.getFallbackFirstPersonAnimations();
                    }
                    this.renderer = new GunItemRenderer(GunItem.this.modelResourceLocation, fallbackAnimations, GunItem.this.glowEffectBuilders);
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return true;
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return class_1269.field_5812;
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 player, class_1309 entity, class_1268 hand) {
        return class_1269.field_5812;
    }

    @Override
    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        return true;
    }

    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new BlendingAnimationController<GunItem>(this, "walking", 2, false, state -> PlayState.STOP).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_WALKING, 2, false).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_WALKING_BACKWARDS, 2, false).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_WALKING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_PREPARE_RUNNING, DEFAULT_ANIMATION_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_PREPARE_RUNNING, DEFAULT_ANIMATION_COMPLETE_RUNNING, 3, false).withTransition(DEFAULT_ANIMATION_RUNNING, DEFAULT_ANIMATION_COMPLETE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_WALKING, 3, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_STANDING, 3, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withSpeedProvider((p, c) -> {
            double baseSpeed;
            double speed = p.method_6029();
            class_1324 attribute = p.method_5996(class_5134.field_23719);
            double d = baseSpeed = attribute != null ? attribute.method_6201() : speed;
            if (baseSpeed == 0.0) {
                baseSpeed = speed;
            }
            if (p.method_5624()) {
                baseSpeed += baseSpeed * 0.3;
            }
            double ratio = speed / baseSpeed;
            if (((class_746)p).method_20303() || p.method_5681() || p.method_5799()) {
                ratio *= 0.6;
            }
            return Math.sqrt(class_3532.method_15350((double)ratio, (double)0.1, (double)10.0));
        }).triggerableAnim(DEFAULT_ANIMATION_WALKING, RAW_ANIMATION_WALKING).triggerableAnim(DEFAULT_ANIMATION_CROUCHING, RAW_ANIMATION_CROUCHING).triggerableAnim(DEFAULT_ANIMATION_WALKING_AIMING, RAW_ANIMATION_WALKING_AIMING).triggerableAnim(DEFAULT_ANIMATION_WALKING_BACKWARDS, RAW_ANIMATION_WALKING_BACKWARDS).triggerableAnim(DEFAULT_ANIMATION_WALKING_LEFT, RAW_ANIMATION_WALKING_LEFT).triggerableAnim(DEFAULT_ANIMATION_WALKING_RIGHT, RAW_ANIMATION_WALKING_RIGHT).triggerableAnim(DEFAULT_ANIMATION_PREPARE_RUNNING, RAW_ANIMATION_PREPARE_RUNNING).triggerableAnim(DEFAULT_ANIMATION_RUNNING, RAW_ANIMATION_RUNNING).triggerableAnim(DEFAULT_ANIMATION_COMPLETE_RUNNING, RAW_ANIMATION_COMPLETE_RUNNING).triggerableAnim(DEFAULT_ANIMATION_STANDING, RAW_ANIMATION_STANDING).triggerableAnim(DEFAULT_ANIMATION_OFF_GROUND, RAW_ANIMATION_OFF_GROUND).triggerableAnim(DEFAULT_ANIMATION_OFF_GROUND_SPRINTING, RAW_ANIMATION_OFF_GROUND_SPRINTING).setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        })});
        List<GunStateAnimationController> reloadAnimationControllers = this.createReloadAnimationControllers();
        for (GunStateAnimationController reloadAnimationController : reloadAnimationControllers) {
            controllers.add(new AnimationController[]{reloadAnimationController});
        }
        GunStateAnimationController fireAnimationController = new GunStateAnimationController(this, "fire_controller", DEFAULT_ANIMATION_FIRE, ctx -> ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_SINGLE || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_AUTO || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_BURST || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_SINGLE || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_AUTO || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_BURST || this.completeFireCooldownDuration == 0L && ctx.gunClientState().isIdle()){

            @Override
            public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getFireAnimation(player, state, itemStack));
                }
            }
        };
        fireAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, this.fireSoundVolume, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{fireAnimationController});
        GunStateAnimationController prepareFiringAnimationController = new GunStateAnimationController(this, "prepare_fire_controller", DEFAULT_ANIMATION_PREPARE_FIRE, ctx -> ctx.gunClientState().isPreparingFiring()){

            @Override
            public void onPrepareFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getPrepareFireAnimation(player, state, itemStack));
                }
            }
        };
        prepareFiringAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{prepareFiringAnimationController});
        GunStateAnimationController completeFiringAnimationController = new GunStateAnimationController(this, "complete_fire_controller", DEFAULT_ANIMATION_COMPLETE_FIRE, ctx -> ctx.gunClientState().isCompletingFiring()){

            @Override
            public void onCompleteFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getCompleteFireAnimation(player, state, itemStack));
                }
            }
        };
        completeFiringAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{completeFiringAnimationController});
        GunStateAnimationController drawAnimationController = new GunStateAnimationController(this, "draw_controller", DEFAULT_ANIMATION_DRAW, ctx -> ctx.gunClientState().isDrawing()){

            private String getAnimationName(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (GunItem.this.drawAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.drawAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onDrawing(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        drawAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{drawAnimationController});
        GunStateAnimationController inspectAnimationController = new GunStateAnimationController(this, "inspect_controller", DEFAULT_ANIMATION_INSPECT, ctx -> ctx.gunClientState().isInspecting()){

            private String getAnimationName(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (GunItem.this.inspectAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.inspectAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onInspecting(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        inspectAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{inspectAnimationController});
        GunStateAnimationController idleAnimationController = new GunStateAnimationController(this, "idle_controller", DEFAULT_ANIMATION_IDLE, ctx -> ctx.gunClientState().getFireState() == GunClientState.FireState.IDLE || ctx.gunClientState().getFireState() == GunClientState.FireState.IDLE_COOLDOWN){

            private String getAnimationName(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (GunItem.this.idleAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.idleAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onIdle(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        idleAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{idleAnimationController});
        GunStateAnimationController enableFireModeAimationController = new GunStateAnimationController(this, "enable_fire_mode_controller", DEFAULT_ANIMATION_ENABLE_FIRE_MODE, ctx -> ctx.gunClientState().isChangingFireMode()){

            @Override
            public void onEnablingFireMode(class_1309 player, GunClientState state, class_1799 itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getEnableFireModeAnimation(player, state, itemStack));
                }
            }
        };
        enableFireModeAimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.method_5783(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{enableFireModeAimationController});
    }

    private static boolean isCompatibleBullet(class_1792 ammoItem, class_1799 gunStack, FireModeInstance fireModeInstance) {
        boolean result = false;
        class_1792 class_17922 = gunStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)class_17922;
        List<FireModeInstance> firModeInstances = GunItem.getFireModes(gunStack);
        if (!firModeInstances.contains(fireModeInstance)) {
            return false;
        }
        if (fireModeInstance.isUsingDefaultAmmoPool()) {
            for (Supplier<AmmoItem> compatibleBullet : gunItem.compatibleBullets) {
                if (!Objects.equals(compatibleBullet.get(), ammoItem)) continue;
                result = true;
                break;
            }
        } else {
            result = ammoItem == fireModeInstance.getAmmo();
        }
        return result;
    }

    public int canReloadGun(class_1799 gunStack, class_1657 player, FireModeInstance fireModeInstance) {
        int currentAmmo;
        GunItem gunItem = (GunItem)gunStack.method_7909();
        int maxCapacity = gunItem.getMaxAmmoCapacity(gunStack, fireModeInstance);
        int ammoNeeded = maxCapacity - (currentAmmo = GunItem.getAmmo(gunStack, fireModeInstance));
        if (ammoNeeded <= 0) {
            return 0;
        }
        if (player.method_7337()) {
            return ammoNeeded;
        }
        int availableBullets = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemStack = player.method_31548().method_5438(i);
            if (GunItem.isCompatibleBullet(itemStack.method_7909(), gunStack, fireModeInstance)) {
                availableBullets += itemStack.method_7947();
            }
            if (availableBullets >= ammoNeeded) break;
        }
        int potentialReloadAmount = Math.min(ammoNeeded, availableBullets);
        return potentialReloadAmount;
    }

    int reloadGun(class_1799 gunStack, class_1657 player, FireModeInstance fireModeInstance) {
        int currentAmmo;
        if (!(gunStack.method_7909() instanceof GunItem)) {
            return 0;
        }
        GunItem gunItem = (GunItem)gunStack.method_7909();
        if (!gunItem.isEnabled()) {
            return 0;
        }
        int maxCapacity = gunItem.getMaxAmmoCapacity(gunStack, fireModeInstance);
        int neededAmmo = maxCapacity - (currentAmmo = GunItem.getAmmo(gunStack, fireModeInstance));
        if (neededAmmo <= 0) {
            return currentAmmo;
        }
        if (player.method_7337()) {
            int newAmmo = currentAmmo + neededAmmo;
            GunItem.setAmmo(gunStack, fireModeInstance, newAmmo);
            return newAmmo;
        }
        int foundAmmoCount = 0;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 inventoryItem = (class_1799)player.method_31548().field_7547.get(i);
            if (!GunItem.isCompatibleBullet(inventoryItem.method_7909(), gunStack, fireModeInstance)) continue;
            int availableBullets = inventoryItem.method_7947();
            if (availableBullets <= neededAmmo) {
                foundAmmoCount += availableBullets;
                neededAmmo -= availableBullets;
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            } else {
                inventoryItem.method_7934(neededAmmo);
                foundAmmoCount += neededAmmo;
                neededAmmo = 0;
            }
            if (neededAmmo == 0) break;
        }
        int newAmmo = currentAmmo + foundAmmoCount;
        GunItem.setAmmo(gunStack, fireModeInstance, newAmmo);
        return newAmmo;
    }

    public void handleClientReloadRequest(class_3222 player, class_1799 itemStack, UUID clientStateId, int slotIndex, FireModeInstance fireModeInstance) {
        boolean isOffhand;
        boolean bl = isOffhand = player.method_6079() == itemStack;
        if (!isOffhand && itemStack != null) {
            int ammo = this.reloadGun(itemStack, (class_1657)player, fireModeInstance);
            UUID itemStackId = GunItem.getItemStackId(itemStack);
            Platform.getInstance().getNetworkService().sendToClient(new ReloadResponsePacket(itemStackId, slotIndex, 0, ammo > 0, ammo, fireModeInstance), (class_1657)player);
        }
    }

    public static UUID getItemStackId(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return null;
        }
        class_2487 idTag = MiscUtil.getTag(itemStack);
        return MiscUtil.getTagId(idTag);
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int itemSlot, boolean isSelected) {
        boolean isOffhand;
        boolean bl = isOffhand = entity instanceof class_1657 && ((class_1657)entity).method_6079() == itemStack;
        if (!level.field_9236) {
            this.ensureItemStack(itemStack, level, entity, isOffhand);
        } else {
            GunClientState state = GunClientState.getState((class_1657)entity, itemStack, itemSlot, isOffhand);
            if (state != null && entity instanceof class_1657) {
                state.inventoryTick((class_1309)((class_1657)entity), itemStack, isSelected);
            }
        }
    }

    private void ensureItemStack(class_1799 itemStack, class_1937 level, class_1297 entity, boolean isOffhand) {
        GeoItem.getOrAssignId((class_1799)itemStack, (class_3218)((class_3218)level));
        GunItem.getOrAssignRandomSeed(itemStack);
        class_2487 stateTag = MiscUtil.getOrCreateTag(itemStack);
        long mid = stateTag.method_10537("mid");
        long lid = stateTag.method_10537("lid");
        if (mid == 0L && lid == 0L) {
            UUID newId = UUID.randomUUID();
            stateTag.method_10544("mid", newId.getMostSignificantBits());
            stateTag.method_10544("lid", newId.getLeastSignificantBits());
            stateTag.method_10569("ammo", this.maxAmmoCapacity == Integer.MAX_VALUE ? Integer.MAX_VALUE : 0);
            stateTag.method_10566("ammox", (class_2520)new class_2487());
            List<FireModeInstance> mainFireModes = this.getMainFireModes();
            if (mainFireModes != null && !mainFireModes.isEmpty()) {
                stateTag.method_25927("fmid", this.getMainFireModes().get(0).getId());
            }
            stateTag.method_10556("aim", false);
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)class_17922;
                Collection<Attachment> defaultAttachments = attachmentHost.getDefaultAttachments();
                for (Attachment attachment : defaultAttachments) {
                    Attachments.addAttachment(itemStack, new class_1799((class_1935)attachment), true);
                }
            }
            MiscUtil.setTag(itemStack, stateTag);
        } else {
            this.ensureValidFireModeSelected(itemStack);
        }
        Attachments.ensureValidAttachmentsSelected(itemStack);
    }

    public static void initStackForCrafting(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)class_17922;
        class_2487 stateTag = MiscUtil.getOrCreateTag(itemStack);
        long mid = stateTag.method_10537("mid");
        long lid = stateTag.method_10537("lid");
        if (mid == 0L && lid == 0L) {
            UUID newId = UUID.randomUUID();
            stateTag.method_10544("mid", newId.getMostSignificantBits());
            stateTag.method_10544("lid", newId.getLeastSignificantBits());
            stateTag.method_10566("ammox", (class_2520)new class_2487());
            List<FireModeInstance> mainFireModes = gunItem.getMainFireModes();
            if (mainFireModes != null && !mainFireModes.isEmpty()) {
                stateTag.method_25927("fmid", gunItem.getMainFireModes().get(0).getId());
            }
            stateTag.method_10556("aim", false);
            class_1792 class_17923 = itemStack.method_7909();
            if (class_17923 instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)class_17923;
                Collection<Attachment> defaultAttachments = attachmentHost.getDefaultAttachments();
                for (Attachment attachment : defaultAttachments) {
                    Attachments.addAttachment(itemStack, new class_1799((class_1935)attachment), true);
                }
            }
            MiscUtil.setTag(itemStack, stateTag);
        }
    }

    private void ensureValidFireModeSelected(class_1799 itemStack) {
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            UUID fireModeInstanceId = idTag.method_25928("fmid") ? idTag.method_25926("fmid") : null;
            FireModeInstance selectedModeInstance = FireModeInstance.getOrElse(fireModeInstanceId, null);
            List<FireModeInstance> fireModes = GunItem.getFireModes(itemStack);
            if (selectedModeInstance != null && !fireModes.contains(selectedModeInstance)) {
                selectedModeInstance = null;
            }
            if (selectedModeInstance == null && !fireModes.isEmpty()) {
                selectedModeInstance = fireModes.get(0);
                GunItem.setFireModeInstance(itemStack, selectedModeInstance);
            }
            if (selectedModeInstance == null) {
                idTag.method_10551("fmid");
            }
        }
    }

    private static long getOrAssignRandomSeed(class_1799 stack) {
        class_2487 tag = MiscUtil.getOrCreateTag(stack);
        long seed = tag.method_10537("seed");
        if (tag.method_10573("seed", 99)) {
            return seed;
        }
        seed = random.nextLong();
        tag.method_10544("seed", seed);
        return seed;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 shooter, int ticksRemaining) {
    }

    private Predicate<class_2248> getDestroyBlockByHitScanPredicate() {
        return block -> Config.bulletsBreakGlassEnabled && (block instanceof class_2506 || block == class_2246.field_10033 || block instanceof class_2504 || block == class_2246.field_10285);
    }

    private Predicate<class_2248> getPassThroughBlocksByHitScanPredicate() {
        return block -> block instanceof class_2261 || block instanceof class_2397;
    }

    public void requestFireFromServer(GunClientState gunClientState, class_1657 player, class_1799 itemStack, class_1297 targetEntity) {
        int activeSlot = player.method_31548().field_7545;
        LOGGER.debug("{} requesting fire from server", (Object)(System.currentTimeMillis() % 100000L));
        SoundFeature.playFireSound(player, itemStack);
        Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((class_1309)player, gunClientState, itemStack);
        int shotCount = (Integer)pcs.getFirst() > 0 ? (Integer)pcs.getFirst() : 1;
        long requestSeed = random.nextLong();
        FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
        AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
        if (projectileItem != null) {
            class_243 direction;
            class_243 startPos;
            GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
            class_243[] pd = gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
            if (pd == null) {
                pd = gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
            }
            if (pd != null) {
                startPos = pd[0];
                direction = pd[1];
            } else {
                startPos = player.method_33571();
                direction = player.method_5828(0.0f);
                startPos = startPos.method_1019(direction.method_1029().method_18805(2.0, 2.0, 2.0));
            }
            Platform.getInstance().getNetworkService().sendToServer(new ProjectileFireRequestPacket(fireModeInstance, GunItem.getItemStackId(itemStack), activeSlot, gunClientState.isAiming(), startPos.field_1352, startPos.field_1351, startPos.field_1350, direction.field_1352, direction.field_1351, direction.field_1350, targetEntity != null ? targetEntity.method_5628() : -1, requestSeed));
        } else {
            double adjustedInaccuracy = this.adjustInaccuracy(player, itemStack, gunClientState.isAiming());
            long itemSeed = GunItem.getOrAssignRandomSeed(itemStack);
            long xorSeed = itemSeed ^ requestSeed;
            this.acquireHitScan(player, itemStack, gunClientState, shotCount, xorSeed, adjustedInaccuracy);
            Platform.getInstance().getNetworkService().sendToServer(new HitScanFireRequestPacket(fireModeInstance, GunItem.getItemStackId(itemStack), activeSlot, gunClientState.isAiming(), requestSeed));
            LOGGER.debug("{} sent fire request to server", (Object)(System.currentTimeMillis() % 100000L));
        }
    }

    private void acquireHitScan(class_1657 player, class_1799 itemStack, @NotNull GunClientState gunClientState, int shotCount, long seed, double adjustedInaccuracy) {
        if (shotCount > 1) {
            return;
        }
        double maxDistance = this.getMaxClientShootingDistance(itemStack, gunClientState);
        List<class_239> hitResults = HitScan.getObjectsInCrosshair((class_1309)player, player.method_33571(), player.method_5828(0.0f), 1.0f, maxDistance, shotCount, adjustedInaccuracy, seed, this.getDestroyBlockByHitScanPredicate(), this.getPassThroughBlocksByHitScanPredicate(), new ArrayList<class_2338>());
        for (class_239 hitResult : hitResults) {
            gunClientState.acquireHitScan((class_1309)player, itemStack, hitResult);
        }
    }

    private double getMaxClientShootingDistance(class_1799 itemStack, GunClientState gunClientState) {
        class_310 mc = class_310.method_1551();
        double maxDistance = Math.min(mc.field_1690.method_38521() * 16, FireModeFeature.getMaxShootingDistance(itemStack));
        if (!gunClientState.isAiming()) {
            maxDistance = Math.min(maxDistance, 100.0);
        }
        return maxDistance;
    }

    private double adjustInaccuracy(class_1657 player, class_1799 itemStack, boolean isAiming) {
        double adjustedInaccuracy = isAiming ? this.inaccuracyAiming : (player.method_5624() ? this.inaccuracySprinting : this.inaccuracy);
        Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((class_1309)player, null, itemStack);
        if ((Integer)pcs.getFirst() > 0) {
            adjustedInaccuracy += ((Double)pcs.getSecond()).doubleValue();
        }
        float accuracyModifier = AccuracyFeature.getAccuracyModifier(itemStack);
        return adjustedInaccuracy / (double)accuracyModifier;
    }

    public static Optional<Integer> getClientSideAmmo(class_1657 player, class_1799 itemStack, int slotIndex) {
        GunClientState state = GunClientState.getState(player, itemStack, slotIndex, false);
        return state != null ? Optional.of(state.getAmmoCount(GunItem.getFireModeInstance(itemStack))) : Optional.empty();
    }

    public double getInacuracy() {
        return this.inaccuracy;
    }

    public int getShotsPerTrace() {
        return this.shotsPerTrace;
    }

    public static int getAmmo(class_1799 itemStack, FireModeInstance fireModeInstance) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return 0;
        }
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            if (fireModeInstance.isUsingDefaultAmmoPool()) {
                return idTag.method_10550("ammo");
            }
            class_2487 auxAmmoTag = idTag.method_10562("ammox");
            if (auxAmmoTag != null) {
                return auxAmmoTag.method_10550(fireModeInstance.getAmmo().getName());
            }
        }
        return 0;
    }

    public static void setAmmo(class_1799 itemStack, FireModeInstance fireModeInstance, int ammo) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        LOGGER.debug("Setting ammo in stack {} to {}", (Object)System.identityHashCode(itemStack), (Object)ammo);
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            if (fireModeInstance.isUsingDefaultAmmoPool()) {
                idTag.method_10569("ammo", ammo);
            } else {
                class_2487 auxAmmoTag = idTag.method_10562("ammox");
                auxAmmoTag.method_10569(fireModeInstance.getAmmo().getName(), ammo);
                idTag.method_10566("ammox", (class_2520)auxAmmoTag);
            }
            MiscUtil.setTag(itemStack, idTag);
        }
    }

    public static int decrementAmmo(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return 0;
        }
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            int ammo = idTag.method_10550("ammo");
            if (ammo <= 0) {
                return -1;
            }
            idTag.method_10569("ammo", --ammo);
            MiscUtil.setTag(itemStack, idTag);
            return ammo;
        }
        return 0;
    }

    public static FireMode getSelectedFireModeType(class_1799 itemStack) {
        FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
        return fireModeInstance != null ? fireModeInstance.getType() : null;
    }

    public static FireModeInstance getFireModeInstance(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return null;
        }
        GunItem gunItem = (GunItem)class_17922;
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            UUID fireModeInstanceId = idTag.method_25928("fmid") ? idTag.method_25926("fmid") : null;
            FireModeInstance fireModeInstance = null;
            if (fireModeInstanceId != null) {
                fireModeInstance = FireModeInstance.getOrElse(fireModeInstanceId, null);
            }
            if (fireModeInstance == null) {
                fireModeInstance = gunItem.getMainFireModes().get(0);
            }
            return fireModeInstance;
        }
        return null;
    }

    private static void setFireModeInstance(class_1799 itemStack, FireModeInstance fireModeInstance) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            idTag.method_25927("fmid", fireModeInstance.getId());
            MiscUtil.setTag(itemStack, idTag);
            LOGGER.debug("Set fire mode instance to {}, tag: {}", (Object)fireModeInstance.getDisplayName(), (Object)idTag);
        }
    }

    public void handleClientProjectileFireRequest(class_3222 player, FireModeInstance fireModeInstance, UUID stateId, int slotIndex, int correlationId, boolean isAiming, double spawnPositionX, double spawnPositionY, double spawnPositionZ, double spawnDirectionX, double spawnDirectionY, double spawnDirectionZ, int targetEntityId, long requestSeed) {
        boolean isOffhand;
        LOGGER.debug("Handling client projectile file request");
        class_1799 itemStack = player.method_31548().method_5438(slotIndex);
        AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
        if (projectileItem == null) {
            LOGGER.error("Attempted to handle client projectile fire request with an item that does not support projectiles: " + this);
            return;
        }
        if (!this.isEnabled() || !projectileItem.isEnabled()) {
            return;
        }
        boolean bl = isOffhand = player.method_6079() == itemStack;
        if (itemStack == null || isOffhand || !(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        int ammo = 0;
        ammo = GunItem.getAmmo(itemStack, fireModeInstance);
        if (ammo > 0) {
            LOGGER.debug("Received client projectile file request");
            class_1297 targetEntity = null;
            if (targetEntityId >= 0) {
                targetEntity = MiscUtil.getLevel((class_1297)player).method_8469(targetEntityId);
            }
            ProjectileLike projectile = null;
            if (targetEntity != null) {
                class_239 hitResult = HitScan.ensureEntityInCrosshair((class_1309)player, targetEntity, 0.0f, 400.0, 2.0f);
                if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331 && ((class_3966)hitResult).method_17782() == targetEntity) {
                    projectile = projectileItem.createProjectile((class_1309)player, spawnPositionX, spawnPositionY, spawnPositionZ);
                    projectile.launchAtTargetEntity((class_1309)player, hitResult, targetEntity);
                }
            } else {
                projectile = projectileItem.createProjectile((class_1309)player, spawnPositionX, spawnPositionY, spawnPositionZ);
                long xorSeed = GunItem.getOrAssignRandomSeed(itemStack) ^ requestSeed;
                double adjustedInaccuracy = this.adjustInaccuracy((class_1657)player, itemStack, isAiming);
                projectile.launchAtLookTarget((class_1309)player, adjustedInaccuracy, xorSeed);
            }
            if (projectile != null) {
                if (this.getMaxAmmoCapacity(itemStack, fireModeInstance) < Integer.MAX_VALUE) {
                    GunItem.setAmmo(itemStack, fireModeInstance, ammo - 1);
                }
                SoundFeature.playFireSound((class_1657)player, itemStack);
                MiscUtil.getLevel((class_1297)player).method_8649((class_1297)projectile);
            } else {
                LOGGER.debug("Did not fire projectile");
            }
        }
    }

    public List<AmmoItem> getCompatibleAmmo() {
        return this.compatibleBullets.stream().map(Supplier::get).toList();
    }

    private AmmoItem getFirstCompatibleProjectile(class_1799 gunStack, FireModeInstance fireModeInstance) {
        class_1792 class_17922 = gunStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return null;
        }
        GunItem gunItem = (GunItem)class_17922;
        List<FireModeInstance> firModeInstances = GunItem.getFireModes(gunStack);
        if (!firModeInstances.contains(fireModeInstance)) {
            return null;
        }
        AmmoItem projectileItem = null;
        if (fireModeInstance.isUsingDefaultAmmoPool()) {
            for (Supplier<AmmoItem> ammoSupplier : gunItem.compatibleBullets) {
                AmmoItem ammoItem = ammoSupplier.get();
                if (!ammoItem.isHasProjectile()) continue;
                projectileItem = ammoItem;
                break;
            }
        } else {
            AmmoItem ammoItem = fireModeInstance.getAmmo();
            if (ammoItem.isHasProjectile()) {
                projectileItem = ammoItem;
            }
        }
        return projectileItem;
    }

    public void handleClientHitScanFireRequest(class_3222 player, FireModeInstance fireModeInstance, UUID stateId, int slotIndex, int correlationId, boolean isAiming, long requestSeed) {
        try {
            boolean isOffhand;
            LOGGER.debug("{} handling client fire request", (Object)(System.currentTimeMillis() % 100000L));
            class_1799 itemStack = player.method_31548().method_5438(slotIndex);
            AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
            if (projectileItem != null) {
                LOGGER.error("Attempted to handle client hit scan fire request with an item that fires projectiles: " + this);
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = isOffhand = player.method_6079() == itemStack;
            if (itemStack == null || isOffhand || !(itemStack.method_7909() instanceof GunItem)) {
                return;
            }
            ArrayList<class_239> hitResults = new ArrayList<class_239>();
            int ammo = 0;
            ammo = GunItem.getAmmo(itemStack, fireModeInstance);
            if (ammo > 0) {
                if (this.getMaxAmmoCapacity(itemStack, fireModeInstance) < Integer.MAX_VALUE) {
                    GunItem.setAmmo(itemStack, fireModeInstance, ammo - 1);
                }
                SoundFeature.playFireSound((class_1657)player, itemStack);
                Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((class_1309)player, null, itemStack);
                int shotCount = (Integer)pcs.getFirst() > 0 ? (Integer)pcs.getFirst() : 1;
                double adjustedInaccuracy = this.adjustInaccuracy((class_1657)player, itemStack, isAiming);
                long xorSeed = GunItem.getOrAssignRandomSeed(itemStack) ^ requestSeed;
                class_243 eyePos = player.method_33571();
                class_243 lookVec = player.method_5828(0.0f);
                class_3218 level = (class_3218)MiscUtil.getLevel((class_1297)player);
                double maxHitScanDistance = this.getMaxServerShootingDistance(itemStack, isAiming, level);
                ArrayList<class_2338> blockPosToDestroy = new ArrayList<class_2338>();
                hitResults.addAll(HitScan.getObjectsInCrosshair((class_1309)player, eyePos, lookVec, 0.0f, maxHitScanDistance, shotCount, adjustedInaccuracy, xorSeed, this.getDestroyBlockByHitScanPredicate(), this.getPassThroughBlocksByHitScanPredicate(), blockPosToDestroy));
                LOGGER.debug("{} obtained hit results", (Object)(System.currentTimeMillis() % 100000L));
                for (class_239 hitResult : hitResults) {
                    this.hitScanTarget((class_1657)player, itemStack, slotIndex, correlationId, hitResult, maxHitScanDistance, blockPosToDestroy);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle client hit scan fire request: {}", (Throwable)e);
        }
    }

    private double getMaxServerShootingDistance(class_1799 itemStack, boolean isAiming, class_3218 level) {
        MinecraftServer server = level.method_8503();
        double maxHitScanDistance = Math.min(server.method_3760().method_14568() * 16, FireModeFeature.getMaxShootingDistance(itemStack));
        if (!isAiming) {
            maxHitScanDistance = Math.min(maxHitScanDistance, 100.0);
        }
        return maxHitScanDistance;
    }

    private void hitScanTarget(class_1657 player, class_1799 itemStack, int slotIndex, int correlationId, class_239 hitResult, double maxHitScanDistance, List<class_2338> blockPosToDestroy) {
        float entityDamage = 0.0f;
        LOGGER.debug("Executing hit target task for hit result {}", (Object)hitResult);
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            entityDamage = this.hurtEntity((class_1309)player, (class_3966)hitResult, null, itemStack);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
            this.handleBlockHit((class_1309)player, (class_3965)hitResult, null);
        }
        for (class_2338 bp : blockPosToDestroy) {
            MiscUtil.getLevel((class_1297)player).method_8651(bp, true, (class_1297)player);
        }
        double maxHitScanDistanceSqr = maxHitScanDistance * maxHitScanDistance;
        for (class_3222 serverPlayer : ((class_3218)MiscUtil.getLevel((class_1297)player)).method_18766(p -> true)) {
            if (serverPlayer != player && !(serverPlayer.method_5858((class_1297)player) < maxHitScanDistanceSqr)) continue;
            LOGGER.debug("{} sends hit scan notification to {}", (Object)player, (Object)serverPlayer);
            Platform.getInstance().getNetworkService().sendToClient(new HitScanFireResponsePacket(player.method_5628(), GunItem.getItemStackId(itemStack), slotIndex, correlationId, SimpleHitResult.fromHitResult(hitResult), entityDamage), (class_1657)serverPlayer);
        }
    }

    public void handleClientFireModeRequest(class_3222 player, UUID stateId, int slotIndex, int correlationId, FireModeInstance fireModeInstance) {
        class_1799 itemStack = player.method_31548().method_5438(slotIndex);
        if (itemStack == null || !(itemStack.method_7909() instanceof GunItem)) {
            Platform.getInstance().getNetworkService().sendToClient(new FireModeResponsePacket(stateId, slotIndex, correlationId, false, fireModeInstance), (class_1657)player);
            return;
        }
        boolean isSuccess = GunItem.getFireModes(itemStack).contains(fireModeInstance);
        if (isSuccess) {
            GunItem.setFireModeInstance(itemStack, fireModeInstance);
        }
        Platform.getInstance().getNetworkService().sendToClient(new FireModeResponsePacket(stateId, slotIndex, correlationId, isSuccess, fireModeInstance), (class_1657)player);
    }

    public void processServerStateSyncResponse(UUID stateId, int correlationId, boolean isSuccess, class_1799 itemStack, GunClientState gunClientState) {
        if (isSuccess) {
            // empty if block
        }
    }

    public void processServerHitScanFireResponse(class_1657 player, UUID stateId, class_1799 itemStack, GunClientState gunClientState, SimpleHitResult hitResult, float damage) {
        if (gunClientState != null) {
            class_1792 class_17922;
            class_1657 mainPlayer = ClientUtil.getClientPlayer();
            if (player == mainPlayer) {
                if (hitResult.method_17783() != class_239.class_240.field_1333) {
                    gunClientState.confirmHitScanTarget((class_1309)mainPlayer, itemStack, hitResult, damage);
                }
            } else if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof GunItem) {
                GunItem gunItem = (GunItem)class_17922;
                gunItem.effectLauncher.onStartFiring((class_1309)mainPlayer, gunClientState, itemStack);
                gunItem.effectLauncher.onHitScanTargetAcquired((class_1309)mainPlayer, gunClientState, itemStack, hitResult);
                if (hitResult.method_17783() != class_239.class_240.field_1333) {
                    gunItem.effectLauncher.onHitScanTargetConfirmed((class_1309)mainPlayer, gunClientState, itemStack, hitResult, damage);
                }
            }
        }
    }

    public void processServerFireModeResponse(UUID stateId, int correlationId, boolean isSuccess, class_1799 itemStack, GunClientState gunClientState, FireModeInstance fireModeInstance) {
        LOGGER.debug("Process fire mode response: {}", (Object)isSuccess);
        if (isSuccess && GunItem.getFireModes(itemStack).contains(fireModeInstance)) {
            GunItem.setFireModeInstance(itemStack, fireModeInstance);
        }
    }

    public void processServerReloadResponse(int correlationId, boolean isSuccess, class_1799 itemStack, GunClientState gunClientState, int ammo, FireModeInstance fireModeInstance) {
        LOGGER.debug("Process server reload response with ammo count {}", (Object)ammo);
        gunClientState.reloadAmmo(ClientUtil.getClientLevel(), fireModeInstance, ammo);
    }

    public boolean tryReload(class_1657 player, class_1799 itemStack) {
        GunClientState gunClientState;
        boolean isMainHand;
        boolean result = false;
        int activeSlot = player.method_31548().field_7545;
        boolean bl = isMainHand = player.method_6047() == itemStack;
        if (isMainHand && (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) != null) {
            result = gunClientState.tryReload((class_1309)player, itemStack);
        }
        return result;
    }

    public boolean tryFire(class_1657 player, class_1799 itemStack, class_1297 targetEntity) {
        GunClientState gunClientState;
        boolean isMainHand;
        boolean result = false;
        int activeSlot = player.method_31548().field_7545;
        boolean bl = isMainHand = player.method_6047() == itemStack;
        if (isMainHand && (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) != null) {
            gunClientState.setTrigger(true);
            result = gunClientState.tryFire((class_1309)player, itemStack, targetEntity);
        }
        return result;
    }

    public boolean requestReloadFromServer(class_1657 player, class_1799 itemStack) {
        boolean isMainHandItem;
        LOGGER.debug("{} Initiating client side reload", (Object)(System.currentTimeMillis() % 100000L));
        boolean result = false;
        int activeSlot = player.method_31548().field_7545;
        boolean bl = isMainHandItem = player.method_6047() == itemStack;
        if (isMainHandItem) {
            FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
            int ammoToReload = this.canReloadGun(itemStack, player, fireModeInstance);
            if (ammoToReload > 0) {
                Platform.getInstance().getNetworkService().sendToServer(new ReloadRequestPacket(GunItem.getItemStackId(itemStack), activeSlot, fireModeInstance));
                result = true;
            } else {
                LOGGER.debug("No ammo to reload");
            }
        }
        return result;
    }

    public double getAimingCurveX() {
        return this.aimingCurveX;
    }

    public double getAimingCurveY() {
        return this.aimingCurveY;
    }

    public double getAimingCurveZ() {
        return this.aimingCurveZ;
    }

    public double getAimingCurvePitch() {
        return this.aimingCurvePitch;
    }

    public double getAimingCurveYaw() {
        return this.aimingCurveYaw;
    }

    public double getAimingCurveRoll() {
        return this.aimingCurveRoll;
    }

    public double getAimingZoom() {
        return this.aimingZoom;
    }

    private static FireModeInstance getNextFireModeInstance(class_1799 itemStack, FireModeInstance currentMode) {
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        int currentIndex = allFireModes.indexOf(currentMode);
        int nextIndex = (currentIndex + 1) % allFireModes.size();
        return allFireModes.get(nextIndex);
    }

    public static List<FireModeInstance> getFireModes(class_1799 itemStack) {
        ArrayList<FireModeInstance> allFireModes = new ArrayList<FireModeInstance>();
        List<Features.EnabledFeature> enabledFireModeFeatures = Features.getEnabledFeatures(itemStack, FireModeFeature.class);
        for (Features.EnabledFeature efmf : enabledFireModeFeatures) {
            FireModeFeature fmf = (FireModeFeature)efmf.feature();
            allFireModes.addAll(fmf.getFireModes());
        }
        return allFireModes;
    }

    public void initiateClientSideFireMode(class_1657 player, class_1799 itemStack) {
        FireModeInstance currentFireMode;
        FireModeInstance nextFireMode;
        GunClientState gunClientState;
        boolean isOffhand;
        int activeSlot = player.method_31548().field_7545;
        boolean bl = isOffhand = player.method_6079() == itemStack;
        if (!(isOffhand || (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) == null || gunClientState.isReloading() || gunClientState.isFiring() || gunClientState.isInspecting() || (nextFireMode = GunItem.getNextFireModeInstance(itemStack, currentFireMode = GunItem.getFireModeInstance(itemStack))) == currentFireMode)) {
            LOGGER.debug("Requesting fire mode change from {} to {}", (Object)currentFireMode.getDisplayName(), (Object)nextFireMode.getDisplayName());
            Platform.getInstance().getNetworkService().sendToServer(new FireModeRequestPacket(GunItem.getItemStackId(itemStack), activeSlot, nextFireMode));
        }
    }

    public void handleClientStopFireRequest(class_3222 player, UUID stateId, int slotIndex, int correlationId) {
    }

    public void processStopServerFireResponse(UUID stateId, int correlationId, boolean isSuccess, class_1799 itemStack, GunClientState gunClientState) {
    }

    public void setTriggerOff(class_1657 player, class_1799 itemStack) {
        GunClientState gunClientState;
        boolean isOffhand;
        int activeSlot = player.method_31548().field_7545;
        boolean bl = isOffhand = player.method_6079() == itemStack;
        if (!isOffhand && (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) != null) {
            gunClientState.setTrigger(false);
        }
    }

    public GunClientState createState(UUID stateId) {
        String controllerId;
        GunClientState state = new GunClientState(stateId, this);
        LOGGER.debug("Creating state {}", (Object)stateId);
        state.setAnimationController("playerRecoil", new PlayerRecoilController(this.viewRecoilAmplitude, this.viewRecoilMaxPitch, this.viewRecoilDuration));
        state.setAnimationController("shake", new ViewShakeAnimationController(this.shakeRecoilAmplitude, this.shakeRecoilSpeed, this.shakeDecay, this.shakeRecoilDuration){

            @Override
            public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
                FireModeInstance.ViewShakeDescriptor viewShakeDescriptor = FireModeFeature.getViewShakeDescriptor(itemStack);
                this.reset(viewShakeDescriptor);
            }
        });
        state.setAnimationController("recoil2", new GunRecoilAnimationController(this.gunRecoilInitialAmplitude, this.gunRecoilRateOfAmplitudeDecay, this.gunRecoilInitialAngularFrequency, this.gunRecoilRateOfFrequencyIncrease, this.gunRecoilPitchMultiplier, this.gunRecoilDuration, this.shotsPerRecoil));
        state.setAnimationController("randomizer", new GunRandomizingAnimationController(this.gunRandomizationAmplitude, this.idleRandomizationDuration, this.recoilRandomizationDuration));
        state.setAnimationController("reloadTimer", this.createReloadTimerController());
        for (GlowAnimationController.Builder builder : this.glowEffectBuilders) {
            controllerId = "glowEffect" + builder.getEffectId();
            state.setAnimationController(controllerId, builder.build());
        }
        for (RotationAnimationController.Builder builder : this.rotationEffectBuilders) {
            controllerId = "rotation" + builder.getModelPartName();
            state.setAnimationController(controllerId, builder.build());
        }
        state.addListener(new DynamicGeoListener());
        state.addListener(this.effectLauncher);
        state.setAnimationController("aiming", new BiDirectionalInterpolator(400L){

            @Override
            public void onToggleAiming(boolean isAiming) {
                this.set(isAiming ? BiDirectionalInterpolator.Position.END : BiDirectionalInterpolator.Position.START, false);
            }
        });
        return state;
    }

    private List<GunStateAnimationController> createReloadAnimationControllers() {
        ArrayList<GunStateAnimationController> reloadAnimationControllers = new ArrayList<GunStateAnimationController>();
        if (this.phasedReloads.isEmpty()) {
            GunStateAnimationController reloadAnimationController = new GunStateAnimationController(this, "reload_controller", DEFAULT_ANIMATION_RELOAD, ctx -> ctx.gunClientState().isReloading()){

                @Override
                public void onStartReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                    this.scheduleReset(player, state, itemStack);
                }
            };
            reloadAnimationControllers.add(reloadAnimationController);
        } else {
            long maxReloadDuration = 0L;
            for (PhasedReload phasedReload : this.phasedReloads) {
                long conditionalReloadTimeMillis = phasedReload.timeUnit.toMillis(phasedReload.cooldownTime);
                if (conditionalReloadTimeMillis <= maxReloadDuration) continue;
                maxReloadDuration = conditionalReloadTimeMillis;
            }
            int counter = 0;
            for (final PhasedReload phasedReload : this.phasedReloads) {
                ReloadAnimation reloadAnimation = phasedReload.reloadAnimation;
                final Predicate<ConditionContext> combinedPredicate = ctx -> ctx.gunClientState().isReloading() && phasedReload.predicate.test((ConditionContext)ctx);
                GunStateAnimationController reloadAnimationController = new GunStateAnimationController(this, reloadAnimation.animationName + "_" + counter++, reloadAnimation.animationName, combinedPredicate){

                    @Override
                    public void onStartReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                        if (phasedReload.phase == ReloadPhase.RELOADING && combinedPredicate.test(new ConditionContext((class_1309)((class_1657)player), itemStack, state, null))) {
                            LOGGER.debug("Reset {} on start reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }

                    @Override
                    public void onCompleteReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                        if (phasedReload.phase == ReloadPhase.COMPLETETING && combinedPredicate.test(new ConditionContext((class_1309)((class_1657)player), itemStack, state, null))) {
                            LOGGER.debug("Reset {} on complete reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }

                    @Override
                    public void onPrepareReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                        if (phasedReload.phase == ReloadPhase.PREPARING && combinedPredicate.test(new ConditionContext(player, itemStack, state, null))) {
                            LOGGER.debug("Reset {} on prepare reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }
                };
                reloadAnimationController.setSoundKeyframeHandler(event -> {
                    SoundKeyframeData soundKeyframeData;
                    String soundName;
                    class_3414 soundEvent;
                    class_1657 player = ClientUtil.getClientPlayer();
                    if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                        player.method_5783(soundEvent, 1.0f, 1.0f);
                    }
                });
                reloadAnimationControllers.add(reloadAnimationController);
            }
        }
        return reloadAnimationControllers;
    }

    private TimerController createReloadTimerController() {
        TimerController reloadTimerController;
        if (this.phasedReloads.isEmpty()) {
            reloadTimerController = new TimerController(this.reloadCooldownTime){

                @Override
                public void onStartReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                    this.reset();
                }
            };
            for (class_3545<Long, AbstractProceduralAnimationController> t : this.reloadEffectControllers) {
                reloadTimerController.schedule(ReloadPhase.RELOADING, (Long)t.method_15442(), TimeUnit.MILLISECOND, (AbstractProceduralAnimationController)t.method_15441(), null);
            }
        } else {
            long maxReloadDuration = 0L;
            for (PhasedReload phasedReload : this.phasedReloads) {
                long conditionalReloadTimeMillis = phasedReload.timeUnit.toMillis(phasedReload.cooldownTime);
                if (conditionalReloadTimeMillis <= maxReloadDuration) continue;
                maxReloadDuration = conditionalReloadTimeMillis;
            }
            reloadTimerController = new TimerController(maxReloadDuration){

                @Override
                public void onStartReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                    this.reset();
                }

                @Override
                public void onCompleteReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                    this.reset();
                }

                @Override
                public void onPrepareReloading(class_1309 player, GunClientState state, class_1799 itemStack) {
                    this.reset();
                }
            };
            for (PhasedReload phasedReload : this.phasedReloads) {
                ReloadAnimation reloadAnimation = phasedReload.reloadAnimation;
                Predicate<ConditionContext> combinedPredicate = ctx -> ctx.gunClientState().isReloading() && phasedReload.predicate.test((ConditionContext)ctx);
                for (ReloadShakeEffect effect : reloadAnimation.shakeEffects) {
                    ViewShakeAnimationController2 controller = new ViewShakeAnimationController2(effect.initialAmplitude, effect.rateOfAmplitudeDecay, effect.initialAngularFrequency, effect.rateOfFrequencyIncrease, effect.duration);
                    reloadTimerController.schedule(phasedReload.phase, phasedReload.timeUnit.toMillis(effect.startTime), TimeUnit.MILLISECOND, controller, combinedPredicate);
                }
            }
        }
        return reloadTimerController;
    }

    public Map<String, AnimationController<GeoAnimatable>> getGeoAnimationControllers(class_1799 itemStack) {
        long geoId = GeoItem.getId((class_1799)itemStack);
        AnimatableManager animatableManager = this.cache.getManagerForId(geoId);
        return animatableManager.getAnimationControllers();
    }

    public AnimationController<GeoAnimatable> getGeoAnimationController(String controllerId, class_1799 itemStack) {
        Map<String, AnimationController<GeoAnimatable>> controllers = this.getGeoAnimationControllers(itemStack);
        return controllers.get(controllerId);
    }

    public class_2960 getTargetLockOverlay() {
        return this.targetLockOverlay;
    }

    @Override
    public long getTargetLockTimeTicks() {
        return this.targetLockTimeTicks;
    }

    @Override
    public void onTargetStartLocking(class_1297 targetEntity) {
        LOGGER.debug("Locking target: {}", (Object)targetEntity);
        if (this.targetStartLockingSound != null) {
            class_1657 player = ClientUtil.getClientPlayer();
            MiscUtil.getLevel((class_1297)player).method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), this.targetStartLockingSound, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    public void onTargetLocked(class_1297 targetEntity) {
        GunClientState state;
        LOGGER.debug("Target locked: {}", (Object)targetEntity);
        class_1657 player = ClientUtil.getClientPlayer();
        if (this.targetLockedSound != null) {
            MiscUtil.getLevel((class_1297)player).method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), this.targetLockedSound, class_3419.field_15248, 1.0f, 1.0f);
        }
        if ((state = GunClientState.getMainHeldState()) != null) {
            state.publishMessage((class_2561)class_2561.method_43471((String)"message.pointblank.targetAcquired").method_27693(": ").method_10852(targetEntity.method_5477()).method_27693(". ").method_10852((class_2561)class_2561.method_43471((String)"message.pointblank.distance").method_27693(": ").method_27693("" + Math.round(targetEntity.method_5739((class_1297)player)))), 1000L, s -> true);
        }
    }

    @Override
    public void onTargetStartUnlocking(class_1297 targetEntity) {
        LOGGER.debug("Target unlocked: {}", (Object)targetEntity);
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public float getBobbing() {
        return this.bobbing;
    }

    public float getBobbingOnAim() {
        return this.bobbingOnAim;
    }

    public float getBobbingRollMultiplier() {
        return this.bobbingRollMultiplier;
    }

    public double getJumpMultiplier() {
        return this.jumpMultiplier;
    }

    public double getPipScopeZoom() {
        return this.pipScopeZoom;
    }

    public void handleAimingChangeRequest(class_1657 player, class_1799 itemStack, UUID stateId, int slotIndex, boolean isAiming) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            idTag.method_10556("aim", isAiming && this.isAimingEnabled);
        }
        if (player.method_5624() && isAiming && this.isAimingEnabled) {
            player.method_5728(false);
        }
    }

    public static boolean isAiming(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)class_17922;
        class_2487 idTag = MiscUtil.getTag(itemStack);
        if (idTag != null) {
            return gunItem.isAimingEnabled && idTag.method_10577("aim");
        }
        return false;
    }

    @Override
    public int getMaxAttachmentCategories() {
        return 11;
    }

    public List<Attachment> getDefaultAttachments() {
        return this.defaultAttachmentSuppliers.stream().map(Supplier::get).toList();
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            HashSet<AttachmentCategory> attachmentCategories = new HashSet<AttachmentCategory>();
            LinkedHashSet<Attachment> compatibleAttachments = new LinkedHashSet<Attachment>();
            for (Attachment attachment : this.getDefaultAttachments()) {
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                    LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                    break;
                }
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            for (Supplier supplier : this.compatibleAttachmentSuppliers) {
                Attachment attachment = (Attachment)supplier.get();
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                    LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                    break;
                }
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            block2: for (String string : this.compatibleAttachmentGroups) {
                List<Supplier<? extends class_1792>> groupAtttachments = ItemRegistry.ITEMS.getAttachmentsForGroup(string);
                for (Supplier<? extends class_1792> ga : groupAtttachments) {
                    class_1792 item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                        LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                        continue block2;
                    }
                    compatibleAttachments.add(attachment);
                }
            }
            this.compatibleAttachments = compatibleAttachments;
        }
        return this.compatibleAttachments;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)((Feature)featureClass.cast(this.features.get(featureClass)));
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    public class_3414 getFireSound() {
        return this.fireSound;
    }

    public float getFireSoundVolume() {
        return this.fireSoundVolume;
    }

    public static class_1799 getMainHeldGunItemStack(class_1309 player) {
        class_1799 itemStack = player.method_6047();
        return itemStack != null && itemStack.method_7909() instanceof GunItem ? itemStack : null;
    }

    public boolean hasIdleAnimations() {
        return this.idleAnimationProvider != null;
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public String getThirdPersonFallbackAnimations() {
        return this.thirdPersonFallbackAnimations;
    }

    public static class Builder
    extends HurtingItem.Builder<Builder>
    implements Nameable {
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private static final int DEFAULT_VIEW_RECOIL_DURATION = 100;
        private static final int DEFAULT_SHAKE_RECOIL_DURATION = 400;
        private static final int DEFAULT_GUN_RECOIL_DURATION = 500;
        private static final int DEFAULT_IDLE_RANDOMIZATION_DURATION = 2500;
        private static final int DEFAULT_RECOIL_RANDOMIZATION_DURATION = 250;
        private static final int DEFAULT_DRAW_COOLDOWN_DURATION = 500;
        private static final int DEFAULT_PREPARE_IDLE_COOLDOWN_DURATION = 0;
        private static final int DEFAULT_INSPECT_COOLDOWN_DURATION = 1000;
        private static final int DEFAULT_CRAFTING_DURATION = 1000;
        private static final float DEFAULT_HIT_SCAN_SPEED = 800.0f;
        private static final float DEFAULT_HIT_SCAN_ACCELERATION = 0.0f;
        private static final double DEFAULT_VIEW_RECOIL_AMPLITUDE = 1.0;
        private static final double DEFAULT_SHAKE_RECOIL_AMPLITUDE = 0.5;
        private static final int DEFAULT_VIEW_RECOIL_MAX_PITCH = 20;
        private static final double DEFAULT_SHAKE_RECOIL_SPEED = 8.0;
        private static final double DEFAULT_SHAKE_DECAY = 0.98;
        private static final double DEFAULT_GUN_RECOIL_INITIAL_AMPLITUDE = 0.3;
        private static final double DEFAULT_GUN_RECOIL_RATE_OF_AMPLITUDE_DECAY = 0.8;
        private static final double DEFAULT_GUN_RECOIL_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static final double DEFAULT_GUN_RECOIL_RATE_OF_FREQUENCY_INCREASE = 0.05;
        private static final double DEFAULT_GUN_RANDOMIZATION_AMPLITUDE = 0.01;
        private static final double DEFAULT_GUN_RECOIL_PITCH_MULTIPLIER = 1.0;
        private static final double DEFAULT_JUMP_MULTIPLIER = 1.0;
        private static final double DEFAULT_RELOAD_SHAKE_INITIAL_AMPLITUDE = 0.15;
        private static final double DEFAULT_RELOAD_SHAKE_RATE_OF_AMPLITUDE_DECAY = 0.3;
        private static final double DEFAULT_RELOAD_SHAKE_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static final double DEFAULT_RELOAD_SHAKE_RATE_OF_FREQUENCY_INCREASE = 0.01;
        private static final int DEFAULT_BURST_SHOTS = 3;
        private static final int DEFAULT_RELOAD_COOLDOWN_TIME = 1000;
        public static final double DEFAULT_AIMING_CURVE_X = 0.0;
        public static final double DEFAULT_AIMING_CURVE_Y = -0.07;
        public static final double DEFAULT_AIMING_CURVE_Z = 0.3;
        public static final double DEFAULT_AIMING_CURVE_PITCH = -0.01;
        public static final double DEFAULT_AIMING_CURVE_YAW = -0.01;
        public static final double DEFAULT_AIMING_CURVE_ROLL = -0.01;
        public static final double DEFAULT_AIMING_ZOOM = 0.05;
        public static final double DEFAULT_PELLET_SPREAD = 1.0;
        private static final double DEFAULT_INACCURACY = 0.03;
        private static final double DEFAULT_INACCURACY_AIMING = 0.0;
        private static final double DEFAULT_INACCURACY_SPRINTING = 0.1;
        private static final int DEFAULT_RPM = 600;
        private static final float DEFAULT_FIRE_SOUND_VOLUME = 5.0f;
        public static final int DEFAULT_MAX_AMMO_PER_RELOAD_ITERATION = Integer.MAX_VALUE;
        private static final String DEFAULT_RETICLE_OVERLAY = "textures/item/reticle.png";
        public static final int MAX_PELLET_SHOOTING_RANGE = 50;
        private static final float DEFAULT_BOBBING = 1.0f;
        private static final float DEFAULT_BOBBING_ON_AIM = 0.3f;
        private static final float DEFAULT_BOBBING_ROLL_MULTIPLIER = 1.0f;
        private long targetLockTimeTicks;
        private double viewRecoilAmplitude = 1.0;
        private double shakeRecoilAmplitude = 0.5;
        private int viewRecoilMaxPitch = 20;
        private long viewRecoilDuration = 100L;
        private double shakeRecoilSpeed = 8.0;
        private double shakeDecay = 0.98;
        private long shakeRecoilDuration = 400L;
        private double gunRecoilInitialAmplitude = 0.3;
        private double gunRecoilRateOfAmplitudeDecay = 0.8;
        private double gunRecoilInitialAngularFrequency = 1.0;
        private double gunRecoilRateOfFrequencyIncrease = 0.05;
        private double gunRandomizationAmplitude = 0.01;
        private double gunRecoilPitchMultiplier = 1.0;
        private long gunRecoilDuration = 500L;
        private double jumpMultiplier = 1.0;
        private int shotsPerRecoil = 1;
        private int shotsPerTrace = 1;
        private long idleRandomizationDuration = 2500L;
        private long recoilRandomizationDuration = 250L;
        private int burstShots = 3;
        private long prepareIdleCooldownDuration = 0L;
        private long prepareFireCooldownDuration = 0L;
        private long completeFireCooldownDuration = 0L;
        private long enableFireModeCooldownDuration = 0L;
        private long craftingDuration = 1000L;
        private String name;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;
        private int rpm = 600;
        private long reloadCooldownTime;
        private String reloadAnimation;
        private int maxAmmoCapacity;
        private int maxAmmoPerReloadIteration = Integer.MAX_VALUE;
        private FireMode[] fireModes;
        private Set<Supplier<AmmoItem>> compatibleAmmo = new LinkedHashSet<Supplier<AmmoItem>>();
        private Supplier<class_3414> fireSound;
        private float fireSoundVolume = 5.0f;
        private Supplier<class_3414> targetLockedSound;
        private Supplier<class_3414> targetStartLockingSound;
        private boolean isAimingEnabled = true;
        private double aimingCurveX = 0.0;
        private double aimingCurveY = -0.07;
        private double aimingCurveZ = 0.3;
        private double aimingCurvePitch = -0.01;
        private double aimingCurveYaw = -0.01;
        private double aimingCurveRoll = -0.01;
        private double aimingZoom = 0.05;
        private double pipScopeZoom = 0.0;
        private List<class_3545<Long, AbstractProceduralAnimationController>> reloadEffectControllers;
        private String scopeOverlay;
        private String reticleOverlay;
        private String targetLockOverlay;
        private List<PhasedReload> phasedReloads = new ArrayList<PhasedReload>();
        private ConditionalAnimationProvider.Builder drawAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private ConditionalAnimationProvider.Builder idleAnimationBuilder = new ConditionalAnimationProvider.Builder();
        private ConditionalAnimationProvider.Builder inspectAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private ConditionalAnimationProvider.Builder fireAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private int pelletCount = 0;
        private double pelletSpread = 1.0;
        private double inaccuracy = 0.03;
        private double inaccuracyAiming = 0.0;
        private double inaccuracySprinting = 0.1;
        private List<GlowAnimationController.Builder> glowEffectBuilders = new ArrayList<GlowAnimationController.Builder>();
        private List<RotationAnimationController.Builder> rotationEffectBuilders = new ArrayList<RotationAnimationController.Builder>();
        private Map<FirePhase, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>>> effectBuilders = new HashMap();
        private float hitScanSpeed = 800.0f;
        private float hitScanAcceleration = 0.0f;
        private float bobbing = 1.0f;
        private float bobbingOnAim = 0.3f;
        private float bobbingRollMultiplier = 1.0f;
        private float modelScale = 1.0f;
        private AnimationType animationType = AnimationType.RIFLE;
        private String firstPersonFallbackAnimations;
        private String thirdPersonFallbackAnimations;
        private List<Supplier<Attachment>> compatibleAttachments = new ArrayList<Supplier<Attachment>>();
        private List<String> compatibleAttachmentGroups = new ArrayList<String>();
        private List<FeatureBuilder<?, ?>> featureBuilders = new ArrayList();
        private List<Supplier<Attachment>> defaultAttachments = new ArrayList<Supplier<Attachment>>();
        private String thirdPersonAnimation;

        public Builder() {
            this.reloadEffectControllers = new ArrayList<class_3545<Long, AbstractProceduralAnimationController>>();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withAnimationType(AnimationType animationType) {
            this.animationType = animationType;
            return this;
        }

        public Builder withFirstPersonFallbackAnimations(String firstPersonFallbackAnimations) {
            this.firstPersonFallbackAnimations = firstPersonFallbackAnimations;
            return this;
        }

        public Builder withThirdPersonFallbackAnimations(String thirdPersonFallbackAnimations) {
            this.thirdPersonFallbackAnimations = thirdPersonFallbackAnimations;
            return this;
        }

        @SafeVarargs
        public final Builder withDefaultAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                this.defaultAttachments.add(s::get);
            }
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                this.compatibleAttachments.add(s::get);
            }
            return this;
        }

        public Builder withCompatibleAttachmentGroup(String ... groups) {
            this.compatibleAttachmentGroups.addAll(Set.of(groups));
            return this;
        }

        public Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        public Builder withModelScale(double modelScale) {
            this.modelScale = class_3532.method_15363((float)((float)modelScale), (float)0.1f, (float)1.0f);
            return this;
        }

        public Builder withTradePrice(float price, int tradeBundleQuantity, int tradeLevel) {
            this.tradePrice = price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = tradeBundleQuantity;
            return this;
        }

        public Builder withTradePrice(float price, int tradeLevel) {
            return this.withTradePrice(price, 1, tradeLevel);
        }

        public Builder withMaxAmmoCapacity(int maxAmmoCapacity) {
            this.maxAmmoCapacity = maxAmmoCapacity;
            return this;
        }

        public Builder withMaxAmmoPerReloadIteration(int maxAmmoPerReloadIteration) {
            this.maxAmmoPerReloadIteration = maxAmmoPerReloadIteration;
            return this;
        }

        public Builder withRpm(int rpm) {
            this.rpm = rpm;
            return this;
        }

        public Builder withReloadAnimation(String reloadAnimation) {
            this.reloadAnimation = reloadAnimation;
            return this;
        }

        public Builder withReloadCooldownDuration(long reloadCooldownTime, TimeUnit timeUnit) {
            this.reloadCooldownTime = timeUnit.toMillis(reloadCooldownTime);
            return this;
        }

        public Builder withFireModes(FireMode ... fireModes) {
            this.fireModes = fireModes;
            return this;
        }

        public Builder withCraftingDuration(int duration, TimeUnit timeUnit) {
            this.craftingDuration = timeUnit.toMillis(duration);
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAmmo(Supplier<AmmoItem> ... ammo) {
            for (Supplier<AmmoItem> b : ammo) {
                this.compatibleAmmo.add(b);
            }
            return this;
        }

        public final Builder withCompatibleAmmo(List<Supplier<AmmoItem>> ammo) {
            this.compatibleAmmo.addAll(ammo);
            return this;
        }

        public final Builder withTargetLock(int minTargetLockTime, TimeUnit timeUnit) {
            this.targetLockTimeTicks = timeUnit.toTicks(minTargetLockTime);
            return this;
        }

        public Builder withViewRecoilAmplitude(double amplitude) {
            this.viewRecoilAmplitude = amplitude;
            return this;
        }

        public Builder withShakeRecoilAmplitude(double amplitude) {
            this.shakeRecoilAmplitude = amplitude;
            return this;
        }

        public Builder withViewRecoilMaxPitch(int pitch) {
            this.viewRecoilMaxPitch = pitch;
            return this;
        }

        public Builder withViewRecoilDuration(int duration, TimeUnit timeUnit) {
            this.viewRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withShakeRecoilSpeed(double speed) {
            this.shakeRecoilSpeed = speed;
            return this;
        }

        public Builder withShakeDecay(double shakeDecay) {
            this.shakeDecay = shakeDecay;
            return this;
        }

        public Builder withShakeRecoilDuration(int duration, TimeUnit timeUnit) {
            this.shakeRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withGunRecoilInitialAmplitude(double amplitude) {
            this.gunRecoilInitialAmplitude = amplitude;
            return this;
        }

        public Builder withGunRecoilRateOfAmplitudeDecay(double decayRate) {
            this.gunRecoilRateOfAmplitudeDecay = decayRate;
            return this;
        }

        public Builder withGunRecoilInitialAngularFrequency(double frequency) {
            this.gunRecoilInitialAngularFrequency = frequency;
            return this;
        }

        public Builder withGunRecoilRateOfFrequencyIncrease(double rate) {
            this.gunRecoilRateOfFrequencyIncrease = rate;
            return this;
        }

        public Builder withGunRecoilPitchMultiplier(double gunRecoilPitchMultiplier) {
            this.gunRecoilPitchMultiplier = gunRecoilPitchMultiplier;
            return this;
        }

        public Builder withGunRecoilDuration(int duration, TimeUnit timeUnit) {
            this.gunRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withJumpMultiplier(double jumpMultiplier) {
            this.jumpMultiplier = jumpMultiplier;
            return this;
        }

        public Builder withShotsPerRecoil(int shotsPerRecoil) {
            this.shotsPerRecoil = shotsPerRecoil;
            return this;
        }

        public Builder withShotsPerTrace(int shotsPerTrace) {
            this.shotsPerTrace = shotsPerTrace;
            return this;
        }

        public Builder withIdleRandomizationDuration(int duration, TimeUnit timeUnit) {
            this.idleRandomizationDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withRecoilRandomizationDuration(int duration, TimeUnit timeUnit) {
            this.recoilRandomizationDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withFireSound(Supplier<class_3414> fireSound) {
            this.fireSound = fireSound;
            return this;
        }

        public Builder withFireSound(Supplier<class_3414> fireSound, float fireSoundVolume) {
            this.fireSound = fireSound;
            this.fireSoundVolume = fireSoundVolume;
            return this;
        }

        public Builder withFireSound(class_3414 fireSound) {
            this.fireSound = () -> fireSound;
            return this;
        }

        public Builder withFireSound(class_3414 fireSound, float fireSoundVolume) {
            this.fireSound = () -> fireSound;
            this.fireSoundVolume = fireSoundVolume;
            return this;
        }

        public Builder withReloadSound(Supplier<class_3414> reloadSound) {
            return this;
        }

        public Builder withReloadSound(class_3414 reloadSound) {
            return this;
        }

        public Builder withReloadShakeEffect(long startTime, long duration, TimeUnit timeUnit, double initialAmplitude, double rateOfAmplitudeDecay, double initialAngularFrequency, double rateOfFrequencyIncrease) {
            this.reloadEffectControllers.add((class_3545<Long, AbstractProceduralAnimationController>)new class_3545((Object)timeUnit.toMillis(startTime), (Object)new ViewShakeAnimationController2(initialAmplitude, rateOfAmplitudeDecay, initialAngularFrequency, rateOfFrequencyIncrease, duration)));
            return this;
        }

        public Builder withAimingEnabled(boolean aimingEnabled) {
            this.isAimingEnabled = aimingEnabled;
            return this;
        }

        public Builder withAimingCurveX(double aimingCurveX) {
            this.aimingCurveX = aimingCurveX;
            return this;
        }

        public Builder withAimingCurveY(double aimingCurveY) {
            this.aimingCurveY = aimingCurveY;
            return this;
        }

        public Builder withAimingCurveZ(double aimingCurveZ) {
            this.aimingCurveZ = aimingCurveZ;
            return this;
        }

        public Builder withAimingCurvePitch(double aimingCurvePitch) {
            this.aimingCurvePitch = aimingCurvePitch;
            return this;
        }

        public Builder withAimingCurveYaw(double aimingCurveYaw) {
            this.aimingCurveYaw = aimingCurveYaw;
            return this;
        }

        public Builder withAimingCurveRoll(double aimingCurveRoll) {
            this.aimingCurveRoll = aimingCurveRoll;
            return this;
        }

        public Builder withAimingZoom(double aimingZoom) {
            this.aimingZoom = aimingZoom;
            return this;
        }

        public Builder withPipScopeZoom(double pipScopeZoom) {
            this.pipScopeZoom = pipScopeZoom;
            return this;
        }

        public Builder withScopeOverlay(String scopeOverlay) {
            this.scopeOverlay = scopeOverlay;
            return this;
        }

        public Builder withReticleOverlay(String reticleOverlay) {
            this.reticleOverlay = reticleOverlay;
            return this;
        }

        public Builder withTargetLockOverlay(String targetLockOverlay) {
            this.targetLockOverlay = targetLockOverlay;
            return this;
        }

        public Builder withTargetLockedSound(Supplier<class_3414> targetLockedSound) {
            this.targetLockedSound = targetLockedSound;
            return this;
        }

        public Builder withTargetLockedSound(class_3414 targetLockedSound) {
            this.targetLockedSound = () -> targetLockedSound;
            return this;
        }

        public Builder withTargetStartLockingSound(Supplier<class_3414> targetStartLockingSound) {
            this.targetStartLockingSound = targetStartLockingSound;
            return this;
        }

        public Builder withTargetStartLockingSound(class_3414 targetStartLockingSound) {
            this.targetStartLockingSound = () -> targetStartLockingSound;
            return this;
        }

        public Builder withReticleOverlay() {
            this.reticleOverlay = "textures/item/reticle.png";
            return this;
        }

        public Builder withPrepareFireCooldownDuration(int duration, TimeUnit timeUnit) {
            this.prepareFireCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withCompleteFireCooldownDuration(int duration, TimeUnit timeUnit) {
            this.completeFireCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withEnableFireModeCooldownDuration(int duration, TimeUnit timeUnit) {
            this.enableFireModeCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withPrepareIdleCooldownDuration(int duration, TimeUnit timeUnit) {
            this.prepareIdleCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withDrawCooldownDuration(int duration, TimeUnit timeUnit) {
            this.withDrawAnimation(GunItem.DEFAULT_ANIMATION_DRAW, ctx -> true, duration, timeUnit);
            return this;
        }

        public Builder withDrawAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.drawAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withInspectCooldownDuration(int duration, TimeUnit timeUnit) {
            this.withInspectAnimation(GunItem.DEFAULT_ANIMATION_INSPECT, ctx -> true, duration, timeUnit);
            return this;
        }

        public Builder withInspectAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.inspectAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withIdleAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.idleAnimationBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withFireAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.fireAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withPhasedReload(PhasedReload phasedReload) {
            this.phasedReloads.add(phasedReload);
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, long cooldownTime, String animationName) {
            this.phasedReloads.add(new PhasedReload(phase, cooldownTime, animationName));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, cooldownTime, reloadAnimation));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, TriPredicate<class_1309, GunClientState, class_1799> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, predicate, cooldownTime, reloadAnimation));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, Predicate<ConditionContext> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, predicate, cooldownTime, TimeUnit.MILLISECOND, reloadAnimation));
            return this;
        }

        public Builder withPelletCount(int pelletCount) {
            this.pelletCount = pelletCount;
            return this;
        }

        public Builder withPelletSpread(double pelletSpread) {
            this.pelletSpread = pelletSpread;
            return this;
        }

        public Builder withGunRandomizationAmplitude(double gunRandomizationAmplitude) {
            this.gunRandomizationAmplitude = gunRandomizationAmplitude;
            return this;
        }

        public Builder withBurstShots(int burstShots) {
            this.burstShots = burstShots;
            return this;
        }

        public Builder withInaccuracy(double inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Builder withInaccuracyAiming(double inaccuracyAiming) {
            this.inaccuracyAiming = inaccuracyAiming;
            return this;
        }

        public Builder withInaccuracySprinting(double inaccuracySprinting) {
            this.inaccuracySprinting = inaccuracySprinting;
            return this;
        }

        public Builder withGlow(String glowingPartName) {
            return this.withGlow(glowingPartName, null);
        }

        public Builder withGlow(String glowingPartName, String textureName) {
            return this.withGlow(Collections.singleton(FirePhase.ANY), Collections.singleton(glowingPartName), textureName);
        }

        public Builder withGlow(Collection<FirePhase> firePhases, String glowingPartName) {
            return this.withGlow(firePhases, Collections.singleton(glowingPartName), null);
        }

        public Builder withGlow(Collection<FirePhase> firePhases, Collection<String> glowingPartNames, String texture) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(new class_2960("pointblank", texture));
            }
            builder.withGlowingPartNames(glowingPartNames);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withGlow(Collection<FirePhase> firePhases, String glowingPartName, String texture, AbstractEffect.SpriteAnimationType spriteAnimationType, int spriteRows, int spriteColumns, int spritesPerSecond, class_2350 ... directions) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(new class_2960("pointblank", texture));
            }
            builder.withGlowingPartNames(Collections.singleton(glowingPartName));
            builder.withSprites(spriteRows, spriteColumns, spritesPerSecond, spriteAnimationType);
            builder.withDirections(directions);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withRotation(String phase, String modelPart, double rpm, double acceleration, double deceleration) {
            RotationAnimationController.Builder builder = new RotationAnimationController.Builder().withPhase(phase).withModelPart(modelPart).withAccelerationRate(acceleration).withDecelerationRate(deceleration).withRotationsPerMinute(rpm);
            this.rotationEffectBuilders.add(builder);
            return this;
        }

        public Builder withRotation(RotationAnimationController.PhaseMapper phaseMapper, String modelPart, double rpm, double acceleration, double deceleration) {
            RotationAnimationController.Builder builder = new RotationAnimationController.Builder().withPhaseMapper(phaseMapper).withModelPart(modelPart).withAccelerationRate(acceleration).withDecelerationRate(deceleration).withRotationsPerMinute(rpm);
            this.rotationEffectBuilders.add(builder);
            return this;
        }

        public Builder withEffect(FirePhase firePhase, Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectBuilder) {
            List builders = this.effectBuilders.computeIfAbsent(firePhase, k -> new ArrayList());
            builders.add(effectBuilder);
            return this;
        }

        public Builder withHitScanSpeed(float hitScanSpeed) {
            this.hitScanSpeed = hitScanSpeed;
            return this;
        }

        public Builder withHitScanAcceleration(float hitScanAcceleration) {
            this.hitScanAcceleration = hitScanAcceleration;
            return this;
        }

        public Builder withBobbing(double bobbing) {
            this.bobbing = class_3532.method_15363((float)((float)bobbing), (float)0.0f, (float)2.0f);
            return this;
        }

        public Builder withBobbingOnAim(double bobbingOnAim) {
            this.bobbingOnAim = class_3532.method_15363((float)((float)bobbingOnAim), (float)0.0f, (float)2.0f);
            return this;
        }

        public Builder withBobbingRollMultiplier(double bobbingRollMultiplier) {
            this.bobbingRollMultiplier = class_3532.method_15363((float)((float)bobbingRollMultiplier), (float)0.0f, (float)10.0f);
            return this;
        }

        @Override
        public GunItem build() {
            return this.build("pointblank");
        }

        public GunItem build(String namespace) {
            return new GunItem(this, namespace);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder withJsonObject(JsonObject obj, boolean isClientSide) {
            JsonElement reloadSoundElem;
            JsonElement targetStartLockingSoundElem;
            super.withJsonObject(obj, isClientSide);
            Builder builder = this;
            builder.withName(obj.getAsJsonPrimitive("name").getAsString());
            builder.withAnimationType(JsonUtil.getEnum(obj, "animationType", AnimationType.class, AnimationType.RIFLE, true));
            builder.withFirstPersonFallbackAnimations(JsonUtil.getJsonString(obj, "firstPersonFallbackAnimations", null));
            builder.withThirdPersonFallbackAnimations(JsonUtil.getJsonString(obj, "thirdPersonFallbackAnimations", null));
            builder.withModelScale(JsonUtil.getJsonFloat(obj, "modelScale", 1.0f));
            builder.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "traceBundleQuantity", 1), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            JsonPrimitive jsonMaxAmmoCapacity = obj.getAsJsonPrimitive("maxAmmoCapacity");
            if (jsonMaxAmmoCapacity.isString() && "infinite".equalsIgnoreCase(jsonMaxAmmoCapacity.getAsString())) {
                builder.withMaxAmmoCapacity(Integer.MAX_VALUE);
            } else {
                builder.withMaxAmmoCapacity(obj.getAsJsonPrimitive("maxAmmoCapacity").getAsInt());
            }
            builder.withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 1000), TimeUnit.MILLISECOND);
            builder.withMaxAmmoPerReloadIteration(JsonUtil.getJsonInt(obj, "maxAmmoPerReloadIteration", Integer.MAX_VALUE));
            builder.withAimingEnabled(JsonUtil.getJsonBoolean(obj, "aimingEnabled", true));
            builder.withTargetLock(JsonUtil.getJsonInt(obj, "minTargetLockTime", 0), TimeUnit.MILLISECOND);
            builder.withRpm(JsonUtil.getJsonInt(obj, "rpm", 600));
            builder.withPrepareIdleCooldownDuration(JsonUtil.getJsonInt(obj, "prepareIdleCooldownDuration", 0), TimeUnit.MILLISECOND);
            builder.withViewRecoilMaxPitch(JsonUtil.getJsonInt(obj, "viewRecoilMaxPitch", 20));
            builder.withViewRecoilDuration(JsonUtil.getJsonInt(obj, "viewRecoilDuration", 100), TimeUnit.MILLISECOND);
            builder.withShakeRecoilDuration(JsonUtil.getJsonInt(obj, "shakeRecoilDuration", 400), TimeUnit.MILLISECOND);
            builder.withGunRecoilDuration(JsonUtil.getJsonInt(obj, "gunRecoilDuration", 500), TimeUnit.MILLISECOND);
            builder.withIdleRandomizationDuration(JsonUtil.getJsonInt(obj, "idleRandomizationDuration", 2500), TimeUnit.MILLISECOND);
            builder.withRecoilRandomizationDuration(JsonUtil.getJsonInt(obj, "recoilRandomizationDuration", 250), TimeUnit.MILLISECOND);
            builder.withBurstShots(JsonUtil.getJsonInt(obj, "burstShots", 3));
            builder.withReloadCooldownDuration(JsonUtil.getJsonInt(obj, "reloadCooldownTime", 1000), TimeUnit.MILLISECOND);
            builder.withPelletCount(JsonUtil.getJsonInt(obj, "pelletCount", 0));
            builder.withPrepareFireCooldownDuration(JsonUtil.getJsonInt(obj, "prepareFireCooldownDuration", 0), TimeUnit.MILLISECOND);
            builder.withCompleteFireCooldownDuration(JsonUtil.getJsonInt(obj, "completeFireCooldownDuration", 0), TimeUnit.MILLISECOND);
            builder.withEnableFireModeCooldownDuration(JsonUtil.getJsonInt(obj, "enableFireModeCooldownDuration", 0), TimeUnit.MILLISECOND);
            builder.withViewRecoilAmplitude(JsonUtil.getJsonDouble(obj, "viewRecoilAmplitude", 1.0));
            builder.withShakeRecoilAmplitude(JsonUtil.getJsonDouble(obj, "shakeRecoilAmplitude", 0.5));
            builder.withShakeRecoilSpeed(JsonUtil.getJsonDouble(obj, "shakeRecoilSpeed", 8.0));
            builder.withShakeDecay(JsonUtil.getJsonDouble(obj, "shakeDecay", 0.98));
            builder.withGunRecoilInitialAmplitude(JsonUtil.getJsonDouble(obj, "gunRecoilInitialAmplitude", 0.3));
            builder.withGunRecoilRateOfAmplitudeDecay(JsonUtil.getJsonDouble(obj, "gunRecoilRateOfAmplitudeDecay", 0.8));
            builder.withGunRecoilInitialAngularFrequency(JsonUtil.getJsonDouble(obj, "gunRecoilInitialAngularFrequency", 1.0));
            builder.withGunRecoilRateOfFrequencyIncrease(JsonUtil.getJsonDouble(obj, "gunRecoilRateOfFrequencyIncrease", 0.05));
            builder.withGunRecoilPitchMultiplier(JsonUtil.getJsonDouble(obj, "gunRecoilPitchMultiplier", 1.0));
            builder.withGunRandomizationAmplitude(JsonUtil.getJsonDouble(obj, "gunRandomizationAmplitude", 0.01));
            builder.withAimingCurveX(JsonUtil.getJsonDouble(obj, "aimingCurveX", 0.0));
            builder.withAimingCurveY(JsonUtil.getJsonDouble(obj, "aimingCurveY", -0.07));
            builder.withAimingCurveZ(JsonUtil.getJsonDouble(obj, "aimingCurveZ", 0.3));
            builder.withAimingCurvePitch(JsonUtil.getJsonDouble(obj, "aimingCurvePitch", -0.01));
            builder.withAimingCurveYaw(JsonUtil.getJsonDouble(obj, "aimingCurveYaw", -0.01));
            builder.withAimingCurveRoll(JsonUtil.getJsonDouble(obj, "aimingCurveRoll", -0.01));
            builder.withAimingZoom(JsonUtil.getJsonDouble(obj, "aimingZoom", 0.05));
            builder.withPipScopeZoom(JsonUtil.getJsonDouble(obj, "pipScopeZoom", 0.0));
            builder.withShotsPerRecoil(JsonUtil.getJsonInt(obj, "shotsPerRecoil", 1));
            builder.withShotsPerTrace(JsonUtil.getJsonInt(obj, "shotsPerTrace", 1));
            builder.withPelletSpread(JsonUtil.getJsonDouble(obj, "pelletSpread", 1.0));
            builder.withInaccuracy(JsonUtil.getJsonDouble(obj, "inaccuracy", 0.03));
            builder.withInaccuracyAiming(JsonUtil.getJsonDouble(obj, "inaccuracyAiming", 0.0));
            builder.withInaccuracySprinting(JsonUtil.getJsonDouble(obj, "inaccuracySprinting", 0.1));
            builder.withJumpMultiplier(JsonUtil.getJsonDouble(obj, "jumpMultiplier", 1.0));
            builder.withScopeOverlay(obj.has("scopeOverlay") ? obj.getAsJsonPrimitive("scopeOverlay").getAsString() : null);
            builder.withReticleOverlay(obj.has("reticleOverlay") ? obj.getAsJsonPrimitive("reticleOverlay").getAsString() : null);
            builder.withTargetLockOverlay(obj.has("targetLockOverlay") ? obj.getAsJsonPrimitive("targetLockOverlay").getAsString() : null);
            JsonElement targetLockedSoundElem = obj.get("targetLockedSound");
            if (targetLockedSoundElem != null && !targetLockedSoundElem.isJsonNull()) {
                String targetLockedSoundName = targetLockedSoundElem.getAsString();
                builder.withTargetLockedSound(() -> SoundRegistry.getSoundEvent(targetLockedSoundName));
            }
            if ((targetStartLockingSoundElem = obj.get("targetStartLockingSound")) != null && !targetStartLockingSoundElem.isJsonNull()) {
                String targetStargetLockingdSoundName = targetStartLockingSoundElem.getAsString();
                builder.withTargetStartLockingSound(() -> SoundRegistry.getSoundEvent(targetStargetLockingdSoundName));
            }
            List<String> fireModeNames = JsonUtil.getStrings(obj, "fireModes");
            builder.withFireModes((FireMode[])fireModeNames.stream().map(n -> FireMode.valueOf(n.toUpperCase(Locale.ROOT))).toArray(FireMode[]::new));
            builder.withHitScanSpeed(JsonUtil.getJsonFloat(obj, "hitScanSpeed", 800.0f));
            builder.withHitScanAcceleration(JsonUtil.getJsonFloat(obj, "hitScanAcceleration", 0.0f));
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "reloadShakeEffects")) {
                builder.withReloadShakeEffect(jsonObject.getAsJsonPrimitive("start").getAsInt(), jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND, JsonUtil.getJsonDouble(jsonObject, "initialAmplitude", 0.15), JsonUtil.getJsonDouble(jsonObject, "rateOfAmplitudeDecay", 0.3), JsonUtil.getJsonDouble(jsonObject, "initialAngularFrequency", 1.0), JsonUtil.getJsonDouble(jsonObject, "rateOfFrequencyIncrease", 0.01));
            }
            List<JsonObject> jsPhasedReloads = JsonUtil.getJsonObjects(obj, "phasedReloads");
            for (JsonObject jsPhasedReload : jsPhasedReloads) {
                ArrayList<ReloadShakeEffect> shakeEffects = new ArrayList<ReloadShakeEffect>();
                for (JsonObject jsReloadShakeEffect : JsonUtil.getJsonObjects(jsPhasedReload, "shakeEffects")) {
                    shakeEffects.add(new ReloadShakeEffect(jsReloadShakeEffect.getAsJsonPrimitive("start").getAsLong(), jsReloadShakeEffect.getAsJsonPrimitive("duration").getAsLong(), TimeUnit.MILLISECOND, JsonUtil.getJsonDouble(jsReloadShakeEffect, "initialAmplitude", 0.15), JsonUtil.getJsonDouble(jsReloadShakeEffect, "rateOfAmplitudeDecay", 0.3), JsonUtil.getJsonDouble(jsReloadShakeEffect, "initialAngularFrequency", 1.0), JsonUtil.getJsonDouble(jsReloadShakeEffect, "rateOfFrequencyIncrease", 0.01)));
                }
                Predicate<ConditionContext> condition = jsPhasedReload.has("condition") ? Conditions.fromJson(jsPhasedReload.get("condition")) : ctx -> true;
                builder.withPhasedReload(new PhasedReload(ReloadPhase.valueOf(jsPhasedReload.getAsJsonPrimitive("phase").getAsString()), condition, jsPhasedReload.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND, new ReloadAnimation(jsPhasedReload.getAsJsonPrimitive("animation").getAsString(), shakeEffects)));
            }
            JsonElement jsonElement = obj.get("reloadAnimation");
            String reloadAnimation = jsonElement != null ? jsonElement.getAsString() : null;
            builder.withReloadAnimation(reloadAnimation);
            float fireSoundVolume = JsonUtil.getJsonFloat(obj, "fireSoundVolume", 5.0f);
            JsonElement fireSoundElem = obj.get("fireSound");
            if (fireSoundElem != null && !fireSoundElem.isJsonNull()) {
                String fireSoundName = fireSoundElem.getAsString();
                builder.withFireSound(() -> SoundRegistry.getSoundEvent(fireSoundName), fireSoundVolume);
            }
            if ((reloadSoundElem = obj.get("reloadSound")) != null && !reloadSoundElem.isJsonNull()) {
                String reloadSoundName = reloadSoundElem.getAsString();
                builder.withReloadSound(() -> SoundRegistry.getSoundEvent(reloadSoundName));
            }
            List<String> compatibleAmmoNames = JsonUtil.getStrings(obj, "compatibleAmmo");
            ArrayList<Supplier<AmmoItem>> compatibleAmmo = new ArrayList<Supplier<AmmoItem>>();
            for (String string : compatibleAmmoNames) {
                Supplier supplier = ItemRegistry.ITEMS.getDeferredRegisteredObject(string);
                if (supplier == null) continue;
                compatibleAmmo.add(supplier);
            }
            builder.withCompatibleAmmo(compatibleAmmo);
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "rotations")) {
                builder.withRotation(JsonUtil.getJsonString(jsonObject, "phase", "fire"), JsonUtil.getJsonString(jsonObject, "modelPart", null), JsonUtil.getJsonDouble(jsonObject, "rpm", 180.0), JsonUtil.getJsonDouble(jsonObject, "acceleration", 1.0), JsonUtil.getJsonDouble(jsonObject, "deceleration", 5.0));
            }
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "effects")) {
                FirePhase firePhase = JsonUtil.getEnum(jsonObject, "phase", FirePhase.class, null, true);
                String string = JsonUtil.getJsonString(jsonObject, "name");
                Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                builder.withEffect(firePhase, supplier);
            }
            builder.withBobbing(JsonUtil.getJsonDouble(obj, "bobbing", 1.0));
            builder.withBobbingOnAim(JsonUtil.getJsonFloat(obj, "bobbingOnAim", 0.3f));
            builder.withBobbingRollMultiplier(JsonUtil.getJsonDouble(obj, "bobbingRollMultiplier", 1.0));
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "glowingParts")) {
                void var20_51;
                String string = JsonUtil.getJsonString(jsonObject, "name");
                List<String> list = JsonUtil.getStrings(obj, "phases");
                List<FirePhase> list2 = list.stream().map(n -> FirePhase.valueOf(n.toUpperCase(Locale.ROOT))).toList();
                if (list2.isEmpty()) {
                    List<FirePhase> list3 = Collections.singletonList(FirePhase.ANY);
                }
                String string2 = JsonUtil.getJsonString(jsonObject, "texture", null);
                class_2350 class_23502 = JsonUtil.getEnum(jsonObject, "direction", class_2350.class, null, true);
                JsonObject spritesObj = jsonObject.getAsJsonObject("sprites");
                if (spritesObj != null) {
                    int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                    int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                    int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                    AbstractEffect.SpriteAnimationType spriteAnimationType = JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                    if (class_23502 != null) {
                        builder.withGlow((Collection<FirePhase>)var20_51, string, string2, spriteAnimationType, rows, columns, fps, class_23502);
                        continue;
                    }
                    builder.withGlow((Collection<FirePhase>)var20_51, string, string2, spriteAnimationType, rows, columns, fps, new class_2350[0]);
                    continue;
                }
                builder.withGlow((Collection<FirePhase>)var20_51, Collections.singletonList(string), string2);
            }
            List<String> compatibleAttachmentNames = JsonUtil.getStrings(obj, "compatibleAttachments");
            for (String string : compatibleAttachmentNames) {
                Supplier supplier = ItemRegistry.ITEMS.getDeferredRegisteredObject(string);
                if (supplier == null) continue;
                this.withCompatibleAttachment(() -> (Attachment)ri.get());
            }
            List<String> list = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(list);
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(jsonObject);
                this.withFeature(featureBuilder);
            }
            List<String> list4 = JsonUtil.getStrings(obj, "defaultAttachments");
            for (String string : list4) {
                Supplier supplier = ItemRegistry.ITEMS.getDeferredRegisteredObject(string);
                if (supplier == null) continue;
                this.withDefaultAttachment(() -> (Attachment)ri.get());
            }
            List<JsonObject> list5 = JsonUtil.getJsonObjects(obj, "idleAnimations");
            for (JsonObject jsonObject : list5) {
                Predicate<ConditionContext> predicate = jsonObject.has("condition") ? Conditions.fromJson(jsonObject.get("condition")) : ctx -> true;
                builder.withIdleAnimation(JsonUtil.getJsonString(jsonObject, "name", GunItem.DEFAULT_ANIMATION_IDLE), predicate, jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            List<JsonObject> list6 = JsonUtil.getJsonObjects(obj, "inspectAnimations");
            for (JsonObject jsonObject : list6) {
                Predicate<ConditionContext> condition = jsonObject.has("condition") ? Conditions.fromJson(jsonObject.get("condition")) : ctx -> true;
                builder.withInspectAnimation(JsonUtil.getJsonString(jsonObject, "name", GunItem.DEFAULT_ANIMATION_INSPECT), condition, jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            if (list6.isEmpty()) {
                builder.withInspectCooldownDuration(JsonUtil.getJsonInt(obj, "inspectCooldownDuration", 1000), TimeUnit.MILLISECOND);
            }
            List<JsonObject> list7 = JsonUtil.getJsonObjects(obj, "drawAnimations");
            for (JsonObject jsIdleAnimation : list7) {
                Predicate<ConditionContext> condition = jsIdleAnimation.has("condition") ? Conditions.fromJson(jsIdleAnimation.get("condition")) : ctx -> true;
                builder.withDrawAnimation(JsonUtil.getJsonString(jsIdleAnimation, "name", GunItem.DEFAULT_ANIMATION_DRAW), condition, jsIdleAnimation.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            if (list7.isEmpty()) {
                builder.withDrawCooldownDuration(JsonUtil.getJsonInt(obj, "drawCooldownDuration", 500), TimeUnit.MILLISECOND);
            }
            List<JsonObject> list8 = JsonUtil.getJsonObjects(obj, "fireAnimations");
            for (JsonObject jsFireAnimation : list8) {
                Predicate<ConditionContext> condition = jsFireAnimation.has("condition") ? Conditions.fromJson(jsFireAnimation.get("condition")) : ctx -> true;
                builder.withFireAnimation(JsonUtil.getJsonString(jsFireAnimation, "name", GunItem.DEFAULT_ANIMATION_INSPECT), condition, 0, TimeUnit.MILLISECOND);
            }
            return this;
        }
    }

    public static enum AnimationType {
        RIFLE("__DEFAULT_RIFLE_ANIMATIONS__", FALLBACK_COMMON_ANIMATIONS),
        PISTOL("__DEFAULT_PISTOL_ANIMATIONS__", FALLBACK_PISTOL_ANIMATIONS);

        private final String defaultThirdPersonAnimation;
        private final List<class_2960> fallbackFirstPersonAnimations;

        private AnimationType(String defaultThirdPersonAnimation, List<class_2960> fallbackFirstPersonAnimations) {
            this.defaultThirdPersonAnimation = defaultThirdPersonAnimation;
            this.fallbackFirstPersonAnimations = fallbackFirstPersonAnimations;
        }

        public String getDefaultThirdPersonAnimation() {
            return this.defaultThirdPersonAnimation;
        }

        private List<class_2960> getFallbackFirstPersonAnimations() {
            return this.fallbackFirstPersonAnimations;
        }
    }

    public record PhasedReload(ReloadPhase phase, Predicate<ConditionContext> predicate, long cooldownTime, TimeUnit timeUnit, ReloadAnimation reloadAnimation) {
        public PhasedReload {
            if (cooldownTime == 0L) {
                throw new IllegalArgumentException("cooldownTime cannot be null");
            }
            if (timeUnit == null) {
                throw new IllegalArgumentException("timeUnit cannot be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("predicate cannot be null");
            }
        }

        public PhasedReload(ReloadPhase phase, TriPredicate<class_1309, GunClientState, class_1799> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this(phase, ctx -> predicate.test(ctx.player(), ctx.gunClientState(), ctx.currentItemStack()), cooldownTime, TimeUnit.MILLISECOND, reloadAnimation);
        }

        public PhasedReload(ReloadPhase phase, long cooldownTime, ReloadAnimation reloadAnimation) {
            this(phase, ctx -> true, cooldownTime, TimeUnit.MILLISECOND, reloadAnimation);
        }

        public PhasedReload(ReloadPhase phase, long cooldownTime, String animationName) {
            this(phase, ctx -> true, cooldownTime, TimeUnit.MILLISECOND, new ReloadAnimation(animationName));
        }
    }

    public static enum ReloadPhase {
        PREPARING,
        RELOADING,
        COMPLETETING;

    }

    public static enum FirePhase {
        PREPARING,
        FIRING,
        COMPLETETING,
        HIT_SCAN_ACQUIRED,
        HIT_TARGET,
        ANY,
        FLYING;

    }

    public record ReloadAnimation(String animationName, List<ReloadShakeEffect> shakeEffects) {
        public ReloadAnimation(String animationName) {
            this(animationName, Collections.emptyList());
        }
    }

    public record ReloadShakeEffect(long startTime, long duration, TimeUnit timeUnit, double initialAmplitude, double rateOfAmplitudeDecay, double initialAngularFrequency, double rateOfFrequencyIncrease) {
        private static double DEFAULT_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static double DEFAULT_RATE_OF_FREQUENCY_INCREASE = 0.01;

        public ReloadShakeEffect(long startTime, long duration, double initialAmplitude, double rateOfAmplitudeDecay) {
            this(startTime, duration, TimeUnit.MILLISECOND, initialAmplitude, rateOfAmplitudeDecay, DEFAULT_INITIAL_ANGULAR_FREQUENCY, DEFAULT_RATE_OF_FREQUENCY_INCREASE);
        }
    }
}

