/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.entity;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.client.EntityRendererBuilder;
import com.vicmatskiv.pointblank.item.EffectBuilderInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public interface EntityBuilder<T extends EntityBuilder<T, E>, E extends class_1297> {
    public static EntityBuilder<?, ?> fromZipEntry(ZipFile zipFile, ZipEntry entry, boolean isClientSide) {
        EntityBuilder<?, ?> entityBuilder;
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        try {
            entityBuilder = EntityBuilder.fromReader(reader, isClientSide);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return entityBuilder;
    }

    public static EntityBuilder<?, ?> fromPath(Path path, boolean isClientSide) {
        EntityBuilder<?, ?> entityBuilder;
        block8: {
            BufferedReader br = Files.newBufferedReader(path);
            try {
                entityBuilder = EntityBuilder.fromReader(br, isClientSide);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            br.close();
        }
        return entityBuilder;
    }

    public static EntityBuilder<?, ?> fromReader(Reader reader, boolean isClientSide) {
        throw new UnsupportedOperationException();
    }

    public T withJsonObject(JsonObject var1);

    public String getName();

    public EntityTypeExt getEntityTypeExt();

    public class_1299.class_1300<E> getEntityTypeBuilder();

    public boolean hasRenderer();

    public class_897<?> createEntityRenderer(class_5617.class_5618 var1);

    public EntityBuilder<?, ?> withName(String var1);

    public EntityBuilder<?, ?> withItem(Supplier<class_1792> var1);

    public EntityBuilder<?, ?> withInitialVelocity(double var1);

    public EntityBuilder<?, ?> withMaxLifetime(long var1);

    public EntityBuilder<?, ?> withRenderer(Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> var1);

    public EntityBuilder<?, ?> withGravity(double var1);

    public EntityBuilder<?, ?> withEffect(EffectBuilderInfo var1);

    public EntityBuilder<?, ?> withRicochet(boolean var1);

    public E build(class_1937 var1);

    public static enum EntityTypeExt {
        PROJECTILE;

    }
}

