/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.google.common.base.Objects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStatePoseProvider;
import com.vicmatskiv.pointblank.client.controller.GlowAnimationController;
import com.vicmatskiv.pointblank.client.controller.RotationAnimationController;
import com.vicmatskiv.pointblank.client.effect.EffectRenderContext;
import com.vicmatskiv.pointblank.client.effect.MuzzleFlashEffect;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.model.GunGeoModel;
import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderApprover;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderPassGeoRenderer;
import com.vicmatskiv.pointblank.client.render.RenderPassProvider;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.client.render.layer.AttachmentLayer;
import com.vicmatskiv.pointblank.client.render.layer.GlowingItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.GunHandsItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.MuzzleFlashItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.PipItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.ReticleItemLayer;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import com.vicmatskiv.pointblank.feature.ActiveMuzzleFeature;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.feature.PartVisibilityFeature;
import com.vicmatskiv.pointblank.feature.SkinFeature;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.registry.EffectRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class GunItemRenderer
extends GeoItemRenderer<GunItem>
implements RenderPassGeoRenderer<GunItem>,
RenderApprover {
    public static final String BONE_SCOPE = "scope";
    public static final String BONE_RETICLE = "reticle";
    public static final String BONE_SCOPE_PIP = "scopepip";
    public static final String BONE_RIGHTARM = "rightarm";
    public static final String BONE_LEFTARM = "leftarm";
    public static final String BONE_MUZZLE = "muzzle";
    public static final String BONE_MUZZLE2 = "muzzle2";
    public static final String BONE_MUZZLE3 = "muzzle3";
    public static final String BONE_MUZZLEFLASH = "muzzleflash";
    public static final String BONE_MUZZLEFLASH2 = "muzzleflash2";
    public static final String BONE_MUZZLEFLASH3 = "muzzleflash3";
    public static final String BONE_CAMERA = "_camera_";
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET = class_3532.method_15362((float)0.08726646f);
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED = class_3532.method_15362((float)((float)Math.PI / 90));
    private GunClientState gunClientState;
    private boolean hasScopeOverlay;
    private class_809 transforms;
    private class_2960 leftHandModelResource = new class_2960("pointblank", "geo/item/left_arm.geo.json");
    private class_2960 rightHandModelResource = new class_2960("pointblank", "geo/item/right_arm.geo.json");
    private class_2960 reticleModelResource = new class_2960("pointblank", "geo/item/reticle.geo.json");
    private boolean useCustomGlowingTexture;
    private Set<class_2350> glowDirections;
    private Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier;
    private float glowingProgress;

    public GunItemRenderer(class_2960 modelResource, List<class_2960> fallbackAnimations, List<GlowAnimationController.Builder> glowEffectBuilders) {
        super((GeoModel)new GunGeoModel(modelResource, fallbackAnimations));
        this.addRenderLayer(new AttachmentLayer<GunItem>(this));
        for (GlowAnimationController.Builder glowEffectBuilder : glowEffectBuilders) {
            class_2960 glowTexture = glowEffectBuilder.getTexture();
            if (glowTexture == null) {
                glowTexture = this.getGeoModel().getTextureResource((GeoAnimatable)((GunItem)this.animatable));
            }
            this.addRenderLayer(new GlowingItemLayer<GunItem>(this, glowEffectBuilder.getEffectId(), glowTexture));
        }
        this.addRenderLayer(new GunHandsItemLayer<GunItem>(this));
        this.addRenderLayer(new PipItemLayer(this));
        this.addRenderLayer(new ReticleItemLayer(this));
        this.addRenderLayer(new MuzzleFlashItemLayer(this));
    }

    public class_2960 getTextureLocation(GunItem animatable) {
        class_2960 texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            class_1799 itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((class_1792)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<GunItem> getRenderer() {
        return this;
    }

    public GunClientState getGunClientState() {
        return this.gunClientState;
    }

    private BakedGeoModel getLeftHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.leftHandModelResource);
    }

    private BakedGeoModel getRightHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.rightHandModelResource);
    }

    private BakedGeoModel getReticleModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.reticleModelResource);
    }

    private class_1657 getPlayer(class_811 itemDisplayContext) {
        if (itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322 || itemDisplayContext == class_811.field_4318) {
            return ClientUtils.getClientPlayer();
        }
        class_1309 renderedEntity = ClientEventHandler.getCurrentEntityLiving();
        if (renderedEntity instanceof class_1657) {
            return (class_1657)renderedEntity;
        }
        return null;
    }

    public void method_3166(class_1799 stack, class_811 itemDisplayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (IrisCompat.getInstance().isRenderingShadows()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 instanceof AttachmentManagerScreen && itemDisplayContext != class_811.field_4318) {
            return;
        }
        class_1657 player = this.getPlayer(itemDisplayContext);
        if (player == null) {
            return;
        }
        class_4597 wrappedBufferSource = RenderTypeProvider.getInstance().wrapBufferSource(bufferSource);
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(stack, itemDisplayContext);){
            this.renderPass(() -> {
                boolean isOffhand;
                int slotIndex = player.method_31548().method_7395(stack);
                GunClientState state = GunClientState.getState(player, stack, slotIndex, isOffhand = player != null && player.method_6079() == stack);
                if (state != null) {
                    GunStatePoseProvider.getInstance().clear(state.getId());
                }
                boolean isFirstPerson = itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322;
                poseStack.method_22903();
                GunItem gunItem = (GunItem)stack.method_7909();
                this.hasScopeOverlay = gunItem.getScopeOverlay() != null;
                GeoModel geoModel = this.getGeoModel();
                if (isFirstPerson) {
                    GeoBone scopeBone = geoModel.getBone(BONE_SCOPE).orElse(null);
                    this.initTransforms(player, stack, itemDisplayContext);
                    this.adjustFirstPersonPose(stack, gunItem, state, poseStack, (GeoModel<GunItem>)geoModel, scopeBone);
                }
                this.gunClientState = state;
                super.method_3166(stack, itemDisplayContext, poseStack, wrappedBufferSource, packedLight, packedOverlay);
                poseStack.method_22909();
            });
        }
    }

    @Override
    public void renderPass(Runnable runnablePass) {
        RenderPass.push(this.getRenderPass());
        try {
            runnablePass.run();
        }
        finally {
            RenderPass.pop();
        }
    }

    private void adjustFirstPersonPose(class_1799 itemStack, GunItem gunItem, GunClientState state, class_4587 poseStack, GeoModel<GunItem> geoModel, GeoBone scopeBone) {
        if (this.transforms == null) {
            return;
        }
        class_804 fprt = this.transforms.field_4304;
        if (fprt == null) {
            return;
        }
        float aimingProgress = 0.0f;
        if (state != null) {
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)state.getAnimationController("aiming");
            aimingProgress = (float)aimingController.getValue();
        }
        float v = 1.0f - aimingProgress;
        float rescale = gunItem.getModelScale();
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907(new Quaternionf().rotationXYZ(-fprt.field_4287.x * ((float)Math.PI / 180), -fprt.field_4287.y * ((float)Math.PI / 180), -fprt.field_4287.z * ((float)Math.PI / 180)));
        poseStack.method_46416(-fprt.field_4286.x, -fprt.field_4286.y, -fprt.field_4286.z);
        poseStack.method_46416(fprt.field_4286.x * rescale, fprt.field_4286.y * rescale, fprt.field_4286.z * rescale);
        poseStack.method_22907(new Quaternionf().rotationXYZ(v * fprt.field_4287.x * ((float)Math.PI / 180), v * fprt.field_4287.y * ((float)Math.PI / 180), v * fprt.field_4287.z * ((float)Math.PI / 180)));
        poseStack.method_46416(aimingProgress * -fprt.field_4286.x * rescale, aimingProgress * -fprt.field_4286.y * rescale, aimingProgress * -fprt.field_4286.z * rescale);
        AimingFeature.applyAimingPosition(itemStack, poseStack, rescale, aimingProgress);
        poseStack.method_22905(rescale, rescale, rescale);
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        float curve = class_3532.method_15374((float)((float)Math.PI * aimingProgress));
        double aimingCurveX = gunItem.getAimingCurveX();
        double aimingCurveY = gunItem.getAimingCurveY();
        double aimingCurveZ = gunItem.getAimingCurveZ();
        double aimingCurvePitch = gunItem.getAimingCurvePitch();
        double aimingCurveYaw = gunItem.getAimingCurveYaw();
        double aimingCurveRoll = gunItem.getAimingCurveRoll();
        poseStack.method_22904((double)curve * aimingCurveX, (double)curve * aimingCurveY, (double)curve * aimingCurveZ);
        poseStack.method_22907(new Quaternionf((double)curve * aimingCurvePitch * 0.01745329238474369, (double)curve * aimingCurveYaw * 0.01745329238474369, (double)curve * aimingCurveRoll * 0.01745329238474369, 1.0));
        poseStack.method_46416(0.48f * v, -1.12f * v, -0.72f * v);
        poseStack.method_46416(-0.006f, 0.6f, 0.0f);
    }

    private void initTransforms(class_1657 player, class_1799 stack, class_811 itemDisplayContext) {
        if (this.transforms == null) {
            this.transforms = Platform.getInstance().getItemTransforms(player, stack).apply(itemDisplayContext);
        }
    }

    public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float[][] texUV;
        if (RenderPass.current() == RenderPass.RETICLE && quad.direction() != class_2350.field_11035) {
            return;
        }
        GeoVertex[] vertices = quad.vertices();
        if (this.glowingSpriteUVProviderSupplier != null) {
            SpriteUVProvider spriteUVProvider = this.glowingSpriteUVProviderSupplier.get();
            float[] uv = spriteUVProvider.getSpriteUV(this.glowingProgress);
            float minU = uv[0];
            float minV = uv[1];
            float maxU = uv[2];
            float maxV = uv[3];
            texUV = new float[][]{{minU, minV}, {maxU, minV}, {maxU, maxV}, {minU, maxV}};
        } else {
            texUV = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
        }
        for (int i = 0; i < vertices.length; ++i) {
            float texV;
            float texU;
            GeoVertex vertex = vertices[i];
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            RenderPass renderPass = RenderPass.current();
            if (renderPass == RenderPass.GLOW && this.useCustomGlowingTexture) {
                texU = texUV[i][0];
                texV = texUV[i][1];
            } else {
                texU = vertex.texU();
                texV = vertex.texV();
            }
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, texU, texV, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    private boolean shouldRenderBone(String boneName) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        class_1799 rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = true;
        for (GeoRenderLayer layer : this.getRenderLayers()) {
            RenderPass renderPass;
            RenderPass renderPass2;
            if (!(layer instanceof RenderApprover)) continue;
            RenderApprover renderApprover = (RenderApprover)layer;
            if (layer instanceof RenderPassProvider) {
                RenderPassProvider rp = (RenderPassProvider)layer;
                renderPass2 = rp.getRenderPass();
            } else {
                renderPass2 = null;
            }
            if (renderApprover.approveRendering(renderPass = renderPass2, boneName, rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext())) continue;
            shouldRender = false;
            break;
        }
        return shouldRender;
    }

    public void renderRecursively(class_4587 poseStack, GunItem animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        class_1799 rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = this.approveRendering(this.getRenderPass(), bone.getName(), rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext());
        if (shouldRender) {
            boolean isGlowEnabled;
            GlowAnimationController glowEffect = this.gunClientState != null ? (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + RenderPass.getEffectId()) : null;
            Runnable r = () -> {
                RotationAnimationController spinner;
                RotationAnimationController rotationAnimationController = spinner = this.gunClientState != null ? (RotationAnimationController)this.gunClientState.getAnimationController("rotation" + bone.getName()) : null;
                if (spinner != null) {
                    spinner.renderRecursively(this, poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                } else {
                    super.renderRecursively(poseStack, (class_1792)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                }
            };
            boolean bl = isGlowEnabled = glowEffect != null && glowEffect.getGlowingPartNames().contains(bone.getName());
            if (isGlowEnabled) {
                try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push(current.getItemStack(), current.getItemDisplayContext());){
                    GlowingItemLayer.setGlowEnabled(isGlowEnabled);
                    r.run();
                }
            } else {
                r.run();
            }
        }
    }

    public void renderRecursivelySuper(class_4587 poseStack, GunItem animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (class_1792)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderCubesOfBone(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderPass renderPass = RenderPass.current();
        if (!this.shouldRenderBone(bone.getName())) {
            return;
        }
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        class_811 itemDisplayContext = hrc.getItemDisplayContext();
        boolean isFirstPerson = itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322;
        double aimingProgress = 0.0;
        if (this.gunClientState != null) {
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)this.gunClientState.getAnimationController("aiming");
            aimingProgress = aimingController.getValue();
            if ((!MiscUtil.isGreaterThanZero(this.gunClientState.getGunItem().getPipScopeZoom()) || !Config.pipScopesEnabled) && this.hasScopeOverlay && !this.gunClientState.isReloading() && isFirstPerson && aimingProgress > 0.4) {
                return;
            }
        }
        switch (renderPass) {
            case GLOW: {
                this.renderGlow(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case HANDS: {
                if (bone.getName().equals(BONE_RIGHTARM)) {
                    this.renderRightArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                if (!bone.getName().equals(BONE_LEFTARM)) break;
                this.renderLeftArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case PIP: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderPip(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress);
                break;
            }
            case PIP_OVERLAY: {
                if (!bone.getName().equals(BONE_SCOPE_PIP) || !(aimingProgress > 0.0)) break;
                this.renderPipOverlay(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress, PipItemLayer.isParallaxEnabled());
                break;
            }
            case PIP_MASK: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderPipMask(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress);
                break;
            }
            case RETICLE: {
                boolean isParallaxEnabled = ReticleItemLayer.isParallaxEnabled();
                if (isParallaxEnabled && bone.getName().equals(BONE_RETICLE)) {
                    this.renderReticleWithParallax(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress, hrc.getAttribute("max_angular_offset_cos", Float.valueOf(DEFAULT_MAX_ANGULAR_RETICLE_OFFSET)).floatValue());
                    break;
                }
                if (isParallaxEnabled || !bone.getName().equals(BONE_SCOPE)) break;
                this.renderReticle(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, aimingProgress);
                break;
            }
            case MUZZLE_FLASH: {
                if (!bone.getName().equals(BONE_MUZZLEFLASH) && !bone.getName().equals(BONE_MUZZLEFLASH2) && !bone.getName().equals(BONE_MUZZLEFLASH3)) break;
                this.renderMuzzleFlash(poseStack, bone, buffer, packedLight);
                break;
            }
            case MAIN_ITEM: 
            case ATTACHMENTS: {
                if (bone.getName().equals(BONE_MUZZLEFLASH) || bone.getName().equals(BONE_MUZZLEFLASH2) || bone.getName().equals(BONE_MUZZLEFLASH3) || bone.getName().equals(BONE_MUZZLE) || bone.getName().equals(BONE_MUZZLE2) || bone.getName().equals(BONE_MUZZLE3)) {
                    if (!ActiveMuzzleFeature.isActiveMuzzle(HierarchicalRenderContext.getRootItemStack(), hrc.getItemStack(), itemDisplayContext, bone.getName())) break;
                    this.captureMuzzlePose(bone, poseStack, itemDisplayContext);
                    break;
                }
                if (!this.canRenderPart(bone.getName())) break;
                super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
    }

    private void renderGlow(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        GlowAnimationController glowEffect;
        if (this.gunClientState == null) {
            return;
        }
        if (GlowingItemLayer.isGlowEnabled() && (glowEffect = (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + RenderPass.getEffectId())) != null) {
            glowEffect.renderCubesOfBone(this, poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private void renderMuzzleFlash(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight) {
        if (this.gunClientState == null || this.gunClientState.isReloading() || this.gunClientState.isInspecting()) {
            return;
        }
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad quad1 = cube.quads()[0];
            Vector3f v1Position = quad1.vertices()[0].position();
            GeoQuad quad2 = cube.quads()[2];
            Vector3f v3Position = quad2.vertices()[2].position();
            Vector3f position = new Vector3f();
            position = v3Position.sub((Vector3fc)v1Position, position);
            position = position.mul(0.5f);
            position = position.add((Vector3fc)v1Position);
            EffectRenderContext context = new EffectRenderContext().withPoseStack(poseStack).withPosition(new class_243((double)position.x, (double)position.y, (double)position.z)).withVertexBuffer(buffer).withLightColor(packedLight);
            for (MuzzleFlashEffect effect : this.gunClientState.getMuzzleFlashEffects()) {
                UUID effectId = EffectRegistry.getEffectId(effect.getName());
                if (!Objects.equal((Object)effectId, (Object)RenderPass.getEffectId())) continue;
                effect.render(context);
            }
        }
    }

    private void renderReticleWithParallax(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, float red, float green, float blue, double aimingProgress, float maxAngularOffsetCos) {
        if (bone == null) {
            return;
        }
        if (this.gunClientState == null) {
            return;
        }
        if (aimingProgress < 0.8) {
            return;
        }
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            float threshold;
            Vector4f n;
            Vector4f p0;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            Matrix4f modelMatrix = this.captureCubeMatrix(poseStack, cube, 3);
            Pair<Vector4f, Float> intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix, p0 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
            Vector4f intersectionPoint = (Vector4f)intersection.getFirst();
            if (intersectionPoint == null) {
                return;
            }
            float angularOffsetCos = ((Float)intersection.getSecond()).floatValue();
            float f = threshold = aimingProgress < 1.0 || this.gunClientState.isReloading() || this.gunClientState.isInspecting() ? DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED : maxAngularOffsetCos;
            if (angularOffsetCos > threshold) {
                poseStack.method_22903();
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.method_46416(class_3532.method_15363((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), class_3532.method_15363((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), class_3532.method_15363((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
                float alpha = (float)aimingProgress;
                RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
                poseStack.method_22909();
            }
        }
    }

    private void renderReticle(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, double aimingProgress) {
        if (this.gunClientState == null || this.gunClientState.isReloading() || this.gunClientState.isInspecting()) {
            return;
        }
        BakedGeoModel reticleBakedGeoModel = this.getReticleModel();
        GeoBone reticleBone = (GeoBone)reticleBakedGeoModel.getBone(BONE_SCOPE).get();
        if (reticleBone != null) {
            poseStack.method_22903();
            if (aimingProgress > 0.9 && !this.gunClientState.isReloading()) {
                float alpha = 0.7f;
                this.applyRefTransforms(poseStack, bone, reticleBone);
                double yaw = ClientEventHandler.reticleInertiaController.getYaw();
                double pitch = ClientEventHandler.reticleInertiaController.getPitch();
                Quaternionf q = new Quaternionf(pitch, yaw, 0.0, 1.0);
                poseStack.method_22904(-yaw * 25.0, pitch * 25.0, -8.0);
                poseStack.method_22907(q);
                super.renderCubesOfBone(poseStack, reticleBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
            poseStack.method_22909();
        }
    }

    private void renderPip(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, float red, float green, float blue, double aimingProgress) {
        List cubes;
        poseStack.method_22903();
        if (aimingProgress > 0.5 && this.gunClientState != null && (cubes = bone.getCubes()) != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            ClientSystem.getInstance().getAuxLevelRenderer().renderToBuffer(poseStack, northQuad, buffer, packedLight);
        }
        poseStack.method_22909();
    }

    private void renderPipOverlay(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, float red, float green, float blue, double aimingProgress, boolean isParallaxEnabled) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            Vector4f n;
            Vector4f p0;
            Matrix4f modelMatrix;
            Pair<Vector4f, Float> intersection;
            Vector4f intersectionPoint;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            if (isParallaxEnabled && (intersectionPoint = (Vector4f)(intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix = this.captureCubeMatrix(poseStack, cube, 3), p0 = new Vector4f(0.0f, 0.0f, 0.01f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f))).getFirst()) != null) {
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.method_46416(class_3532.method_15363((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), class_3532.method_15363((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), class_3532.method_15363((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
            }
            float alpha = (float)aimingProgress;
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void renderPipMask(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, float red, float green, float blue, double aimingProgress) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            float alpha = (float)aimingProgress;
            poseStack.method_22903();
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void renderLeftArm(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getLeftHandModel();
        GeoBone leftArmBone = handsBakedGeoModel.getBone(BONE_LEFTARM).orElse(null);
        if (leftArmBone != null) {
            poseStack.method_22903();
            this.applyArmRefTransforms(poseStack, bone, leftArmBone);
            super.renderCubesOfBone(poseStack, leftArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void renderRightArm(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getRightHandModel();
        GeoBone rightArmBone = handsBakedGeoModel.getBone(BONE_RIGHTARM).orElse(null);
        if (rightArmBone != null) {
            poseStack.method_22903();
            this.applyArmRefTransforms(poseStack, bone, rightArmBone);
            super.renderCubesOfBone(poseStack, rightArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void captureMuzzlePose(GeoBone refBone, class_4587 poseStack, class_811 itemDisplayContext) {
        if (this.gunClientState == null) {
            return;
        }
        poseStack.method_22903();
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        RenderUtils.translateToPivotPoint((class_4587)poseStack, (GeoCube)refCube);
        RenderUtils.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)refCube);
        RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)refCube);
        poseStack.method_46416(refBone.getPivotX() / 16.0f, refBone.getPivotY() / 16.0f, refBone.getPivotZ() / 16.0f);
        GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
        if (itemDisplayContext == class_811.field_4322) {
            GunStatePoseProvider.PoseContext poseContext = null;
            if (refBone.getName().equals(BONE_MUZZLE) || refBone.getName().equals(BONE_MUZZLE2)) {
                poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE;
            } else if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH;
            }
            if (poseContext != null) {
                gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.method_23760());
                this.setCurrentMuzzlePosition(poseStack, poseContext);
            }
        } else if (itemDisplayContext == class_811.field_4320) {
            GunStatePoseProvider.PoseContext poseContext = null;
            if (refBone.getName().equals(BONE_MUZZLE) || refBone.getName().equals(BONE_MUZZLE2)) {
                poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE;
            } else if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH;
            }
            if (poseContext != null) {
                gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.method_23760());
                this.setCurrentMuzzlePosition(poseStack, poseContext);
            }
        }
        poseStack.method_22909();
    }

    private void setCurrentMuzzlePosition(class_4587 poseStack, GunStatePoseProvider.PoseContext poseContext) {
        poseStack.method_22903();
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double fov = ((Integer)mc.field_1690.method_41808().method_41753()).doubleValue();
        Matrix4f fovProjectionMatrix = mc.field_1773.method_22973(fov);
        Matrix4f transform = new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).mul((Matrix4fc)fovProjectionMatrix.invert()).mul((Matrix4fc)RenderSystem.getProjectionMatrix()).mul((Matrix4fc)poseStack.method_23760().method_23761());
        Vector4f relPos = transform.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f pos = new Vector4f((Vector4fc)relPos);
        pos.add((float)cameraPos.field_1352, (float)cameraPos.field_1351, (float)cameraPos.field_1350, 1.0f);
        Vector4f direction = transform.transform(new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
        direction.sub((Vector4fc)relPos);
        direction.normalize();
        GunStatePoseProvider.getInstance().setPositionAndDirection(this.gunClientState, poseContext, new class_243((double)pos.x, (double)pos.y, (double)pos.z), new class_243((double)direction.x, (double)direction.y, (double)direction.z));
        poseStack.method_22909();
    }

    public void renderCubesOfBoneParent(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderCubesOfBoneParent(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean useCustomGlowingTexture, Set<class_2350> directions, Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier, float glowingProgress) {
        boolean hadCustomGlowingTexture = this.useCustomGlowingTexture;
        this.useCustomGlowingTexture = useCustomGlowingTexture;
        this.glowDirections = directions;
        this.glowingSpriteUVProviderSupplier = glowingSpriteUVProviderSupplier;
        this.glowingProgress = glowingProgress;
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.glowDirections = null;
        this.useCustomGlowingTexture = hadCustomGlowingTexture;
    }

    public void renderCube(class_4587 poseStack, GeoCube cube, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtils.translateToPivotPoint((class_4587)poseStack, (GeoCube)cube);
        RenderUtils.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)cube);
        RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = poseStack.method_23760().method_23761();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null || this.glowDirections != null && !this.glowDirections.contains(quad.direction())) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube((GeoCube)cube, (Vector3f)normal);
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private void applyArmRefTransforms(class_4587 poseStack, GeoBone refBone, GeoBone leftArmBone) {
        GeoCube leftArmBoneCube = (GeoCube)leftArmBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex leftArmBoneVertex = leftArmBoneCube.quads()[0].vertices()[0];
        GeoVertex refVertex = refCube.quads()[0].vertices()[0];
        float dx = refVertex.position().x() - leftArmBoneVertex.position().x();
        float dy = refVertex.position().y() - leftArmBoneVertex.position().y();
        float dz = refVertex.position().z() - leftArmBoneVertex.position().z();
        poseStack.method_46416(dx, dy, dz);
    }

    private void applyRefTransforms(class_4587 poseStack, GeoBone refBone, GeoBone actualBone) {
        GeoCube actualArmBoneCube = (GeoCube)actualBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex refQ0v0 = refCube.quads()[2].vertices()[0];
        GeoVertex refQ0v2 = refCube.quads()[2].vertices()[2];
        GeoVertex actualQ0v0 = actualArmBoneCube.quads()[2].vertices()[0];
        GeoVertex actualQ0v2 = actualArmBoneCube.quads()[2].vertices()[2];
        float refSizeX = Math.abs(refQ0v0.position().x - refQ0v2.position().x);
        float actualSizeX = Math.abs(actualQ0v0.position().x - actualQ0v2.position().x);
        float refSizeY = Math.abs(refQ0v0.position().y - refQ0v2.position().y);
        float actualSizeY = Math.abs(actualQ0v0.position().y - actualQ0v2.position().y);
        float refXLeft = refQ0v0.position().x;
        float refZLeft = refQ0v2.position().z;
        float actualXLeft = actualQ0v0.position().x;
        float actualYTop = actualQ0v0.position().y;
        float refYTop = refQ0v0.position().y;
        float actualZLeft = actualQ0v0.position().z;
        float dx = -(actualXLeft + (refXLeft - (refSizeX - actualSizeX) / 2.0f));
        float dy = refYTop + (actualSizeY - refSizeY) / 2.0f - actualYTop;
        float dz = refZLeft - actualZLeft;
        poseStack.method_46416(dx, dy, dz);
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String boneName, class_1799 rootStack, class_1799 currentStack, String path, class_811 itemDisplayContext) {
        List<Features.EnabledFeature> enabledVisibilityFeatures = Features.getEnabledFeatures(rootStack, PartVisibilityFeature.class);
        ConditionContext conditionContext = new ConditionContext(null, rootStack, currentStack, this.gunClientState, itemDisplayContext);
        for (Features.EnabledFeature enabledVisibilityFeature : enabledVisibilityFeatures) {
            PartVisibilityFeature visibilityFeature = (PartVisibilityFeature)enabledVisibilityFeature.feature();
            if (visibilityFeature.isPartVisible((class_1935)currentStack.method_7909(), boneName, conditionContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public class_1921 getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return true;
    }

    @Override
    public boolean canRenderPart(String boneName) {
        return !boneName.equals(BONE_LEFTARM) && !boneName.equals(BONE_RIGHTARM) && !boneName.equals(BONE_SCOPE) && !boneName.equals(BONE_RETICLE) && !boneName.equals(BONE_SCOPE_PIP);
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return null;
    }

    private static Pair<Vector4f, Float> getPlayerViewIntersection(Matrix4f modelMatrix, Vector4f p0, Vector4f n) {
        class_310 mc = class_310.method_1551();
        class_1657 player = ClientUtil.getClientPlayer();
        float partialTicks = mc.field_1728.field_1970;
        class_243 playerEyePositionRelativeToCamera = new class_243(0.0, 0.0, 0.0);
        class_243 playerViewVector = player.method_5828(partialTicks);
        Matrix4f transform3 = new Matrix4f((Matrix4fc)modelMatrix).invert().mul((Matrix4fc)new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).invert());
        double farDistance = 5.0;
        class_243 farPointWorld = playerEyePositionRelativeToCamera.method_1019(playerViewVector.method_1021(farDistance));
        Vector4f eyePositionModel = new Vector4f();
        transform3.transform((float)playerEyePositionRelativeToCamera.field_1352, (float)playerEyePositionRelativeToCamera.field_1351, (float)playerEyePositionRelativeToCamera.field_1350, 1.0f, eyePositionModel);
        Vector4f farPointModel = new Vector4f();
        transform3.transform((float)farPointWorld.field_1352, (float)farPointWorld.field_1351, (float)farPointWorld.field_1350, 1.0f, farPointModel);
        Vector4f l = new Vector4f((Vector4fc)farPointModel).sub((Vector4fc)eyePositionModel).normalize();
        Vector4f l0 = eyePositionModel;
        Vector4f p0MinusL0 = new Vector4f(p0.x, p0.y, p0.z, 1.0f).sub((Vector4fc)l0);
        float numerator = p0MinusL0.dot(n.x, n.y, n.z, 1.0f);
        float denominator = l.dot(n.x, n.y, n.z, 1.0f);
        Vector4f intersectionPoint = null;
        if (denominator > 0.0f) {
            float d = numerator / denominator;
            intersectionPoint = new Vector4f((Vector4fc)l).mul(d).add((Vector4fc)l0);
        }
        return Pair.of(intersectionPoint, (Object)Float.valueOf(denominator));
    }

    public Matrix4f captureCubeMatrix(class_4587 poseStack, GeoCube cube, int side) {
        GeoQuad quad = cube.quads()[side];
        poseStack.method_22903();
        RenderUtils.translateToPivotPoint((class_4587)poseStack, (GeoCube)cube);
        RenderUtils.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)cube);
        RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)cube);
        Vector3f v0Pos = quad.vertices()[0].position();
        Vector3f v2Pos = quad.vertices()[2].position();
        poseStack.method_46416((v0Pos.x + v2Pos.x) * 0.5f, (v0Pos.y + v2Pos.y) * 0.5f, (v0Pos.z + v2Pos.z) * 0.5f);
        Matrix4f cubeMatrix = poseStack.method_23760().method_23761();
        poseStack.method_22909();
        return cubeMatrix;
    }
}

