/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public class DefaultRenderTypeProvider
extends class_4668
implements RenderTypeProvider {
    private static DefaultRenderTypeProvider instance;
    private static Optional<class_5944> posTexColorShader;
    private static Optional<class_5944> auxShader;
    private Function<Boolean, class_1921> pipRenderTypes = class_156.method_34866(isMasked -> DefaultRenderTypeProvider.createPipRenderType(isMasked));
    private Function<class_2960, class_1921> pipOverlayRenderTypes = class_156.method_34866(texture -> DefaultRenderTypeProvider.createPipOverlayRenderType(texture, false));
    private Function<class_2960, class_1921> pipOverlayRenderTypesMasked = class_156.method_34866(texture -> DefaultRenderTypeProvider.createPipOverlayRenderType(texture, true));
    private Function<class_2960, class_1921> pipMaskRenderTypes = class_156.method_34866(texture -> DefaultRenderTypeProvider.createPipMaskRenderType(texture));
    private Function<class_2960, class_1921> muzzleFlashRenderTypes = class_156.method_34866(texture -> DefaultRenderTypeProvider.createMuzzleFlashRenderType(texture));
    private Function<class_2960, class_1921> reticleRenderTypes = class_156.method_34866(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture));
    private Function<class_2960, class_1921> reticleRenderTypesWithParallax = class_156.method_34866(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture, ClientSystem.getInstance()::getTexColorShaderInstance));
    private Function<class_2960, class_1921> glowEntityRenderTypes = class_156.method_34866(texture -> GlowEntityRenderType.createRenderType(texture));
    private static final PipTextureStateShard PIP_TEXTURE_STATE_SHARD;

    public static DefaultRenderTypeProvider getInstance() {
        if (instance == null) {
            instance = new DefaultRenderTypeProvider();
        }
        return instance;
    }

    public DefaultRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public class_1921 getPipRenderType(boolean isMasked) {
        return this.pipRenderTypes.apply(isMasked);
    }

    @Override
    public class_1921 getPipOverlayRenderType(class_2960 texture, boolean isMasked) {
        return isMasked ? this.pipOverlayRenderTypesMasked.apply(texture) : this.pipOverlayRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getPipMaskRenderType(class_2960 texture) {
        return this.pipMaskRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getGlowRenderType(class_2960 texture) {
        return class_1921.method_42599((class_2960)texture, (boolean)true);
    }

    @Override
    public class_1921 getMuzzleFlashRenderType(class_2960 texture) {
        return this.muzzleFlashRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getReticleRenderType(class_2960 texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getGlowBlockEntityRenderType(class_2960 texture) {
        if (IrisCompat.getInstance().isIrisLoaded()) {
            return class_1921.method_23580((class_2960)texture);
        }
        return this.glowEntityRenderTypes.apply(texture);
    }

    private static class_5944 getPosTexColorShader() {
        if (posTexColorShader != null) {
            return posTexColorShader.orElse(null);
        }
        String shaderName = "pointblank_position_tex_color";
        try {
            class_310 mc = class_310.method_1551();
            posTexColorShader = Optional.of(new class_5944((class_5912)mc.method_1478(), shaderName, class_290.field_1575));
        }
        catch (Exception e) {
            e.printStackTrace();
            posTexColorShader = Optional.empty();
        }
        return posTexColorShader.get();
    }

    private static class_5944 getAuxShader() {
        if (auxShader != null) {
            return auxShader.orElse(null);
        }
        String shaderName = "pointblank_aux";
        try {
            class_310 mc = class_310.method_1551();
            auxShader = Optional.of(new class_5944((class_5912)mc.method_1478(), shaderName, class_290.field_1575));
        }
        catch (Exception e) {
            e.printStackTrace();
            auxShader = Optional.empty();
        }
        return auxShader.get();
    }

    private static class_1921 createPipRenderType(boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.method_24049((String)"pointblank:pip", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(DefaultRenderTypeProvider::getAuxShader)).method_34577((class_4668.class_5939)PIP_TEXTURE_STATE_SHARD).method_23615(field_21364).method_23604(field_21348).method_23608(field_21384).method_23611(field_21386).method_23603(field_21345).method_23617(true)), setup, clear);
    }

    private static class_1921 createPipMaskRenderType(class_2960 maskTexture) {
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.class_4687.method_24049((String)"pointblank:pip_mask", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)0x200000, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(field_21364).method_34577((class_4668.class_5939)new class_4668.class_4683(maskTexture, false, false)).method_34578(new class_4668.class_5942(class_757::method_34543)).method_23617(false)), RenderTypeProvider.SETUP_STENCIL_MASK_RENDER, RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER);
    }

    private static class_1921 createPipOverlayRenderType(class_2960 overlayTexture, boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.method_24049((String)("pointblank:pip_overlay_" + isMasked), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21384).method_23611(field_21386).method_34577((class_4668.class_5939)new class_4668.class_4683(overlayTexture, false, false)).method_34578(new class_4668.class_5942(DefaultRenderTypeProvider::getPosTexColorShader)).method_23617(false)), setup, clear);
    }

    private static class_1921 createMuzzleFlashRenderType(class_2960 texture) {
        return class_1921.method_24049((String)"pointblank:muzzle_flash", (class_293)class_290.field_20887, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(field_21367).method_23603(field_21345).method_23604(field_21348).method_23608(field_21383).method_23611(field_21385).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_34578(new class_4668.class_5942(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).method_23617(false));
    }

    private static class_1921 createReticleRenderType(class_2960 texture, Supplier<class_5944> shaderSupplier) {
        return class_1921.method_24049((String)"pointblank:reticle_parallax", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21384).method_23611(field_21386).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_34578(new class_4668.class_5942(shaderSupplier::get)).method_23617(false));
    }

    private static class_1921 createReticleRenderType(class_2960 reticleResource) {
        return class_1921.method_24049((String)"pointblank:reticle", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21383).method_23611(field_21385).method_34577((class_4668.class_5939)new class_4668.class_4683(reticleResource, false, false)).method_34578(new class_4668.class_5942(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).method_23617(false));
    }

    static {
        PIP_TEXTURE_STATE_SHARD = new PipTextureStateShard();
    }

    private static class PipTextureStateShard
    extends class_4668.class_5939 {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().method_30277();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowEntityRenderType
    extends class_1921 {
        public GlowEntityRenderType(String renderTypeName, class_293 p_173179_, class_293.class_5596 p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static class_1921 createRenderType(class_2960 texture) {
            return class_1921.method_24049((String)"pointblank:glowy_entity_block", (class_293)class_290.field_20887, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(field_21367).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_34578(class_4668.field_29439).method_23617(false));
        }
    }
}

