/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.effect;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.PoseProvider;
import com.vicmatskiv.pointblank.client.PositionProvider;
import com.vicmatskiv.pointblank.client.effect.AttachedProjectileEffect;
import com.vicmatskiv.pointblank.client.effect.DetachedProjectileEffect;
import com.vicmatskiv.pointblank.client.effect.Effect;
import com.vicmatskiv.pointblank.client.effect.ImpactEffect;
import com.vicmatskiv.pointblank.client.effect.MuzzleFlashEffect;
import com.vicmatskiv.pointblank.client.effect.TrailEffect;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.JsonUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_4588;
import org.joml.Quaternionf;

public interface EffectBuilder<T extends EffectBuilder<T, E>, E extends Effect> {
    public Collection<GunItem.FirePhase> getCompatiblePhases();

    public static EffectBuilder<?, ?> fromZipEntry(ZipFile zipFile, ZipEntry entry, boolean isClientSide) {
        EffectBuilder<?, ?> effectBuilder;
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        try {
            effectBuilder = EffectBuilder.fromReader(reader, isClientSide);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return effectBuilder;
    }

    public static EffectBuilder<?, ?> fromPath(Path path, boolean isClientSide) {
        EffectBuilder<?, ?> effectBuilder;
        block8: {
            BufferedReader br = Files.newBufferedReader(path);
            try {
                effectBuilder = EffectBuilder.fromReader(br, isClientSide);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            br.close();
        }
        return effectBuilder;
    }

    public static EffectBuilder<?, ?> fromReader(Reader reader, boolean isClientSide) {
        try {
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String name = JsonUtil.getJsonString(obj, "name");
            EffectType effectType = JsonUtil.getEnum(obj, "type", EffectType.class, null, true);
            if (effectType == null) {
                throw new IllegalArgumentException("Missing effect 'type' in " + obj);
            }
            if (effectType == EffectType.DETACHED_PROJECTILE) {
                return ((DetachedProjectileEffect.Builder)new DetachedProjectileEffect.Builder().withName(name)).withJsonObject(obj);
            }
            if (effectType == EffectType.ATTACHED_PROJECTILE) {
                return ((AttachedProjectileEffect.Builder)new AttachedProjectileEffect.Builder().withName(name)).withJsonObject(obj);
            }
            if (effectType == EffectType.IMPACT) {
                return ((ImpactEffect.Builder)new ImpactEffect.Builder().withName(name)).withJsonObject(obj);
            }
            if (effectType == EffectType.MUZZLE_FLASH) {
                return ((MuzzleFlashEffect.Builder)new MuzzleFlashEffect.Builder().withName(name)).withJsonObject(obj);
            }
            if (effectType == EffectType.TRAIL) {
                return ((TrailEffect.Builder)new TrailEffect.Builder().withName(name)).withJsonObject(obj);
            }
            throw new IllegalArgumentException("Invalid effect type: " + effectType);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JSON: " + e.getMessage(), e);
        }
    }

    public boolean isEffectAttached();

    public T withJsonObject(JsonObject var1);

    public E build(Context var1);

    public String getName();

    public static enum EffectType {
        DETACHED_PROJECTILE,
        ATTACHED_PROJECTILE,
        IMPACT,
        MUZZLE_FLASH,
        TRAIL;

    }

    public static class EffectBuilderWrapper
    implements EffectBuilder<EffectBuilderWrapper, Effect> {
        private EffectBuilder<?, ?> delegate;
        private Supplier<EffectBuilder<?, ?>> supplier;
        private String name;

        public EffectBuilderWrapper(String name, Supplier<EffectBuilder<?, ?>> supplier) {
            this.name = name;
            this.supplier = supplier;
        }

        private EffectBuilder<?, ?> getOrCreate() {
            if (this.delegate == null) {
                this.delegate = this.supplier.get();
            }
            return this.delegate;
        }

        @Override
        public Collection<GunItem.FirePhase> getCompatiblePhases() {
            return this.getOrCreate().getCompatiblePhases();
        }

        @Override
        public boolean isEffectAttached() {
            return this.getOrCreate().isEffectAttached();
        }

        @Override
        public EffectBuilderWrapper withJsonObject(JsonObject obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Effect build(Context effectContext) {
            return this.getOrCreate().build(effectContext);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class Context {
        private GunClientState gunClientState;
        private class_243 startPosition;
        private class_243 targetPosition;
        private class_243 velocity;
        private Quaternionf rotation;
        private float distance;
        private float randomization;
        private PoseProvider poseProvider;
        private PositionProvider positionProvider;
        private Function<class_4588, class_4588> vertexConsumerTransformer;
        private class_239 hitResult;
        private float damage;

        public Context withGunState(GunClientState gunClientState) {
            this.gunClientState = gunClientState;
            return this;
        }

        public Context withStartPosition(class_243 startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public Context withVelocity(class_243 velocity) {
            this.velocity = velocity;
            return this;
        }

        public Context withRotation(Quaternionf rotation) {
            this.rotation = rotation;
            return this;
        }

        public Context withTargetPosition(class_243 targetPosition) {
            this.targetPosition = targetPosition;
            return this;
        }

        public Context withDistance(float distance) {
            this.distance = distance;
            return this;
        }

        public Context withRandomization(float randomization) {
            this.randomization = randomization;
            return this;
        }

        public Context withPoseProvider(PoseProvider poseProvider) {
            this.poseProvider = poseProvider;
            return this;
        }

        public Context withPositionProvider(PositionProvider positionProvider) {
            this.positionProvider = positionProvider;
            return this;
        }

        public Context withVertexConsumerTransformer(Function<class_4588, class_4588> vertexConsumerTransformer) {
            this.vertexConsumerTransformer = vertexConsumerTransformer;
            return this;
        }

        public Context withHitResult(class_239 hitResult) {
            this.hitResult = hitResult;
            this.updateEffectContextWithLocationAndRotation(hitResult);
            return this;
        }

        public Context withDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public float getDistance() {
            return this.distance;
        }

        public float getRandomization() {
            return this.randomization;
        }

        public class_243 getStartPosition() {
            return this.startPosition;
        }

        public class_243 getTargetPosition() {
            return this.targetPosition;
        }

        public class_243 getVelocity() {
            return this.velocity;
        }

        public PoseProvider getPoseProvider() {
            return this.poseProvider;
        }

        public PositionProvider getPositionProvider() {
            return this.positionProvider;
        }

        public Function<class_4588, class_4588> getVertexConsumerTransformer() {
            return this.vertexConsumerTransformer;
        }

        public class_239 getHitResult() {
            return this.hitResult;
        }

        public float getDamage() {
            return this.damage;
        }

        public Quaternionf getRotation() {
            return this.rotation;
        }

        public GunClientState getGunClientState() {
            return this.gunClientState;
        }

        private void updateEffectContextWithLocationAndRotation(class_239 hitResult) {
            if (hitResult instanceof SimpleHitResult) {
                SimpleHitResult simpleHitResult = (SimpleHitResult)hitResult;
                class_243 location = hitResult.method_17784();
                switch (hitResult.method_17783()) {
                    case field_1332: {
                        class_2350 direction = simpleHitResult.getDirection();
                        class_2382 normal = direction.method_10163();
                        this.withStartPosition(new class_243(location.field_1352 + (double)normal.method_10263() * 0.01, location.field_1351 + (double)normal.method_10264() * 0.01, location.field_1350 + (double)normal.method_10260() * 0.01));
                        this.withRotation(MiscUtil.getRotation(direction));
                        break;
                    }
                    case field_1331: {
                        class_243 shotOrigin = ClientUtil.getClientPlayer().method_33571();
                        class_243 offset = shotOrigin.method_1020(location).method_1029().method_18805(0.0, 0.1, 0.1);
                        double adjX = location.field_1352 + offset.field_1352;
                        double adjY = location.field_1351 + offset.field_1351;
                        double adjZ = location.field_1350 + offset.field_1350;
                        this.withStartPosition(new class_243(adjX, adjY, adjZ));
                        break;
                    }
                }
            }
        }
    }
}

