/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.controller;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateListener;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.feature.RecoilFeature;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_811;

public class GunRecoilAnimationController
extends AbstractProceduralAnimationController
implements GunStateListener {
    private double initialAmplitude;
    private double initialAmplitudeAdj;
    private double rateOfAmplitudeDecay;
    private double rateOfAmplitudeDecayAdj;
    private double initialAngularFrequency;
    private double initialAngularFrequencyAdj;
    private double rateOfFrequencyIncrease;
    private double rateOfFrequencyIncreaseAdj;
    private double pitchMultiplier;
    private int shotCount;
    private int shotsPerRecoil;
    private Random random = new Random();

    public GunRecoilAnimationController(double initialAmplitude, double rateOfAmplitudeDecay, double initialAngularFrequency, double rateOfFrequencyIncrease, double pitchMultiplier, long ticksPerTransition, int shotsPerRecoil) {
        super(ticksPerTransition);
        this.initialAmplitude = initialAmplitude;
        this.rateOfAmplitudeDecay = rateOfAmplitudeDecay;
        this.initialAngularFrequency = initialAngularFrequency;
        this.rateOfFrequencyIncrease = rateOfFrequencyIncrease;
        this.shotsPerRecoil = shotsPerRecoil;
        this.pitchMultiplier = pitchMultiplier;
        this.reset();
        this.isDone = true;
    }

    static double oscillatingFunction(double t, double a0, double alpha, double omega0, double beta) {
        double aT = a0 * Math.exp(-alpha * t);
        double omegaT = omega0 + beta * t;
        return aT * Math.sin(omegaT * t);
    }

    static double derivativeOscillatingFunction(double t, double a0, double alpha, double omega0, double beta) {
        double aT = a0 * Math.exp(-alpha * t);
        double dAT = -alpha * aT;
        double omega_t = omega0 + beta * t;
        double domega_t = beta;
        double sinTerm = Math.sin(omega_t * t);
        double cosTerm = Math.cos(omega_t * t);
        return dAT * sinTerm + aT * (domega_t * t + omega_t) * cosTerm;
    }

    @Override
    public void onRenderTick(class_1309 player, GunClientState gunClientState, class_1799 itemStack, class_811 itemDisplayContext, float partialTicks) {
        super.onRenderTick(player, gunClientState, itemStack, itemDisplayContext, partialTicks);
        if (!this.isDone) {
            double recoilPosZ;
            this.posZ = recoilPosZ = GunRecoilAnimationController.oscillatingFunction(this.progress * 10.0, this.initialAmplitudeAdj, this.rateOfAmplitudeDecayAdj, this.initialAngularFrequencyAdj, this.rateOfFrequencyIncreaseAdj);
            this.roll = recoilPosZ * 0.02;
            this.pitch = recoilPosZ * 0.05 * this.pitchMultiplier;
        }
    }

    @Override
    public void reset() {
        if (this.shotCount % this.shotsPerRecoil == 0) {
            double randomness = 0.1;
            this.initialAmplitudeAdj = this.initialAmplitude + (this.random.nextDouble() - 0.5) * this.initialAmplitude * randomness;
            this.rateOfAmplitudeDecayAdj = this.rateOfAmplitudeDecay + (this.random.nextDouble() - 0.5) * this.rateOfAmplitudeDecay * randomness;
            this.initialAngularFrequencyAdj = this.initialAngularFrequency + (this.random.nextDouble() - 0.5) * this.initialAngularFrequency * randomness;
            this.rateOfFrequencyIncreaseAdj = this.rateOfFrequencyIncrease + (this.random.nextDouble() - 0.5) * this.rateOfFrequencyIncrease * 0.01;
            super.reset();
        }
    }

    @Override
    public void onStartAutoFiring(class_1309 player, GunClientState gunClientState, class_1799 itemStack) {
        super.onStartAutoFiring(player, gunClientState, itemStack);
        this.shotCount = 0;
    }

    @Override
    public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.reset();
        ++this.shotCount;
        if (state.isAiming()) {
            this.initialAmplitudeAdj *= 0.5;
        }
        this.initialAmplitudeAdj *= (double)RecoilFeature.getRecoilModifier(itemStack);
    }
}

