/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class Selectors {
    private static Map<String, class_1814> rarities = new HashMap<String, class_1814>(){
        {
            this.put("common", class_1814.field_8906);
            this.put("uncommon", class_1814.field_8907);
            this.put("rare", class_1814.field_8903);
            this.put("epic", class_1814.field_8904);
        }
    };
    private static Map<String, BiPredicate<class_2520, String>> nbtComparators = new HashMap<String, BiPredicate<class_2520, String>>(){
        {
            this.put("=", (tag, value) -> tag.method_10714().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.method_10714().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() > parsedValue;
                    }
                    return false;
                }
                catch (Exception var4) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() < parsedValue;
                    }
                    return false;
                }
                catch (Exception var4) {
                    return false;
                }
            });
        }
    };

    public static boolean validateSelector(String value) {
        if (value.contains("+")) {
            for (String selector : value.split("\\+")) {
                if (Selectors.validateSelector(selector)) continue;
                return false;
            }
            return true;
        }
        if (value.startsWith("~")) {
            return Selectors.validateSelector(value.substring(1));
        }
        if (value.contentEquals("*")) {
            return true;
        }
        if (value.startsWith("$")) {
            return class_2960.method_20207((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return class_5251.method_27719((String)value) != null;
        }
        if (!value.startsWith("%") && !value.startsWith("^")) {
            if (value.startsWith("&")) {
                return true;
            }
            return value == null || value == "" || class_2960.method_20207((String)value);
        }
        return true;
    }

    public static boolean itemMatches(class_1799 item, String selector) {
        if (item.method_7960()) {
            return false;
        }
        if (selector.contains("+")) {
            for (String tooltipText : selector.split("\\+")) {
                if (Selectors.itemMatches(item, tooltipText)) continue;
                return false;
            }
            return true;
        }
        if (selector.startsWith("~")) {
            return !Selectors.itemMatches(item, selector.substring(1));
        }
        if (selector.contentEquals("*")) {
            return true;
        }
        String itemResourceLocation = class_7923.field_41178.method_10221((Object)item.method_7909()).toString();
        if (!selector.equals(itemResourceLocation) && !selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            if (selector.startsWith("@")) {
                if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                    return true;
                }
            } else if (selector.startsWith("#")) {
                class_5251 entryColor = class_5251.method_27719((String)selector);
                if (entryColor != null && entryColor.equals((Object)Selectors.getColorForItem(item, class_5251.method_27717((int)0xFFFFFF)))) {
                    return true;
                }
            } else if (selector.startsWith("!")) {
                if (item.method_7932() == rarities.get(selector.substring(1))) {
                    return true;
                }
            } else if (selector.startsWith("$")) {
                Optional<class_6862> matchingTag = class_7923.field_41178.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)new class_2960(selector.substring(1)))).findFirst();
                if (matchingTag.isPresent() && item.method_31573(matchingTag.get())) {
                    return true;
                }
            } else if (selector.startsWith("%")) {
                if (item.method_7954().getString().contains(selector.substring(1))) {
                    return true;
                }
            } else if (selector.startsWith("^")) {
                class_310 mc = class_310.method_1551();
                List lines = item.method_7950((class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_41071);
                Object tooltipText = "";
                for (int n = 1; n < lines.size(); ++n) {
                    tooltipText = (String)tooltipText + ((class_2561)lines.get(n)).getString() + "\n";
                }
                if (((String)tooltipText).contains(selector.substring(1))) {
                    return true;
                }
            } else if (selector.startsWith("&")) {
                String tagName = selector.substring(1);
                String tagValue = null;
                BiPredicate<class_2520, String> valueChecker = null;
                for (String comparator : nbtComparators.keySet()) {
                    if (!tagName.contains(comparator)) continue;
                    valueChecker = nbtComparators.get(comparator);
                    String[] components = tagName.split(comparator);
                    tagName = components[0];
                    if (components.length <= 1) break;
                    tagValue = components[1];
                    break;
                }
                return Selectors.findMatchingSubtag((class_2520)Selectors.getItemNBT(item), tagName, tagValue, valueChecker);
            }
            return false;
        }
        return true;
    }

    public static class_2487 getItemNBT(class_1799 item) {
        return item.method_7985() ? item.method_7969().method_10553() : null;
    }

    private static boolean findMatchingSubtag(class_2520 tag, String key, String value, BiPredicate<class_2520, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.method_10711() == 10) {
            String innerKey;
            class_2487 compoundTag = (class_2487)tag;
            if (compoundTag.method_10545(key)) {
                return value == null && valueChecker == null ? true : valueChecker.test(compoundTag.method_10580(key), value);
            }
            Iterator var5 = compoundTag.method_10541().iterator();
            do {
                if (var5.hasNext()) continue;
                return false;
            } while (compoundTag.method_10540(innerKey = (String)var5.next()) != 9 && compoundTag.method_10540(innerKey) != 10 || !Selectors.findMatchingSubtag(compoundTag.method_10580(innerKey), key, value, valueChecker));
            return true;
        }
        if (tag.method_10711() == 9) {
            class_2520 innerTag;
            class_2499 listTag = (class_2499)tag;
            Iterator var5 = listTag.iterator();
            do {
                if (var5.hasNext()) continue;
                return false;
            } while ((innerTag = (class_2520)var5.next()).method_10711() != 9 && innerTag.method_10711() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker));
            return true;
        }
        return false;
    }

    public static class_5251 findFirstColorCode(class_2561 textComponent) {
        String rawTitle = textComponent.getString();
        for (int i = 0; i < rawTitle.length(); i += 2) {
            if (rawTitle.charAt(i) != '\u00a7') {
                return null;
            }
            try {
                class_124 format = class_124.method_544((char)rawTitle.charAt(i + 1));
                if (format == null || !format.method_543()) continue;
                return class_5251.method_27718((class_124)format);
            }
            catch (StringIndexOutOfBoundsException var4) {
                return null;
            }
        }
        return null;
    }

    public static class_5251 getColorForItem(class_1799 item, class_5251 defaultColor) {
        class_5251 formattingColor;
        class_5251 result = null;
        result = item.method_7954().method_10866().method_10973();
        if (item.method_7909() != null && item.method_7909().method_7864(item) != null && item.method_7909().method_7864(item).method_10866() != null && item.method_7909().method_7864(item).method_10866().method_10973() != null) {
            result = item.method_7909().method_7864(item).method_10866().method_10973();
        }
        if (!item.method_7964().method_10866().method_10967() && item.method_7964().method_10866().method_10973() != null) {
            result = item.method_7964().method_10866().method_10973();
        }
        if ((formattingColor = Selectors.findFirstColorCode(item.method_7964())) != null) {
            result = formattingColor;
        }
        ColorCollector colorCollector = new ColorCollector();
        item.method_7964().method_30937().accept((class_5224)colorCollector);
        if (colorCollector.getColor() != null) {
            result = colorCollector.getColor();
        }
        if (result == null || result.equals((Object)item.method_7954().method_10866().method_10973())) {
            class_310 mc = class_310.method_1551();
            List lines = null;
            try {
                lines = item.method_7950((class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_41071);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lines != null && !lines.isEmpty()) {
                result = ((class_2561)lines.get(0)).method_10866().method_10973();
            }
        }
        if (result == null) {
            result = defaultColor;
        }
        return result;
    }

    private static class ColorCollector
    implements class_5224 {
        private class_5251 color = null;

        private ColorCollector() {
        }

        public boolean accept(int index, class_2583 style, int codePoint) {
            if (style.method_10973() != null) {
                this.color = style.method_10973();
                return false;
            }
            return true;
        }

        public class_5251 getColor() {
            return this.color;
        }
    }

    public record SelectorDocumentation(String name, String description, List<String> examples) {
        public SelectorDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

