/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.compat.iceberg.IcebergCompat;
import com.lootbeams.compat.legendarytooltips.LegendaryTooltipsCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.features.CustomRarity;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.helpers.TextHelper;
import com.lootbeams.helpers.ViewHelper;
import com.lootbeams.managers.TooltipManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_768;
import net.minecraft.class_8001;
import org.joml.Vector3f;

public class TooltipRenderer {
    public static void renderItemTooltip(class_332 context, class_327 font, class_1799 itemStack, int x, int y) {
        class_310 client = class_310.method_1551();
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        class_746 player = client.field_1724;
        class_327 textRenderer = client.field_1772;
        CustomRarity customRarity = CustomRarity.fromItemStack(itemStack);
        List<class_2561> tooltipLines = TooltipManager.getTooltipWithStackSize(itemStack);
        Optional tooltipData = itemStack.method_32347();
        class_2561 longestLine = TooltipManager.getTooltipLongestLine(itemStack, tooltipLines);
        int halfWidth = textRenderer.method_27525((class_5348)longestLine) / 2;
        boolean alwaysRenderRarityOnItem = RarityHelper.alwaysHasRarity(itemStack);
        boolean legendaryTooltipsLoaded = LegendaryTooltipsCompat.isLegendaryTooltipsLoaded();
        x -= 12;
        if (!itemConfig.screenTooltipsRequireCrouch || player.method_18276()) {
            TooltipManager.OffsetContainer tooltipOffset = TooltipRenderer.alignTooltipHorizontal(itemStack, tooltipLines, tooltipData, context, x, y, textRenderer, halfWidth);
            context.method_51437(textRenderer, tooltipLines, tooltipData, x -= tooltipOffset.getOffset(), y);
        } else {
            String rarity = RarityHelper.getRarity(itemStack);
            class_2583 textStyle = itemStack.method_7954().method_10866();
            class_2561 t1 = tooltipLines.get(0);
            class_5250 t2 = null;
            tooltipLines = List.of(t1);
            if (itemConfig.renderItemRarity || alwaysRenderRarityOnItem) {
                t2 = class_2561.method_43470((String)rarity).method_10862(textStyle);
                tooltipLines = List.of(t1, t2);
            }
            TooltipManager.OffsetContainer tooltipOffset = TooltipRenderer.alignTooltipHorizontal(itemStack, tooltipLines, tooltipData, context, x, y, textRenderer, halfWidth);
            halfWidth = tooltipOffset.getHalfTooltipWidth();
            if ((itemConfig.renderItemRarity || alwaysRenderRarityOnItem) && t2 != null) {
                if (customRarity != null) {
                    t2 = CustomRarity.toText(customRarity);
                    tooltipLines = List.of(t1, t2);
                }
                if (legendaryTooltipsLoaded && textRenderer.method_27525((class_5348)t2) < halfWidth * 2) {
                    tooltipLines = List.of(t1, TextHelper.centeredLine((class_2561)t2, textRenderer, halfWidth * 2));
                }
            }
            tooltipOffset = TooltipRenderer.alignTooltipHorizontal(itemStack, tooltipLines, tooltipData, context, x, y, textRenderer, halfWidth);
            halfWidth = tooltipOffset.getHalfTooltipWidth();
            x -= tooltipOffset.getOffset();
            if (!itemConfig.renderItemRarity && !alwaysRenderRarityOnItem || itemConfig.combineNameAndRarity || legendaryTooltipsLoaded) {
                context.method_51437(textRenderer, tooltipLines, tooltipData, x, y);
            } else {
                int rarityLineHalfWidth = textRenderer.method_1727(rarity) / 2;
                context.method_51437(textRenderer, List.of(tooltipLines.get(0)), tooltipData, x, y);
                List<class_2561> list = List.of(tooltipLines.get(1));
                Objects.requireNonNull(textRenderer);
                context.method_51437(textRenderer, list, tooltipData, x + halfWidth - rarityLineHalfWidth, y + 9 * 2);
            }
        }
    }

    public static void renderWorldPositionTooltip(class_332 drawContext, class_1297 entity, class_1799 itemStack, float tickDelta) {
        if (itemStack != null && !itemStack.method_7960()) {
            if (!TooltipManager.canRenderTooltips(itemStack)) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
            int windowScaledWidth = drawContext.method_51421();
            int windowScaledHeight = drawContext.method_51443();
            int x = windowScaledWidth / 2;
            int y = windowScaledHeight / 2;
            class_327 textRenderer = client.field_1772;
            List<class_2561> tooltipLines = TooltipManager.getTooltipWithStackSize(itemStack);
            if (itemConfig.worldspaceTooltips) {
                class_243 tooltipShiftedPosition = new class_243(0.0, Math.min(1.0, player.method_5858(entity) * 0.025) + (double)itemConfig.nametagYOffset + (double)((float)tooltipLines.size() / 100.0f), 0.0);
                class_243 tooltipWorldPos = entity.method_19538().method_1019(tooltipShiftedPosition);
                Vector3f desiredScreenSpacePos = ViewHelper.worldToScreenSpace(tooltipWorldPos, tickDelta);
                float f = class_3532.method_15363((float)desiredScreenSpacePos.x(), (float)0.0f, (float)windowScaledWidth);
                float f2 = desiredScreenSpacePos.y();
                Objects.requireNonNull(textRenderer);
                desiredScreenSpacePos = new Vector3f(f, class_3532.method_15363((float)f2, (float)0.0f, (float)(windowScaledHeight - 9 * tooltipLines.size())), desiredScreenSpacePos.z());
                x = (int)desiredScreenSpacePos.x();
                y = (int)desiredScreenSpacePos.y();
            }
            int guiScale = (Integer)client.field_1690.method_42474().method_41753();
            drawContext.method_51446(textRenderer, itemStack, x, y);
            client.field_1690.method_42474().method_41748((Object)guiScale);
        }
    }

    private static TooltipManager.OffsetContainer alignTooltipHorizontal(class_1799 itemStack, List<class_2561> tooltipLines, Optional<class_5632> tooltipData, class_332 context, int x, int y, class_327 textRenderer, int halfWidth) {
        boolean legendaryTooltipsLoaded = LegendaryTooltipsCompat.isLegendaryTooltipsLoaded();
        if (legendaryTooltipsLoaded) {
            List<class_5684> tooltipComponents = IcebergCompat.getTooltipComponents(itemStack, tooltipLines, tooltipData, x, context.method_51421(), context.method_51443(), null, textRenderer, context.method_51421());
            class_768 tooltipRect = IcebergCompat.getTooltipRect(itemStack, context, class_8001.field_41687, tooltipComponents, x, y, context.method_51421(), context.method_51443(), context.method_51421(), textRenderer, 0, true);
            int halfTooltipWidth = tooltipRect.method_3319() / 2;
            int offset = halfTooltipWidth - 1;
            return new TooltipManager.OffsetContainer(offset, halfTooltipWidth);
        }
        return new TooltipManager.OffsetContainer(halfWidth, halfWidth);
    }
}

