/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.LootBeams;
import com.lootbeams.config.Configuration;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.helpers.TargetHelper;
import com.lootbeams.helpers.TextColorHelper;
import com.lootbeams.managers.TooltipManager;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3544;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import org.joml.Quaternionf;

public class NameTagRenderer {
    public static void renderNameTags(class_4597.class_4598 buffer, class_4587 matrixStack, class_1542 itemEntity, Configuration itemConfig, class_5251 color, float fadeAlpha, float currentGroundTime, long worldtime, float pticks) {
        if (!itemConfig.renderNametags) {
            return;
        }
        if (itemConfig.advancedTooltips) {
            return;
        }
        if (class_310.method_1551().field_1724.method_18276() || itemConfig.renderNametagsOnlook && TargetHelper.isLookingAt((class_1657)class_310.method_1551().field_1724, (class_1297)itemEntity, itemConfig.nametagLookSensitivity)) {
            int count;
            class_1799 itemStack = itemEntity.method_6983();
            float foregroundAlpha = itemConfig.nametagTextAlpha;
            float backgroundAlpha = itemConfig.nametagBackgroundAlpha;
            double yOffset = itemConfig.nametagYOffset;
            int foregroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
            int backgroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, Math.min(1.0, class_310.method_1551().field_1724.method_5858((class_1297)itemEntity) * 0.025) + yOffset, 0.0);
            Quaternionf entityRotationQuaternion = class_310.method_1551().method_1561().method_24197();
            matrixStack.method_22907(entityRotationQuaternion);
            float nametagScale = itemConfig.nametagScale;
            float nametagScaleCompensation = 0.5f;
            matrixStack.method_22905(-0.02f * nametagScale * nametagScaleCompensation, -0.02f * nametagScale * nametagScaleCompensation, 0.02f * nametagScale * nametagScaleCompensation);
            class_327 fontrenderer = class_310.method_1551().field_1772;
            Object itemName = class_3544.method_15440((String)itemStack.method_7964().getString());
            if (itemConfig.renderStackcount && (count = itemStack.method_7947()) > 1) {
                itemName = (String)itemName + " x" + count;
            }
            matrixStack.method_46416(0.0f, 0.0f, -10.0f);
            NameTagRenderer.renderText(itemStack, itemConfig, fontrenderer, matrixStack, (class_4597)buffer, (String)itemName, foregroundColor, backgroundColor, backgroundAlpha);
            buffer.method_22993();
            boolean alwaysRenderRarityOnItem = RarityHelper.alwaysHasRarity(itemStack);
            if (itemConfig.renderItemRarity || alwaysRenderRarityOnItem) {
                NameTagRenderer.renderRarity(itemStack, itemConfig, foregroundAlpha, backgroundAlpha, fontrenderer, matrixStack, (class_4597)buffer, alwaysRenderRarityOnItem);
                buffer.method_22993();
            }
            matrixStack.method_22909();
        }
    }

    private static void renderText(class_1799 itemStack, Configuration itemConfig, class_327 fontRenderer, class_4587 stack, class_4597 buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (itemConfig.borders) {
            float w = (float)(-fontRenderer.method_1727(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            class_2561 orderedText = class_2561.method_30163((String)text);
            fontRenderer.method_37296(orderedText.method_30937(), w, 0.0f, foregroundColor, bg, stack.method_23760().method_23761(), buffer, 0xF000F0);
        } else {
            fontRenderer.method_27521(text, (float)((double)(-fontRenderer.method_1727(text)) / 2.0), 0.0f, foregroundColor, false, stack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, backgroundColor, 0xF000E0);
        }
    }

    private static void renderRarity(class_1799 itemStack, Configuration itemConfig, float foregroundAlpha, float backgroundAlpha, class_327 fontRenderer, class_4587 stack, class_4597 buffer, boolean alwaysRenderRarityOnItem) {
        class_2561 tooltipRarity;
        String rarityString;
        stack.method_22904(0.0, 10.0, 0.0);
        stack.method_22905(0.75f, 0.75f, 0.75f);
        List<class_2561> tooltip = TooltipManager.getTooltipFromCache(itemStack);
        if (tooltip.isEmpty()) {
            return;
        }
        if (tooltip.size() > 1 && (itemConfig.customRarities.contains(rarityString = (tooltipRarity = tooltip.get(1)).getString()) || alwaysRenderRarityOnItem)) {
            class_5251 rarityColor = LootBeams.config.whiteRarities ? class_5251.method_27718((class_124)class_124.field_1068) : TextColorHelper.getRawColor(tooltipRarity);
            int foregroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
            int backgroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
            NameTagRenderer.renderText(itemStack, itemConfig, fontRenderer, stack, buffer, rarityString, foregroundColor, backgroundColor, backgroundAlpha);
            return;
        }
        if (itemConfig.vanillaRarities || alwaysRenderRarityOnItem) {
            String rarity = RarityHelper.getRarity(itemStack);
            class_5251 rarityColor = LootBeams.config.whiteRarities ? class_5251.method_27718((class_124)class_124.field_1068) : TextColorHelper.getItemColor(itemStack);
            float R = (float)(rarityColor.method_27716() >> 16 & 0xFF) / 255.0f;
            float G = (float)(rarityColor.method_27716() >> 8 & 0xFF) / 255.0f;
            float B = (float)(rarityColor.method_27716() & 0xFF) / 255.0f;
            int foregroundColor = new Color(R, G, B, (float)((int)foregroundAlpha)).getRGB();
            int backgroundColor = new Color(R, G, B, (float)((int)backgroundAlpha)).getRGB();
            NameTagRenderer.renderText(itemStack, itemConfig, fontRenderer, stack, buffer, rarity, foregroundColor, backgroundColor, backgroundAlpha);
        }
    }
}

