/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.LootBeams;
import com.lootbeams.config.Configuration;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.render.LootBeamRenderLayers;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5251;
import net.minecraft.class_7833;
import org.joml.Matrix3f;

public class LootBeamRenderer {
    private static final class_2960 LOOT_BEAM_TEXTURE = LootBeams.id("textures/lootbeam/lootbeam.png");
    private static final class_2960 LOOT_BEAM_WHITE_TEXTURE = LootBeams.id("textures/lootbeam/lootbeam_white.png");
    private static final class_1921 LOOT_BEAM_CENTER_LAYER = LootBeamRenderLayers.lootBeamCenter();
    private static class_1921 LOOT_BEAM_LAYER = LootBeamRenderer.updateLootBeamLayer();

    private static class_1921 updateLootBeamLayer() {
        class_2960 beamTexture = !LootBeams.config.solidBeam ? LOOT_BEAM_TEXTURE : LOOT_BEAM_WHITE_TEXTURE;
        return LootBeams.config.glowingBeam ? LootBeamRenderLayers.lootBeamLightning() : LootBeamRenderLayers.lootBeam(beamTexture);
    }

    public static void onConfigurationChange() {
        LOOT_BEAM_LAYER = LootBeamRenderer.updateLootBeamLayer();
    }

    public static void renderBeam(class_4597.class_4598 buffer, class_4587 matrixStack, class_1542 itemEntity, Configuration itemConfig, class_5251 color, float beamSizeMultiplier, float fadeAlpha, float currentGroundTime, long worldtime, float pticks) {
        float minBeamRadius;
        float beamRadius;
        if (!itemConfig.renderBeam) {
            return;
        }
        ColorHelper.Color beamColor = ColorHelper.Color.of(color);
        ColorHelper.Color centerColor = ColorHelper.Color.of(color).applyModifiers(List.of("+r64", "+g64", "+b64"));
        float beamAlpha = itemConfig.beamAlpha * fadeAlpha;
        float glowBeamAlpha = beamAlpha * 0.4f;
        float beamHeight = itemConfig.beamHeight * beamSizeMultiplier;
        if (beamHeight < itemConfig.minBeamHeight) {
            beamHeight = itemConfig.minBeamHeight;
        }
        if ((beamRadius = 0.05f * itemConfig.beamRadius * beamSizeMultiplier) < (minBeamRadius = 0.05f * itemConfig.minBeamRadius)) {
            beamRadius = minBeamRadius;
        }
        float beamGlowRadius = beamRadius + beamRadius * 0.2f;
        float yOffset = itemConfig.beamYOffset;
        if (itemConfig.commonShorterBeam && !RarityHelper.rarityCheck(itemEntity.method_6983(), false)) {
            beamHeight *= 0.65f;
        }
        if (itemConfig.smoothBeamSize) {
            beamHeight = NumberHelper.smoothValue(beamHeight, currentGroundTime, itemConfig.smoothDuration);
            yOffset = NumberHelper.smoothValue(yOffset, currentGroundTime, itemConfig.smoothDuration);
            beamRadius = NumberHelper.smoothValue(beamRadius, currentGroundTime, itemConfig.smoothDuration);
            beamGlowRadius = NumberHelper.smoothValue(beamGlowRadius, currentGroundTime, itemConfig.smoothDuration);
        }
        matrixStack.method_22903();
        float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        LootBeamRenderer.renderBeamLayer(matrixStack, buffer.getBuffer(LOOT_BEAM_LAYER), beamColor, beamAlpha, 0.0f, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, itemConfig.solidBeam, yOffset);
        matrixStack.method_22909();
        LootBeamRenderer.renderBeamLayer(matrixStack, buffer.getBuffer(LOOT_BEAM_LAYER), beamColor, glowBeamAlpha, 0.0f, beamHeight, -beamGlowRadius, -beamGlowRadius, beamGlowRadius, -beamGlowRadius, -beamGlowRadius, beamGlowRadius, beamGlowRadius, beamGlowRadius, itemConfig.solidBeam, yOffset);
        buffer.method_22993();
        if (itemConfig.whiteCenter) {
            LootBeamRenderer.renderBeamLayer(matrixStack, buffer.getBuffer(LOOT_BEAM_CENTER_LAYER), centerColor, beamAlpha, 0.0f, beamHeight, 0.0f, beamRadius * 0.4f, beamRadius * 0.4f, 0.0f, -beamRadius * 0.4f, 0.0f, 0.0f, -beamRadius * 0.4f, itemConfig.solidBeam, yOffset);
            buffer.method_22993();
        }
    }

    private static void renderBeamLayer(class_4587 stack, class_4588 builder, ColorHelper.Color color, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8, boolean solidBeam, float yOffset) {
        float halfHeight = height / 2.0f;
        stack.method_22903();
        stack.method_46416(0.0f, yOffset, 0.0f);
        if (!solidBeam) {
            stack.method_46416(0.0f, halfHeight, 0.0f);
            stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        }
        LootBeamRenderer.renderPart(stack, builder, color.fR, color.fG, color.fB, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8, false);
        if (!solidBeam) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        }
        LootBeamRenderer.renderPart(stack, builder, color.fR, color.fG, color.fB, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8, solidBeam);
        stack.method_22909();
    }

    private static void renderPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8, boolean gradient) {
        if (gradient) {
            LootBeamRenderer.renderGradientPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        } else {
            LootBeamRenderer.renderPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        }
    }

    private static void renderPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix3f matrixnormal = matrixentry.method_23762();
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderGradientPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix3f matrixnormal = matrixentry.method_23762();
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(class_4587.class_4665 stack, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float x1, float z1, float x0, float z0) {
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, x1, z1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y, x1, z1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y, x0, z0, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, x0, z0, 0.0f, 0.0f);
    }

    private static void renderUpwardsGradientQuad(class_4587.class_4665 stack, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, 0.0f, y + height, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, 0.0f, y + height, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(class_4588 builder, class_4587.class_4665 stack, Matrix3f normal, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.method_22918(stack.method_23761(), x, y, z).method_22915(red, green, blue, alpha).method_22913(texu, texv).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
    }
}

