/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.LootBeams;
import com.lootbeams.compat.iris.IrisCompat;
import com.lootbeams.compat.prism.PrismCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.extensions.LootbeamsBufferBuilder;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.render.LootBeamRenderLayers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5251;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class DroplightRenderer {
    private static final class_2960 DROPLIGHT_TEXTURE = LootBeams.id("textures/droplight/droplight.png");
    private static final class_2960 DROPLIGHT_GLOW_TEXTURE = LootBeams.id("textures/droplight/droplight_glow.png");
    private static final class_2960 DROPLIGHT_ANIMATED_TEXTURE = LootBeams.id("textures/droplight/droplight_animated.png");
    private static final class_2960 DROPLIGHT_ANIMATED_BASE_TEXTURE = LootBeams.id("textures/droplight/droplight_animated_base.png");
    private static class_1921 DROPLIGHT_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_TEXTURE);
    private static class_1921 DROPLIGHT_GLOW_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_GLOW_TEXTURE);
    private static class_1921 DROPLIGHT_ANIMATED_LAYER = LootBeamRenderLayers.droplightAnimated(DROPLIGHT_ANIMATED_TEXTURE);
    private static class_1921 DROPLIGHT_BASE_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_ANIMATED_BASE_TEXTURE);
    private static boolean SHADERS_LOADED = IrisCompat.isShaderPackInUse();

    public static void renderBeam(class_4597.class_4598 buffer, class_4587 matrixStack, class_1542 itemEntity, Configuration itemConfig, class_5251 color, float beamSizeMultiplier, float fadeAlpha, float currentGroundTime, long worldtime, float pticks) {
        float beamWidth;
        if (!itemConfig.renderBeam) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_4184 camera = minecraft.field_1773.method_19418();
        boolean updatedShadersLoaded = IrisCompat.isShaderPackInUse();
        if (updatedShadersLoaded != SHADERS_LOADED) {
            SHADERS_LOADED = updatedShadersLoaded;
            DROPLIGHT_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_TEXTURE);
            DROPLIGHT_GLOW_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_GLOW_TEXTURE);
            DROPLIGHT_ANIMATED_LAYER = LootBeamRenderLayers.droplightAnimated(DROPLIGHT_ANIMATED_TEXTURE);
            DROPLIGHT_BASE_LAYER = LootBeamRenderLayers.droplight(DROPLIGHT_ANIMATED_BASE_TEXTURE);
        }
        float beamAlpha = itemConfig.beamAlpha * fadeAlpha;
        float beamHeight = itemConfig.beamHeight * beamSizeMultiplier;
        float beamGlowHeight = 2.5f * beamSizeMultiplier;
        if (beamHeight < itemConfig.minBeamHeight) {
            beamHeight = itemConfig.minBeamHeight;
            beamAlpha = beamHeight * 0.2f;
        }
        if ((beamWidth = itemConfig.beamRadius * beamSizeMultiplier) < itemConfig.minBeamRadius) {
            beamWidth = itemConfig.minBeamRadius;
        }
        float yOffset = itemConfig.beamYOffset;
        if (itemConfig.commonShorterBeam && !RarityHelper.rarityCheck(itemEntity.method_6983(), false)) {
            beamHeight *= 0.65f;
        }
        if (itemConfig.smoothBeamSize) {
            beamHeight = NumberHelper.smoothValue(beamHeight, currentGroundTime, itemConfig.smoothDuration);
            beamWidth = NumberHelper.smoothValue(beamWidth, currentGroundTime, itemConfig.smoothDuration);
            yOffset = NumberHelper.smoothValue(yOffset, currentGroundTime, itemConfig.smoothDuration);
        }
        class_5251 color2 = DroplightRenderer.getSecondColor(color, itemConfig.beamGradientModifiers);
        RenderSystem.setShaderTexture((int)1, (int)minecraft.method_1522().method_30278());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)beamAlpha);
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.015, 0.0);
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        class_4588 builder = buffer.getBuffer(DROPLIGHT_GLOW_LAYER);
        DroplightRenderer.renderQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), SHADERS_LOADED ? beamAlpha / 2.0f : beamAlpha, 0.0f, yOffset, -0.001f, beamWidth, beamGlowHeight, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, true, SHADERS_LOADED);
        buffer.method_22993();
        if (beamHeight > 0.0f) {
            if (itemConfig.animateDroplightBeam && !SHADERS_LOADED) {
                float halfBeamWidth = beamWidth / 2.0f;
                float oneThreeBeamWidth = beamWidth / 3.0f;
                float animationSpeed = itemConfig.droplightBeamAnimationSpeed;
                float itemAgeInSeconds = ((float)itemEntity.method_6985() + pticks) / 20.0f;
                builder = buffer.getBuffer(DROPLIGHT_ANIMATED_LAYER);
                DroplightRenderer.renderAnimatedQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), beamAlpha, 0.0f, halfBeamWidth - oneThreeBeamWidth + yOffset, 0.0f, beamWidth, beamHeight, 0.0f, 0.0f, 1.0f, 1.0f, true, animationSpeed, itemAgeInSeconds);
                buffer.method_22993();
                builder = buffer.getBuffer(DROPLIGHT_BASE_LAYER);
                DroplightRenderer.renderQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), beamAlpha, 0.0f, -oneThreeBeamWidth + yOffset, 0.0f, beamWidth, beamWidth, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, false, SHADERS_LOADED);
                buffer.method_22993();
            } else {
                builder = buffer.getBuffer(DROPLIGHT_LAYER);
                DroplightRenderer.renderQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), beamAlpha, 0.0f, yOffset, 0.0f, beamWidth, beamHeight, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, true, SHADERS_LOADED);
                buffer.method_22993();
            }
        }
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static class_5251 getSecondColor(float r, float g, float b, float a, List<String> modifiers) {
        int R = (int)(r * 255.0f);
        int G = (int)(g * 255.0f);
        int B = (int)(b * 255.0f);
        int A = (int)(a * 255.0f);
        return DroplightRenderer.getSecondColor(class_5251.method_27717((int)ColorHelper.build(A, R, G, B)), modifiers);
    }

    public static class_5251 getSecondColor(class_5251 color, List<String> modifiers) {
        if (PrismCompat.isPrismLoaded()) {
            return PrismCompat.applyModifiers(modifiers, color);
        }
        ColorHelper.Color newColor = new ColorHelper.Color(color.method_27716()).applyModifiers(modifiers);
        return class_5251.method_27717((int)(newColor.getRgb() & 0xFFFFFF));
    }

    private static class_4588 modifyVertex(class_4588 builder, float data0, float data1, float data2, float data3) {
        ((LootbeamsBufferBuilder)builder).longCustomData(data0, data1, data2, data3);
        return builder;
    }

    private static void renderQuad(class_4588 builder, class_4587 matrixStack, int color, int color2, float alpha, float x, float y, float z, float w, float h, float u, float v, float u2, float v2, float alphaMultiplier, boolean fade, boolean shadersLoaded) {
        class_4587.class_4665 stack = matrixStack.method_23760();
        Matrix4f positionMatrix = stack.method_23761();
        Matrix3f normal = stack.method_23762();
        float alpha2 = fade ? 0.0f : alpha;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 >> 0 & 0xFF) / 255.0f;
        if (shadersLoaded) {
            builder.method_22918(positionMatrix, x - w / 2.0f, y, z).method_22913(u, v2).method_22915(red, green, blue, alpha).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            builder.method_22918(positionMatrix, x + w / 2.0f, y, z).method_22913(u2, v2).method_22915(red, green, blue, alpha).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            builder.method_22918(positionMatrix, x + w / 2.0f, y + h, z).method_22913(u2, v).method_22915(red, green, blue, alpha2).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            builder.method_22918(positionMatrix, x - w / 2.0f, y + h, z).method_22913(u, v).method_22915(red, green, blue, alpha2).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            return;
        }
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x - w / 2.0f, y, z).method_22913(u, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha), alphaMultiplier, 0.0f, 0.0f, 0.0f).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x + w / 2.0f, y, z).method_22913(u2, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha), alphaMultiplier, 0.0f, 0.0f, 0.0f).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x + w / 2.0f, y + h, z).method_22913(u2, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2), alphaMultiplier, 0.0f, 0.0f, 0.0f).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x - w / 2.0f, y + h, z).method_22913(u, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2), alphaMultiplier, 0.0f, 0.0f, 0.0f).method_1344();
    }

    private static void renderAnimatedQuad(class_4588 builder, class_4587 matrixStack, int color, int color2, float alpha, float x, float y, float z, float w, float h, float u, float v, float u2, float v2, boolean fade, float animationSpeed, float itemAge) {
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        float alpha2 = fade ? 0.0f : alpha;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 >> 0 & 0xFF) / 255.0f;
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x - w / 2.0f, y, z).method_22913(u, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha), w, h, animationSpeed, itemAge).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x + w / 2.0f, y, z).method_22913(u2, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha), w, h, animationSpeed, itemAge).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x + w / 2.0f, y + h, z).method_22913(u2, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2), w, h, animationSpeed, itemAge).method_1344();
        DroplightRenderer.modifyVertex(builder.method_22918(positionMatrix, x - w / 2.0f, y + h, z).method_22913(u, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2), w, h, animationSpeed, itemAge).method_1344();
    }
}

