/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.mixin;

import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.helpers.TextColorHelper;
import com.lootbeams.managers.ItemEntityManager;
import com.lootbeams.managers.RenderManager;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_918.class})
public class ItemRendererMixin {
    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderItem(class_1799 itemStack, class_811 transformationMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model, CallbackInfo ci) {
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        if (!itemConfig.itemsGlow) {
            return;
        }
        class_1542 itemEntity = ItemEntityManager.getEntityForStack(itemStack);
        if (RenderManager.isRendering(itemEntity)) {
            return;
        }
        RenderManager.setRendering(itemEntity, true);
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_918 itemRenderer = client.method_1480();
        if (itemEntity != null && itemConfig.itemsGlow) {
            class_3965 hitResult = client.field_1687.method_17742(new class_3959(player.method_5836(1.0f), itemEntity.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            if (itemStack.method_7960() || hitResult.method_17783() == class_239.class_240.field_1332 || player.method_5858((class_1297)itemEntity) > (double)itemConfig.renderDistance) {
                itemRenderer.method_23179(itemStack, transformationMode, leftHanded, matrices, vertexConsumers, light, overlay, model);
            } else {
                class_4618 outlineProvider = client.method_22940().method_23003();
                class_5251 textColor = TextColorHelper.getItemColor(itemStack);
                if (textColor != null) {
                    int color = textColor.method_27716();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    outlineProvider.method_23286(r, g, b, 255);
                }
                itemRenderer.method_23179(itemStack, transformationMode, leftHanded, matrices, (class_4597)outlineProvider, light, overlay, model);
                RenderManager.addOnRenderEnd(this.getClass(), ctx -> {
                    if (itemConfig.itemsGlow) {
                        class_310.method_1551().field_1769.field_20951.method_23003().method_23285();
                        if (class_310.method_1551().field_1769.field_4059 != null) {
                            class_310.method_1551().field_1769.field_4059.method_1258((float)class_310.method_1551().method_47600());
                        }
                        class_310.method_1551().method_1522().method_1235(false);
                    }
                });
            }
            RenderManager.setRendering(itemEntity, false);
            ci.cancel();
        }
    }
}

