/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.managers;

import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class TooltipManager {
    public static final Map<class_1799, List<class_2561>> TOOLTIP_CACHE = new ConcurrentHashMap<class_1799, List<class_2561>>();

    public static void onResourcesReload() {
        TOOLTIP_CACHE.clear();
    }

    public static void onEntityLoad(class_1542 item, class_638 world) {
        class_1799 itemStack = item.method_6983();
        if (!TOOLTIP_CACHE.containsKey(itemStack)) {
            TOOLTIP_CACHE.put(itemStack, TooltipManager.getItemStackTooltip(item.method_6983()));
        }
    }

    public static void onEntityUnload(class_1542 item, class_638 world) {
        TOOLTIP_CACHE.remove(item.method_6983());
    }

    public static List<class_2561> getTooltipFromCache(class_1799 itemStack) {
        if (!TOOLTIP_CACHE.containsKey(itemStack)) {
            List<class_2561> tooltip = TooltipManager.getItemStackTooltip(itemStack);
            TOOLTIP_CACHE.put(itemStack, tooltip);
            return tooltip;
        }
        return TOOLTIP_CACHE.get(itemStack);
    }

    public static List<class_2561> getItemStackTooltip(class_1799 itemStack) {
        return class_437.method_25408((class_310)class_310.method_1551(), (class_1799)itemStack);
    }

    public static class_2561 getTooltipLongestLine(class_1799 itemStack, List<class_2561> tooltipLines) {
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        class_2561 longestLine = tooltipLines.get(0);
        if (itemConfig.screenTooltipsRequireCrouch && client.field_1724.method_18276()) {
            longestLine = tooltipLines.stream().max((a, b) -> textRenderer.method_27525((class_5348)a) - textRenderer.method_27525((class_5348)b)).orElse(tooltipLines.get(0));
        }
        return longestLine;
    }

    public static List<class_2561> getTooltipWithStackSize(class_1799 itemStack) {
        List<class_2561> tooltipLines = TooltipManager.getTooltipFromCache(itemStack);
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        int count = itemStack.method_7947();
        if (itemConfig.renderStackcount && count > 1) {
            String countString = " x" + count;
            class_2561 firstLine = tooltipLines.get(0);
            String itemNameString = firstLine.getString();
            if (!itemNameString.contains(countString)) {
                class_5250 newLineWithCount = class_2561.method_43470((String)(itemNameString + countString)).method_10862(firstLine.method_10866());
                tooltipLines.set(0, (class_2561)newLineWithCount);
            }
        }
        return tooltipLines;
    }

    public static boolean canRenderTooltips(class_1799 itemStack) {
        class_310 client = class_310.method_1551();
        boolean isChatScreen = client.field_1755 instanceof class_408;
        boolean inGame = client.field_1755 == null;
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        return itemConfig.advancedTooltips && (inGame || isChatScreen);
    }

    public static class OffsetContainer {
        private final int offset;
        private final int halfTooltipWidth;

        public OffsetContainer(int offset, int halfTooltipWidth) {
            this.offset = offset;
            this.halfTooltipWidth = halfTooltipWidth;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getHalfTooltipWidth() {
            return this.halfTooltipWidth;
        }

        public int getTooltipWidth() {
            return this.halfTooltipWidth * 2;
        }
    }
}

