/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.helpers;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_3532;
import net.minecraft.class_5251;

public class ColorHelper {
    public static int parseColor(String color) {
        int i;
        if (((String)color).startsWith("#")) {
            color = ((String)color).substring(1);
        }
        if (((String)color).length() == 3 || ((String)color).length() == 4) {
            color = ((String)color).replaceAll(".", "$0$0");
        }
        if (((String)color).length() == 6) {
            color = "FF" + (String)color;
        }
        if (Integer.compareUnsigned(i = Integer.parseUnsignedInt((String)color, 16), 0) >= 0 && Integer.compareUnsigned(i, -1) <= 0) {
            return i;
        }
        return 0;
    }

    public static int darken(int color, float value) {
        int a = ColorHelper.getAlpha(color);
        int r = (int)((float)ColorHelper.getRed(color) * (1.0f - value));
        int g = (int)((float)ColorHelper.getGreen(color) * (1.0f - value));
        int b = (int)((float)ColorHelper.getBlue(color) * (1.0f - value));
        return ColorHelper.build(a, r, g, b);
    }

    public static String darken(String color, float value) {
        int colorValue = ColorHelper.parseColor(color);
        return ColorHelper.toHexColor(ColorHelper.darken(colorValue, value));
    }

    public static String toHexColor(int color) {
        return String.format("#%08X", color);
    }

    public static int getAlpha(int i) {
        if (i <= 0xFFFFFF) {
            return 255;
        }
        return i >>> 24;
    }

    public static int getRed(int i) {
        return i >> 16 & 0xFF;
    }

    public static int getGreen(int i) {
        return i >> 8 & 0xFF;
    }

    public static int getBlue(int i) {
        return i & 0xFF;
    }

    public static IntRGB getIntRGB(int color) {
        return new IntRGB(ColorHelper.getRed(color), ColorHelper.getGreen(color), ColorHelper.getBlue(color));
    }

    public static FloatRGB getFloatRGB(int color) {
        return new FloatRGB((float)ColorHelper.getRed(color) / 255.0f, (float)ColorHelper.getGreen(color) / 255.0f, (float)ColorHelper.getBlue(color) / 255.0f);
    }

    public static int build(int A, int R, int G, int B) {
        return A << 24 | R << 16 | G << 8 | B;
    }

    public record IntRGB(int R, int G, int B) {
        public IntRGB lighter(int value) {
            return new IntRGB(Math.min(this.R + value, 255), Math.min(this.G + value, 255), Math.min(this.B + value, 255));
        }

        public IntRGB darken(int value) {
            return new IntRGB(Math.max(this.R - value, 0), Math.max(this.G - value, 0), Math.max(this.B - value, 0));
        }

        public int pack() {
            return this.R << 16 | this.G << 8 | this.B;
        }

        public static IntRGB of(Color color) {
            return new IntRGB(color.R, color.G, color.B);
        }

        @Override
        public String toString() {
            return "RGB{R=" + this.R + ", G=" + this.G + ", B=" + this.B + "}";
        }
    }

    public record FloatRGB(float R, float G, float B) {
        public FloatRGB lighter(float value) {
            return new FloatRGB(Math.min(this.R + value, 1.0f), Math.min(this.G + value, 1.0f), Math.min(this.B + value, 1.0f));
        }

        public FloatRGB darken(float value) {
            return new FloatRGB(Math.max(this.R - value, 0.0f), Math.max(this.G - value, 0.0f), Math.max(this.B - value, 0.0f));
        }

        public int pack() {
            return (int)(this.R * 255.0f) << 16 | (int)(this.G * 255.0f) << 8 | (int)(this.B * 255.0f);
        }

        public static FloatRGB of(Color color) {
            return new FloatRGB(color.fR, color.fG, color.fB);
        }

        @Override
        public String toString() {
            return "RGB{R=" + this.R + ", G=" + this.G + ", B=" + this.B + "}";
        }
    }

    public static class Color {
        public int R = 255;
        public int G = 255;
        public int B = 255;
        public int A = 255;
        public float fR = 1.0f;
        public float fG = 1.0f;
        public float fB = 1.0f;
        public float fA = 1.0f;
        public int H = 0;
        public int S = 0;
        public int V = 255;
        public float fH = 0.0f;
        public float fS = 0.0f;
        public float fV = 1.0f;

        public Color(int color) {
            this.setRgb(color);
            this.updateHsvValues();
            this.A = ColorHelper.getAlpha(color);
            this.fA = (float)this.A / 255.0f;
        }

        public void setRgb(int color) {
            this.R = ColorHelper.getRed(color);
            this.G = ColorHelper.getGreen(color);
            this.B = ColorHelper.getBlue(color);
            this.fR = (float)this.R / 255.0f;
            this.fG = (float)this.G / 255.0f;
            this.fB = (float)this.B / 255.0f;
        }

        public void updateRgbValues() {
            int rgb = java.awt.Color.HSBtoRGB(this.fH, this.fS, this.fV);
            this.setRgb(rgb & 0xFFFFFF);
        }

        public void updateHsvValues() {
            float[] hsv = java.awt.Color.RGBtoHSB(this.R, this.G, this.B, null);
            this.fH = hsv[0];
            this.fS = hsv[1];
            this.fV = hsv[2];
            this.H = (int)(this.fH * 360.0f);
            this.S = (int)(this.fS * 255.0f);
            this.V = (int)(this.fV * 255.0f);
        }

        public int getRgb() {
            return ColorHelper.build(this.A, this.R, this.G, this.B);
        }

        public Color applyModifiers(List<String> modifiers) {
            Map<Character, BiFunction<Integer, Integer, Integer>> modifierFuncs = Map.of(Character.valueOf('+'), (v, a) -> v + a, Character.valueOf('-'), (v, a) -> v - a, Character.valueOf('='), (v, a) -> a);
            block11: for (String modifier : modifiers) {
                BiFunction<Integer, Integer, Integer> mod;
                int amount;
                if (modifier.length() < 3) continue;
                char type = modifier.toLowerCase().charAt(1);
                try {
                    amount = Integer.parseInt(modifier.substring(2));
                    mod = modifierFuncs.get(Character.valueOf(modifier.charAt(0)));
                }
                catch (Exception e) {
                    continue;
                }
                if (mod == null) continue;
                switch (type) {
                    case 'h': {
                        this.H = (mod.apply(this.H, amount) + 360) % 360;
                        this.fH = (float)this.H / 360.0f;
                        this.updateRgbValues();
                        continue block11;
                    }
                    case 's': {
                        this.S = class_3532.method_15340((int)mod.apply(this.S, amount), (int)0, (int)255);
                        this.fS = (float)this.S / 255.0f;
                        this.updateRgbValues();
                        continue block11;
                    }
                    case 'v': {
                        this.V = class_3532.method_15340((int)mod.apply(this.V, amount), (int)0, (int)255);
                        this.fV = (float)this.V / 255.0f;
                        this.updateRgbValues();
                        continue block11;
                    }
                    case 'r': {
                        this.R = class_3532.method_15340((int)mod.apply(this.R, amount), (int)0, (int)255);
                        this.fR = (float)this.R / 255.0f;
                        this.updateHsvValues();
                        continue block11;
                    }
                    case 'g': {
                        this.G = class_3532.method_15340((int)mod.apply(this.G, amount), (int)0, (int)255);
                        this.fG = (float)this.G / 255.0f;
                        this.updateHsvValues();
                        continue block11;
                    }
                    case 'b': {
                        this.B = class_3532.method_15340((int)mod.apply(this.B, amount), (int)0, (int)255);
                        this.fB = (float)this.B / 255.0f;
                        this.updateHsvValues();
                        continue block11;
                    }
                    case 'a': {
                        this.A = class_3532.method_15340((int)mod.apply(this.A, amount), (int)0, (int)255);
                        this.fA = (float)this.A / 255.0f;
                        continue block11;
                    }
                }
            }
            return this;
        }

        public static Color of(class_5251 color) {
            return new Color(color.method_27716());
        }

        public String toString() {
            return "Color[R:" + this.R + ",G:" + this.G + ",B:" + this.B + ",A:" + this.A + "]";
        }
    }
}

