/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.features;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootbeams.LootBeams;
import com.lootbeams.config.Configuration;
import com.lootbeams.dconfig.DynamicConfig;
import com.lootbeams.features.CustomRarity;
import com.lootbeams.managers.GlowEffectManager;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.shaders.LootBeamShaders;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3518;

public class CustomLootBeamsConfig {
    private static final String CONFIG_KEY = "lootbeams_config";
    private static final Map<class_1799, Configuration> CONFIG_CACHE = new WeakHashMap<class_1799, Configuration>();

    public static void clearConfigCache() {
        CONFIG_CACHE.clear();
    }

    public static void onConfigurationChange() {
        CustomLootBeamsConfig.clearConfigCache();
    }

    public static void onResourcesReload() {
        CustomLootBeamsConfig.clearConfigCache();
    }

    private static Configuration getConfigCopy(Configuration configInstance) {
        Configuration configCopy = new Configuration();
        for (Field field : configInstance.getClass().getDeclaredFields()) {
            try {
                Field fieldRef = configCopy.getClass().getDeclaredField(field.getName());
                fieldRef.setAccessible(true);
                fieldRef.set(configCopy, field.get(configInstance));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return configCopy;
    }

    private static Configuration processConfig(class_2487 customConfig) {
        Configuration configCopy = CustomLootBeamsConfig.getConfigCopy(LootBeams.config);
        List<DynamicConfig.Control.Field> fieldsToProcess = LootBeams.configManager.getFieldsByGroup("visual");
        for (DynamicConfig.Control.Field field : fieldsToProcess) {
            try {
                Field fieldRef = configCopy.getClass().getDeclaredField(field.key);
                fieldRef.setAccessible(true);
                if (!customConfig.method_33133() && customConfig.method_10545(field.saveKey)) {
                    String[] parts;
                    String textureKey;
                    if (field.type == Boolean.TYPE) {
                        fieldRef.set(configCopy, customConfig.method_10577(field.saveKey));
                    }
                    if (field.type == Integer.TYPE) {
                        fieldRef.set(configCopy, customConfig.method_10550(field.saveKey));
                    }
                    if (field.type == Long.TYPE) {
                        fieldRef.set(configCopy, customConfig.method_10537(field.saveKey));
                    }
                    if (field.type == Float.TYPE) {
                        fieldRef.set(configCopy, Float.valueOf(customConfig.method_10583(field.saveKey)));
                    }
                    if (field.type == Double.TYPE) {
                        fieldRef.set(configCopy, customConfig.method_10574(field.saveKey));
                    }
                    if (field.type == String.class) {
                        fieldRef.set(configCopy, customConfig.method_10558(field.saveKey));
                    }
                    if (field.type == List.class) {
                        String value = customConfig.method_10558(field.saveKey);
                        List<String> values = Arrays.stream(value.split(",")).map(String::trim).toList();
                        fieldRef.set(configCopy, values);
                    }
                    if (field.type == ParticleManager.ParticleTexture.class) {
                        textureKey = customConfig.method_10558(field.saveKey);
                        if (textureKey.contains(":")) {
                            parts = textureKey.split(":");
                            fieldRef.set(configCopy, ParticleManager.ParticleTexture.of(textureKey, parts[0]));
                        } else {
                            fieldRef.set(configCopy, ParticleManager.ParticleTexture.of(textureKey, "lootbeams"));
                        }
                    }
                    if (field.type == GlowEffectManager.GlowEffectTexture.class) {
                        textureKey = customConfig.method_10558(field.saveKey);
                        if (textureKey.contains(":")) {
                            parts = textureKey.split(":");
                            fieldRef.set(configCopy, GlowEffectManager.GlowEffectTexture.of(textureKey, parts[0]));
                        } else {
                            fieldRef.set(configCopy, GlowEffectManager.GlowEffectTexture.of(textureKey, "lootbeams"));
                        }
                    }
                    if (field.type == LootBeamShaders.Shader.class) {
                        fieldRef.set(configCopy, (Object)LootBeamShaders.Shader.valueOf(customConfig.method_10558(field.saveKey).toUpperCase()));
                    }
                    if (field.type != LootBeamShaders.CustomShader.class) continue;
                    fieldRef.set(configCopy, LootBeamShaders.CustomShader.valueOf(customConfig.method_10558(field.saveKey).toUpperCase()));
                    continue;
                }
                fieldRef.set(configCopy, LootBeams.configManager.getFieldValue(field.key));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return configCopy;
    }

    private static Configuration processConfig(JsonObject customConfig) {
        Configuration configCopy = CustomLootBeamsConfig.getConfigCopy(LootBeams.config);
        List<DynamicConfig.Control.Field> fieldsToProcess = LootBeams.configManager.getFieldsByGroup("visual");
        for (DynamicConfig.Control.Field field : fieldsToProcess) {
            try {
                Field fieldRef = configCopy.getClass().getDeclaredField(field.key);
                fieldRef.setAccessible(true);
                if (!customConfig.isJsonNull() && customConfig.has(field.saveKey)) {
                    String[] parts;
                    String textureKey;
                    if (field.type == Boolean.TYPE) {
                        fieldRef.set(configCopy, class_3518.method_15270((JsonObject)customConfig, (String)field.saveKey));
                    }
                    if (field.type == Integer.TYPE) {
                        fieldRef.set(configCopy, class_3518.method_15260((JsonObject)customConfig, (String)field.saveKey));
                    }
                    if (field.type == Long.TYPE) {
                        fieldRef.set(configCopy, class_3518.method_22449((JsonObject)customConfig, (String)field.saveKey));
                    }
                    if (field.type == Float.TYPE) {
                        fieldRef.set(configCopy, Float.valueOf(class_3518.method_15259((JsonObject)customConfig, (String)field.saveKey)));
                    }
                    if (field.type == Double.TYPE) {
                        fieldRef.set(configCopy, class_3518.method_34927((JsonObject)customConfig, (String)field.saveKey));
                    }
                    if (field.type == String.class) {
                        fieldRef.set(configCopy, class_3518.method_15265((JsonObject)customConfig, (String)field.saveKey));
                    }
                    if (field.type == List.class) {
                        List<String> values = class_3518.method_15261((JsonObject)customConfig, (String)field.saveKey).asList().stream().map(JsonElement::getAsString).toList();
                        fieldRef.set(configCopy, values);
                    }
                    if (field.type == ParticleManager.ParticleTexture.class) {
                        textureKey = class_3518.method_15265((JsonObject)customConfig, (String)field.saveKey);
                        if (textureKey.contains(":")) {
                            parts = textureKey.split(":");
                            fieldRef.set(configCopy, ParticleManager.ParticleTexture.of(textureKey, parts[0]));
                        } else {
                            fieldRef.set(configCopy, ParticleManager.ParticleTexture.of(textureKey, "lootbeams"));
                        }
                    }
                    if (field.type == GlowEffectManager.GlowEffectTexture.class) {
                        textureKey = class_3518.method_15265((JsonObject)customConfig, (String)field.saveKey);
                        if (textureKey.contains(":")) {
                            parts = textureKey.split(":");
                            fieldRef.set(configCopy, GlowEffectManager.GlowEffectTexture.of(textureKey, parts[0]));
                        } else {
                            fieldRef.set(configCopy, GlowEffectManager.GlowEffectTexture.of(textureKey, "lootbeams"));
                        }
                    }
                    if (field.type == LootBeamShaders.Shader.class) {
                        fieldRef.set(configCopy, (Object)LootBeamShaders.Shader.valueOf(class_3518.method_15265((JsonObject)customConfig, (String)field.saveKey).toUpperCase()));
                    }
                    if (field.type != LootBeamShaders.CustomShader.class) continue;
                    fieldRef.set(configCopy, LootBeamShaders.CustomShader.valueOf(class_3518.method_15265((JsonObject)customConfig, (String)field.saveKey).toUpperCase()));
                    continue;
                }
                fieldRef.set(configCopy, LootBeams.configManager.getFieldValue(field.key));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return configCopy;
    }

    public static Configuration fromItemStack(class_1799 itemStack) {
        class_2487 customConfig;
        class_2487 customDataNbt;
        if (CONFIG_CACHE.containsKey(itemStack)) {
            return CONFIG_CACHE.get(itemStack);
        }
        if (itemStack.method_7985() && !(customDataNbt = itemStack.method_7969()).method_33133() && !(customConfig = customDataNbt.method_10562(CONFIG_KEY)).method_33133()) {
            Configuration newConfig = CustomLootBeamsConfig.processConfig(customConfig);
            CONFIG_CACHE.put(itemStack, newConfig);
            return newConfig;
        }
        CustomRarity itemRarity = CustomRarity.fromItemStack(itemStack);
        if (itemRarity != null && itemRarity.hasRarityConfig()) {
            Configuration newConfig = CustomLootBeamsConfig.processConfig(itemRarity.getRarityConfig());
            CONFIG_CACHE.put(itemStack, newConfig);
            return newConfig;
        }
        return LootBeams.config;
    }
}

