/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.dconfig;

import com.lootbeams.dconfig.events.ConfigEvents;
import com.lootbeams.dconfig.interfaces.DynamicConfigAdapter;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DynamicConfig {
    public static <T> ConfigManager<T> load(String modId, Class<T> configClass, DynamicConfigAdapter<T> configAdapter) {
        ConfigManager<T> configManager = new ConfigManager<T>(modId, configClass, configAdapter);
        return configManager.load();
    }

    public static class ConfigManager<T> {
        private String MOD_ID = "";
        private T config;
        private List<Control.Field> fields;
        private final DynamicConfigAdapter<T> adapter;
        private final Map<String, Object> FIELD_VALUE_CACHE = new HashMap<String, Object>();

        public ConfigManager(String modId, Class<T> configClass, DynamicConfigAdapter<T> adapter) {
            this.MOD_ID = modId;
            this.adapter = adapter;
            try {
                this.config = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.fields = this.loadFields(configClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.adapter.initialize(this);
        }

        public String getConfigFilePath() {
            return this.adapter.getConfigFilePath();
        }

        public <T> void printConfig(T config) throws IllegalAccessException {
            java.lang.reflect.Field[] classFields;
            for (java.lang.reflect.Field field : classFields = config.getClass().getDeclaredFields()) {
                System.out.println(field.getName() + ": " + String.valueOf(field.get(config)));
            }
        }

        public void printFields() {
            for (Control.Field field : this.fields) {
                System.out.println(field);
            }
        }

        private <T> List<Control.Field> loadFields(Class<T> configClass) throws IllegalAccessException {
            java.lang.reflect.Field[] classFields;
            Objects.requireNonNull(configClass);
            HashMap<String, Control.Category> categories = new HashMap<String, Control.Category>();
            for (Class<?> innerClass : configClass.getDeclaredClasses()) {
                for (java.lang.reflect.Field field : innerClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Category.class)) continue;
                    Category categoryData = field.getAnnotation(Category.class);
                    String categoryKey = (String)field.get(null);
                    Control.Category category = new Control.Category(categoryKey, categoryData.name(), categoryData.key()).setDisplayOnConfigScreen(categoryData.display()).setAsRoot(categoryData.root());
                    categories.put(categoryKey, category);
                }
            }
            ArrayList<Control.Field> fields = new ArrayList<Control.Field>();
            for (java.lang.reflect.Field field : classFields = configClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Field.class)) continue;
                Field dynamicField = field.getAnnotation(Field.class);
                String categoryKey = dynamicField.category();
                Control.Category category = (Control.Category)categories.get(categoryKey);
                String group = dynamicField.group();
                boolean displayOnConfigScreen = dynamicField.display();
                Class<?> type = field.getType();
                Type[] typeArguments = null;
                Object defaultValue = null;
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    typeArguments = parameterizedType.getActualTypeArguments();
                }
                try {
                    defaultValue = field.get(this.config);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                Control.Field configField = new Control.Field(this.MOD_ID, field.getName(), category, type, typeArguments, defaultValue).setGroup(group).setDisplayOnConfigScreen(displayOnConfigScreen);
                double minValue = dynamicField.min();
                double maxValue = dynamicField.max();
                if (type == Integer.TYPE) {
                    configField.setMin((int)minValue);
                    configField.setMax((int)maxValue);
                } else if (type == Float.TYPE) {
                    configField.setMin(Float.valueOf((float)minValue));
                    configField.setMax(Float.valueOf((float)maxValue));
                } else if (type == Double.TYPE) {
                    configField.setMin(minValue);
                    configField.setMax(maxValue);
                } else if (type == Long.TYPE) {
                    configField.setMin((long)minValue);
                    configField.setMax((long)maxValue);
                }
                fields.add(configField);
            }
            return fields;
        }

        public T getConfig() {
            return this.config;
        }

        public List<Control.Field> getFields() {
            return this.fields;
        }

        public Control.Field getField(String fieldKey) {
            return this.fields.stream().filter(field -> field.key.equals(fieldKey)).findFirst().orElse(null);
        }

        public List<Control.Field> getFieldsByCategory(String category) {
            ArrayList<Control.Field> fields = new ArrayList<Control.Field>();
            for (Control.Field field : this.fields) {
                if (!field.category.key.equals(category)) continue;
                fields.add(field);
            }
            return fields;
        }

        public List<Control.Field> getFieldsByGroup(String group) {
            ArrayList<Control.Field> fields = new ArrayList<Control.Field>();
            for (Control.Field field : this.fields) {
                if (!field.group.equals(group)) continue;
                fields.add(field);
            }
            return fields;
        }

        public List<Control.Field> getFieldsByCategoryAndGroup(String category, String group) {
            return this.getFieldsByCategory(category).stream().filter(field -> field.group.equals(group)).toList();
        }

        public void clearFieldValueCache() {
            this.FIELD_VALUE_CACHE.clear();
        }

        public <V> V getFieldValue(String fieldName) {
            if (this.FIELD_VALUE_CACHE.containsKey(fieldName)) {
                return (V)this.FIELD_VALUE_CACHE.get(fieldName);
            }
            try {
                java.lang.reflect.Field configField = this.config.getClass().getDeclaredField(fieldName);
                Object value = configField.get(this.config);
                this.FIELD_VALUE_CACHE.put(fieldName, value);
                return (V)value;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void setFieldValue(String fieldName, Object value) {
            try {
                java.lang.reflect.Field configField = this.config.getClass().getDeclaredField(fieldName);
                configField.setAccessible(true);
                configField.set(this.config, value);
                if (this.FIELD_VALUE_CACHE.containsKey(fieldName)) {
                    this.FIELD_VALUE_CACHE.put(fieldName, value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public ConfigManager<T> load(InputStream inputStream) {
            return this.adapter.load(this, inputStream);
        }

        public ConfigManager<T> load(File configFile) {
            if (!configFile.isFile()) {
                this.adapter.save(this, configFile);
            }
            return this.adapter.load(this, configFile);
        }

        public ConfigManager<T> load() {
            return this.load(this.adapter.getConfigFile());
        }

        public void save(File configFile) {
            DynamicConfigAdapter.SaveResult result = this.adapter.save(this, configFile);
            if (result == DynamicConfigAdapter.SaveResult.SUCCESS) {
                ConfigEvents.SAVE.invoker().onConfigSave();
            }
        }

        public void save() {
            this.save(this.adapter.getConfigFile());
        }

        @FunctionalInterface
        public static interface SaveConsumer<T, U> {
            public T accept(U var1);
        }

        @FunctionalInterface
        public static interface LoadConsumer<T, U, V> {
            public T accept(U var1, V var2);
        }
    }

    public static class Control {

        public static class Field {
            public String key;
            public String saveKey;
            public Category category;
            public String group = "default";
            public String name;
            public String description;
            public Class<?> type;
            public Type[] typeArguments;
            public Object defaultValue;
            public Object minValue = null;
            public Object maxValue = null;
            public boolean displayOnConfigScreen = true;

            public Field(String modId, String key, Category category, Class<?> type, Type[] typeArguments, Object defaultValue) {
                this.key = key;
                this.saveKey = this.camelToSnake(key);
                this.category = category;
                this.name = MessageFormat.format("{0}.config.{1}.{2}", modId, category.key, key);
                this.description = MessageFormat.format("{0}.config.{1}.{2}.description", modId, category.key, key);
                this.type = type;
                this.typeArguments = typeArguments;
                this.defaultValue = defaultValue;
            }

            private String camelToSnake(String str) {
                return str.replaceAll("([a-z0-9])([A-Z])", "$1_$2").replaceAll("([A-Z])([A-Z][a-z])", "$1_$2").toLowerCase();
            }

            public Field setMin(Object minValue) {
                this.minValue = minValue;
                return this;
            }

            public Field setMax(Object maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public Field setGroup(String group) {
                this.group = group;
                return this;
            }

            public Field setDisplayOnConfigScreen(boolean displayOnConfigScreen) {
                this.displayOnConfigScreen = displayOnConfigScreen;
                return this;
            }

            public String toString() {
                return "DynamicConfig.Field[key=" + this.key + ", saveKey=" + this.saveKey + ", category=" + String.valueOf(this.category) + ", name=" + this.name + ", description=" + this.description + ", type=" + String.valueOf(this.type) + ", typeArguments=" + String.valueOf(this.typeArguments) + ", defaultValue=" + String.valueOf(this.defaultValue) + "]";
            }
        }

        public static class Group {
            public static final String DEFAULT = "default";
        }

        public static class Category {
            public String key;
            public String name;
            public String saveKey;
            public boolean displayOnConfigScreen = true;
            public boolean isRootCategory = false;

            public Category(String key, String name, String saveKey) {
                this.key = key;
                this.name = name;
                this.saveKey = saveKey;
            }

            public Category setAsRoot(boolean isRootCategory) {
                this.isRootCategory = isRootCategory;
                return this;
            }

            public Category setDisplayOnConfigScreen(boolean displayOnConfigScreen) {
                this.displayOnConfigScreen = displayOnConfigScreen;
                return this;
            }

            public String toString() {
                return "DynamicConfig.Category[key=" + this.key + ", name=" + this.name + ", displayOnConfigScreen=" + this.displayOnConfigScreen + ", isRootCategory=" + this.isRootCategory + "]";
            }
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Category {
        public String name();

        public String key();

        public boolean root() default false;

        public boolean display() default true;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Field {
        public String category();

        public String group() default "default";

        public double min() default 0.0;

        public double max() default 1.7976931348623157E308;

        public boolean display() default true;
    }
}

