/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.lootbeams.config.Configuration;
import com.lootbeams.dconfig.DynamicConfig;
import com.lootbeams.dconfig.interfaces.DynamicConfigAdapter;
import com.lootbeams.features.BeamOpacityOnApproach;
import com.lootbeams.features.BeamSizeOnApproach;
import com.lootbeams.helpers.FileHelper;
import com.lootbeams.managers.CrashManager;
import com.lootbeams.managers.GlowEffectManager;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.shaders.LootBeamShaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

public class JsonConfigAdapter
implements DynamicConfigAdapter<Configuration> {
    private final Map<Class<?>, DynamicConfig.ConfigManager.LoadConsumer<Object, DynamicConfig.Control.Field, JsonObject>> TYPE_LOADERS = new HashMap();
    private final Map<Class<?>, DynamicConfig.ConfigManager.SaveConsumer<JsonElement, Object>> TYPE_SAVERS = new HashMap();

    public void registerTypeLoadConsumer(Class<?> type, DynamicConfig.ConfigManager.LoadConsumer<Object, DynamicConfig.Control.Field, JsonObject> consumer) {
        if (this.TYPE_LOADERS.containsKey(type)) {
            return;
        }
        this.TYPE_LOADERS.put(type, consumer);
    }

    public void registerTypeSaveConsumer(Class<?> type, DynamicConfig.ConfigManager.SaveConsumer<JsonElement, Object> consumer) {
        if (this.TYPE_SAVERS.containsKey(type)) {
            return;
        }
        this.TYPE_SAVERS.put(type, consumer);
    }

    @Override
    public String getConfigFilePath() {
        return "lootbeams/config.json";
    }

    @Override
    public File getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve(this.getConfigFilePath()).toFile();
    }

    private JsonArray toArray(List<String> list) {
        JsonArray jsonArray = new JsonArray();
        for (String str : list) {
            jsonArray.add((JsonElement)new JsonPrimitive(str));
        }
        return jsonArray;
    }

    private List<String> toList(JsonArray jsonArray) {
        return jsonArray.asList().stream().map(JsonElement::getAsString).toList();
    }

    @Override
    public void initialize(DynamicConfig.ConfigManager<Configuration> configManager) {
        this.registerTypeLoadConsumer(Boolean.TYPE, (field, group) -> class_3518.method_15258((JsonObject)group, (String)field.saveKey, (boolean)((Boolean)field.defaultValue)));
        this.registerTypeLoadConsumer(Integer.TYPE, (field, group) -> class_3518.method_15282((JsonObject)group, (String)field.saveKey, (int)((Integer)field.defaultValue)));
        this.registerTypeLoadConsumer(Float.TYPE, (field, group) -> Float.valueOf(class_3518.method_15277((JsonObject)group, (String)field.saveKey, (float)((Float)field.defaultValue).floatValue())));
        this.registerTypeLoadConsumer(String.class, (field, group) -> class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((String)field.defaultValue)));
        this.registerTypeLoadConsumer(List.class, (field, group) -> this.toList(class_3518.method_15292((JsonObject)group, (String)field.saveKey, (JsonArray)this.toArray((List)field.defaultValue))));
        this.registerTypeSaveConsumer(Boolean.TYPE, value -> new JsonPrimitive(Boolean.valueOf((Boolean)value)));
        this.registerTypeSaveConsumer(Integer.TYPE, value -> new JsonPrimitive((Number)((Integer)value)));
        this.registerTypeSaveConsumer(Float.TYPE, value -> new JsonPrimitive((Number)Float.valueOf(((Float)value).floatValue())));
        this.registerTypeSaveConsumer(String.class, value -> new JsonPrimitive((String)value));
        this.registerTypeSaveConsumer(List.class, value -> this.toArray((List)value));
        this.registerTypeLoadConsumer(ParticleManager.ParticleTexture.class, (field, group) -> ParticleManager.ParticleTexture.of(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((ParticleManager.ParticleTexture)field.defaultValue).path), "lootbeams"));
        this.registerTypeSaveConsumer(ParticleManager.ParticleTexture.class, value -> new JsonPrimitive(((ParticleManager.ParticleTexture)value).path));
        this.registerTypeLoadConsumer(GlowEffectManager.GlowEffectTexture.class, (field, group) -> GlowEffectManager.GlowEffectTexture.of(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((GlowEffectManager.GlowEffectTexture)field.defaultValue).path), "lootbeams"));
        this.registerTypeSaveConsumer(GlowEffectManager.GlowEffectTexture.class, value -> new JsonPrimitive(((GlowEffectManager.GlowEffectTexture)value).path));
        this.registerTypeLoadConsumer(LootBeamShaders.Shader.class, (field, group) -> LootBeamShaders.Shader.valueOf(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((LootBeamShaders.Shader)((Object)((Object)field.defaultValue))).name()).toUpperCase()));
        this.registerTypeSaveConsumer(LootBeamShaders.Shader.class, value -> new JsonPrimitive(((LootBeamShaders.Shader)((Object)((Object)value))).name().toLowerCase()));
        this.registerTypeLoadConsumer(LootBeamShaders.CustomShader.class, (field, group) -> LootBeamShaders.CustomShader.valueOf(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((LootBeamShaders.CustomShader)field.defaultValue).name()).toUpperCase()));
        this.registerTypeSaveConsumer(LootBeamShaders.CustomShader.class, value -> new JsonPrimitive(((LootBeamShaders.CustomShader)value).name().toLowerCase()));
        this.registerTypeLoadConsumer(BeamOpacityOnApproach.class, (field, group) -> BeamOpacityOnApproach.valueOf(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((BeamOpacityOnApproach)((Object)((Object)field.defaultValue))).name()).toUpperCase()));
        this.registerTypeSaveConsumer(BeamOpacityOnApproach.class, value -> new JsonPrimitive(((BeamOpacityOnApproach)((Object)((Object)value))).name().toLowerCase()));
        this.registerTypeLoadConsumer(BeamSizeOnApproach.class, (field, group) -> BeamSizeOnApproach.valueOf(class_3518.method_15253((JsonObject)group, (String)field.saveKey, (String)((BeamSizeOnApproach)((Object)((Object)field.defaultValue))).name()).toUpperCase()));
        this.registerTypeSaveConsumer(BeamSizeOnApproach.class, value -> new JsonPrimitive(((BeamSizeOnApproach)((Object)((Object)value))).name().toLowerCase()));
    }

    public DynamicConfig.ConfigManager<Configuration> loadJson(DynamicConfig.ConfigManager<Configuration> configManager, JsonObject jsonObject) {
        if (jsonObject == null) {
            return configManager;
        }
        try {
            HashMap<String, JsonObject> groups = new HashMap<String, JsonObject>();
            for (DynamicConfig.Control.Field field : configManager.getFields()) {
                DynamicConfig.ConfigManager.LoadConsumer<Object, DynamicConfig.Control.Field, JsonObject> loadConsumer;
                JsonObject group;
                if (!groups.containsKey(field.category.saveKey)) {
                    groups.put(field.category.saveKey, class_3518.method_15281((JsonObject)jsonObject, (String)field.category.saveKey, (JsonObject)new JsonObject()));
                }
                if ((group = (JsonObject)groups.get(field.category.saveKey)) == null || group.isJsonNull() || !group.has(field.saveKey) || (loadConsumer = this.TYPE_LOADERS.get(field.type)) == null) continue;
                configManager.setFieldValue(field.key, loadConsumer.accept(field, group));
            }
        }
        catch (Exception e) {
            CrashManager.LOGGER.warn("cannot load config file", (Throwable)e);
        }
        configManager.clearFieldValueCache();
        return configManager;
    }

    @Override
    public DynamicConfig.ConfigManager<Configuration> load(DynamicConfig.ConfigManager<Configuration> configManager, InputStream inputStream) {
        JsonObject jsonObject = class_3518.method_15255((Reader)new InputStreamReader(inputStream));
        return this.loadJson(configManager, jsonObject);
    }

    @Override
    public DynamicConfig.ConfigManager<Configuration> load(DynamicConfig.ConfigManager<Configuration> configManager, File configFile) {
        try {
            JsonObject jsonObject = class_3518.method_15255((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF8"));
            return this.loadJson(configManager, jsonObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DynamicConfigAdapter.SaveResult save(DynamicConfig.ConfigManager<Configuration> configManager, File saveFile) {
        DynamicConfigAdapter.SaveResult saveResult;
        JsonObject rootObject = new JsonObject();
        for (DynamicConfig.Control.Field field : configManager.getFields()) {
            DynamicConfig.ConfigManager.SaveConsumer<JsonElement, Object> saveConsumer = this.TYPE_SAVERS.get(field.type);
            if (saveConsumer == null) continue;
            try {
                Object value = configManager.getFieldValue(field.key);
                if (!rootObject.has(field.category.saveKey)) {
                    rootObject.add(field.category.saveKey, (JsonElement)new JsonObject());
                }
                JsonObject category = rootObject.getAsJsonObject(field.category.saveKey);
                category.add(field.saveKey, saveConsumer.accept(value));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        saveFile = FileHelper.createPathIfNotExists(saveFile.getPath());
        FileWriter jsonWriter = new FileWriter(saveFile);
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)rootObject, (Appendable)jsonWriter);
            saveResult = DynamicConfigAdapter.SaveResult.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                CrashManager.LOGGER.warn("Cannot save config file", (Throwable)e);
                return DynamicConfigAdapter.SaveResult.FAIL;
            }
        }
        jsonWriter.close();
        return saveResult;
    }
}

