/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.CommonAssetManager;
import com.tacz.guns.resource.pojo.GunIndexPOJO;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;

public class CommonGunIndex {
    private GunData gunData;
    private String type;
    private GunIndexPOJO pojo;
    private int sort;

    private CommonGunIndex() {
    }

    public static CommonGunIndex getInstance(GunIndexPOJO gunIndexPOJO) throws IllegalArgumentException {
        CommonGunIndex index = new CommonGunIndex();
        index.pojo = gunIndexPOJO;
        CommonGunIndex.checkIndex(gunIndexPOJO, index);
        CommonGunIndex.checkData(gunIndexPOJO, index);
        return index;
    }

    private static void checkIndex(GunIndexPOJO gunIndexPOJO, CommonGunIndex index) {
        Preconditions.checkArgument((gunIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gunIndexPOJO.getType()}), (Object)"index object missing type field");
        index.type = gunIndexPOJO.getType();
        index.sort = class_3532.method_15340((int)gunIndexPOJO.getSort(), (int)0, (int)65536);
    }

    private static void checkData(GunIndexPOJO gunIndexPOJO, CommonGunIndex index) {
        class_2960 pojoData = gunIndexPOJO.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        GunData data = CommonAssetManager.INSTANCE.getGunData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        Preconditions.checkArgument((data.getAmmoId() != null ? 1 : 0) != 0, (Object)"ammo id is empty");
        Preconditions.checkArgument((data.getAmmoAmount() >= 1 ? 1 : 0) != 0, (Object)"ammo count must >= 1");
        int[] extendedMagAmmoAmount = data.getExtendedMagAmmoAmount();
        Preconditions.checkArgument((extendedMagAmmoAmount == null || extendedMagAmmoAmount.length >= 3 ? 1 : 0) != 0, (Object)"extended_mag_ammo_amount size must is 3");
        Preconditions.checkArgument((data.getRoundsPerMinute() >= 1 ? 1 : 0) != 0, (Object)"rpm count must >= 1");
        Preconditions.checkArgument((data.getBolt() != null ? 1 : 0) != 0, (Object)"bolt type is error");
        Preconditions.checkArgument((data.getReloadData().getType() != null ? 1 : 0) != 0, (Object)"reload type is error");
        Preconditions.checkArgument((!data.getFireModeSet().isEmpty() ? 1 : 0) != 0, (Object)"fire mode is empty");
        Preconditions.checkArgument((!data.getFireModeSet().contains(null) && !data.getFireModeSet().contains((Object)FireMode.UNKNOWN) ? 1 : 0) != 0, (Object)"fire mode is error");
        CommonGunIndex.checkInaccuracy(data);
        CommonGunIndex.checkRecoil(data);
        index.gunData = data;
    }

    private static void checkInaccuracy(GunData data) {
        Map<InaccuracyType, Float> defaultInaccuracy = InaccuracyType.getDefaultInaccuracy();
        Map<InaccuracyType, Float> readInaccuracy = data.getInaccuracy();
        if (readInaccuracy == null || readInaccuracy.isEmpty()) {
            data.setInaccuracy(defaultInaccuracy);
        } else {
            defaultInaccuracy.forEach(readInaccuracy::putIfAbsent);
        }
    }

    private static void checkRecoil(GunData data) {
        float[] value;
        GunRecoil recoil = data.getRecoil();
        Object[] pitch = recoil.getPitch();
        Object[] yaw = recoil.getYaw();
        if (pitch != null) {
            for (Object keyFrame : pitch) {
                value = ((GunRecoilKeyFrame)keyFrame).getValue();
                Preconditions.checkArgument((value.length == 2 ? 1 : 0) != 0, (Object)"Recoil value's length must be 2");
                Preconditions.checkArgument((value[0] <= value[1] ? 1 : 0) != 0, (Object)"Recoil value's left must be less than right");
                Preconditions.checkArgument((((GunRecoilKeyFrame)keyFrame).getTime() >= 0.0f ? 1 : 0) != 0, (Object)"Recoil time must be more than 0");
            }
            Arrays.sort(pitch);
        }
        if (yaw != null) {
            for (Object keyFrame : yaw) {
                value = ((GunRecoilKeyFrame)keyFrame).getValue();
                Preconditions.checkArgument((value.length == 2 ? 1 : 0) != 0, (Object)"Recoil value's length must be 2");
                Preconditions.checkArgument((value[0] <= value[1] ? 1 : 0) != 0, (Object)"Recoil value's left must be less than right");
                Preconditions.checkArgument((((GunRecoilKeyFrame)keyFrame).getTime() >= 0.0f ? 1 : 0) != 0, (Object)"Recoil time must be more than 0");
            }
            Arrays.sort(yaw);
        }
    }

    public GunData getGunData() {
        return this.gunData;
    }

    public BulletData getBulletData() {
        return this.gunData.getBulletData();
    }

    public String getType() {
        return this.type;
    }

    public GunIndexPOJO getPojo() {
        return this.pojo;
    }

    public int getSort() {
        return this.sort;
    }
}

