/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.resource.ResourceManager;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableResult;
import com.tacz.guns.resource.CommonAssetManager;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.loader.asset.AllowAttachmentTagsLoader;
import com.tacz.guns.resource.loader.asset.AttachmentDataLoader;
import com.tacz.guns.resource.loader.asset.AttachmentTagsLoader;
import com.tacz.guns.resource.loader.asset.GunDataLoader;
import com.tacz.guns.resource.loader.asset.RecipeLoader;
import com.tacz.guns.resource.loader.index.CommonAmmoIndexLoader;
import com.tacz.guns.resource.loader.index.CommonAttachmentIndexLoader;
import com.tacz.guns.resource.loader.index.CommonGunIndexLoader;
import com.tacz.guns.resource.network.CommonGunPackNetwork;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.serialize.DistanceDamagePairSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableIngredientSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableResultSerializer;
import com.tacz.guns.resource.serialize.PairSerializer;
import com.tacz.guns.resource.serialize.Vec3Serializer;
import com.tacz.guns.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class CommonGunPackLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(Pair.class, (Object)new PairSerializer()).registerTypeAdapter(GunSmithTableIngredient.class, (Object)new GunSmithTableIngredientSerializer()).registerTypeAdapter(GunSmithTableResult.class, (Object)new GunSmithTableResultSerializer()).registerTypeAdapter(ExtraDamage.DistanceDamagePair.class, (Object)new DistanceDamagePairSerializer()).registerTypeAdapter(class_243.class, (Object)new Vec3Serializer()).create();
    public static final Path FOLDER = Paths.get("config", "tacz", "custom");
    public static final Map<class_2960, CommonGunIndex> GUN_INDEX = Maps.newHashMap();
    public static final Map<class_2960, CommonAmmoIndex> AMMO_INDEX = Maps.newHashMap();
    public static final Map<class_2960, CommonAttachmentIndex> ATTACHMENT_INDEX = Maps.newHashMap();

    public static void init() {
        CommonGunPackLoader.createFolder();
        CommonGunPackLoader.checkDefaultPack();
        CommonGunPackNetwork.clear();
    }

    public static void reloadAsset() {
        CommonAssetManager.INSTANCE.clearAll();
        File[] files = FOLDER.toFile().listFiles((dir, name) -> true);
        if (files != null) {
            CommonGunPackLoader.readAsset(files);
        }
    }

    public static void reloadIndex() {
        GUN_INDEX.clear();
        AMMO_INDEX.clear();
        File[] files = FOLDER.toFile().listFiles((dir, name) -> true);
        if (files != null) {
            CommonGunPackLoader.readIndex(files);
        }
    }

    public static void reloadRecipes() {
        CommonAssetManager.INSTANCE.clearRecipes();
        File[] files = FOLDER.toFile().listFiles((dir, name) -> true);
        if (files != null) {
            CommonGunPackLoader.readRecipes(files);
        }
    }

    private static void checkDefaultPack() {
        if (!((Boolean)OtherConfig.DEFAULT_PACK_DEBUG.get()).booleanValue()) {
            for (ResourceManager.ExtraEntry entry : ResourceManager.EXTRA_ENTRIES) {
                GetJarResources.copyModDirectory(entry.modMainClass(), entry.srcPath(), FOLDER, entry.extraDirName());
            }
        }
    }

    private static void createFolder() {
        File folder = FOLDER.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void readAsset(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                CommonGunPackLoader.readZipAsset(file);
            }
            if (!file.isDirectory()) continue;
            File[] subFiles = file.listFiles((dir, name) -> true);
            if (subFiles == null) {
                return;
            }
            for (File namespaceFile : subFiles) {
                CommonGunPackLoader.readDirAsset(namespaceFile);
            }
        }
    }

    private static void readZipAsset(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String path = iteration.nextElement().getName();
                GunDataLoader.load(zipFile, path);
                AttachmentDataLoader.load(zipFile, path);
                AttachmentTagsLoader.load(zipFile, path);
                AllowAttachmentTagsLoader.load(zipFile, path);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void readDirAsset(File root) {
        if (root.isDirectory()) {
            GunDataLoader.load(root);
            AttachmentDataLoader.load(root);
            AttachmentTagsLoader.load(root);
            AllowAttachmentTagsLoader.load(root);
        }
    }

    private static void readIndex(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                CommonGunPackLoader.readZipIndex(file);
            }
            if (!file.isDirectory()) continue;
            File[] subFiles = file.listFiles((dir, name) -> true);
            if (subFiles == null) {
                return;
            }
            for (File namespaceFile : subFiles) {
                CommonGunPackLoader.readDirIndex(namespaceFile);
            }
        }
    }

    private static void readZipIndex(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String path = iteration.nextElement().getName();
                CommonAmmoIndexLoader.loadAmmoIndex(path, zipFile);
                CommonGunIndexLoader.loadGunIndex(path, zipFile);
                CommonAttachmentIndexLoader.loadAttachmentIndex(path, zipFile);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void readDirIndex(File root) {
        if (root.isDirectory()) {
            try {
                CommonAmmoIndexLoader.loadAmmoIndex(root);
                CommonGunIndexLoader.loadGunIndex(root);
                CommonAttachmentIndexLoader.loadAttachmentIndex(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readRecipes(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                CommonGunPackLoader.readZipRecipes(file);
            }
            if (!file.isDirectory()) continue;
            File[] subFiles = file.listFiles((dir, name) -> true);
            if (subFiles == null) {
                return;
            }
            for (File namespaceFile : subFiles) {
                CommonGunPackLoader.readDirRecipes(namespaceFile);
            }
        }
    }

    private static void readZipRecipes(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String path = iteration.nextElement().getName();
                RecipeLoader.load(zipFile, path);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void readDirRecipes(File root) {
        if (root.isDirectory()) {
            RecipeLoader.load(root);
        }
    }

    public static Optional<CommonGunIndex> getGunIndex(class_2960 registryName) {
        return Optional.ofNullable(GUN_INDEX.get(registryName));
    }

    public static Optional<CommonAmmoIndex> getAmmoIndex(class_2960 registryName) {
        return Optional.ofNullable(AMMO_INDEX.get(registryName));
    }

    public static Optional<CommonAttachmentIndex> getAttachmentIndex(class_2960 registryName) {
        return Optional.ofNullable(ATTACHMENT_INDEX.get(registryName));
    }

    public static Set<Map.Entry<class_2960, CommonGunIndex>> getAllGuns() {
        return GUN_INDEX.entrySet();
    }

    public static Set<Map.Entry<class_2960, CommonAmmoIndex>> getAllAmmo() {
        return AMMO_INDEX.entrySet();
    }

    public static Set<Map.Entry<class_2960, CommonAttachmentIndex>> getAllAttachments() {
        return ATTACHMENT_INDEX.entrySet();
    }
}

