/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.packets.s2c.event;

import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.util.EnvironmentUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class GunKillS2CPacket
implements FabricPacket {
    public static final PacketType<GunKillS2CPacket> TYPE = PacketType.create((class_2960)new class_2960("tacz", "gun_kill"), GunKillS2CPacket::new);
    private final int killEntityId;
    private final int attackerId;
    private final class_2960 gunId;
    private final boolean isHeadShot;

    public GunKillS2CPacket(class_2540 buf) {
        this(buf.readInt(), buf.readInt(), buf.method_10810(), buf.readBoolean());
    }

    public GunKillS2CPacket(int killEntityId, int attackerId, class_2960 gunId, boolean isHeadShot) {
        this.killEntityId = killEntityId;
        this.attackerId = attackerId;
        this.gunId = gunId;
        this.isHeadShot = isHeadShot;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.killEntityId);
        buf.writeInt(this.attackerId);
        buf.method_10812(this.gunId);
        buf.writeBoolean(this.isHeadShot);
    }

    public void handle(class_1657 ignoredPlayer, PacketSender ignoredSender) {
        if (EnvironmentUtil.isClient()) {
            GunKillS2CPacket.doClientEvent(this);
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(value=EnvType.CLIENT)
    private static void doClientEvent(GunKillS2CPacket message) {
        class_1309 livingEntity;
        class_1309 livingEntity2;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 class_12972 = level.method_8469(message.killEntityId);
        @Nullable class_1309 killedEntity = class_12972 instanceof class_1309 ? (livingEntity2 = (class_1309)class_12972) : null;
        class_1297 class_12973 = level.method_8469(message.attackerId);
        @Nullable class_1309 attacker = class_12973 instanceof class_1309 ? (livingEntity = (class_1309)class_12973) : null;
        new EntityKillByGunEvent(killedEntity, attacker, message.gunId, message.isHeadShot, LogicalSide.CLIENT).post();
    }
}

