/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network;

import com.tacz.guns.GunMod;
import com.tacz.guns.network.IHandshakeMessage;
import com.tacz.guns.network.NetworkClientInitializer;
import com.tacz.guns.util.EnvironmentUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class HandshakeNetworking {
    private static final List<PacketInfo<? extends IHandshakeMessage>> HANDSHAKE_PACKETS = new ArrayList<PacketInfo<? extends IHandshakeMessage>>();
    private static final Map<class_2960, Class<? extends IHandshakeMessage.IResponsePacket>> RES_PACKETS = new HashMap<class_2960, Class<? extends IHandshakeMessage.IResponsePacket>>();

    public static void init() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            for (PacketInfo<? extends IHandshakeMessage> packetInfo : HANDSHAKE_PACKETS) {
                try {
                    Class packetClass = packetInfo.packetClass;
                    IHandshakeMessage packet = (IHandshakeMessage)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    sender.sendPacket((FabricPacket)packet);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    GunMod.LOGGER.error("{} Handshake packet processing error", (Object)packetInfo.type.getId().toString(), (Object)e);
                }
            }
        });
    }

    public static <T extends IHandshakeMessage.IResponsePacket> void register(@NotNull class_2960 id, @NotNull Class<T> resPacketClass) {
        RES_PACKETS.put(id, resPacketClass);
    }

    public static <T extends IHandshakeMessage> void register(@NotNull PacketType<T> type, @NotNull Class<T> packetClass) {
        HANDSHAKE_PACKETS.add(new PacketInfo<T>(type, packetClass));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)type.getId(), (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                return;
            }
            try {
                if (buf.readableBytes() > 0) {
                    class_2960 packetId = buf.method_10810();
                    Class<? extends IHandshakeMessage.IResponsePacket> ackPacketClass = RES_PACKETS.get(packetId);
                    if (ackPacketClass == null) {
                        GunMod.LOGGER.error("{} Is the handshake response packet registered?", (Object)packetId.toString());
                        return;
                    }
                    IHandshakeMessage.IResponsePacket packet = ackPacketClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    packet.read(buf);
                    packet.handle(responseSender);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                GunMod.LOGGER.error("Handshake response packet processing error in {}", (Object)type.getId().toString(), (Object)e);
            }
        });
        if (EnvironmentUtil.isClient()) {
            NetworkClientInitializer.registerHandshake(type);
        }
    }

    public record PacketInfo<T extends IHandshakeMessage>(PacketType<T> type, Class<T> packetClass) {
    }
}

