/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.command.sub.DebugCommand;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.debug.GunMeleeDebug;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.packets.s2c.event.GunFireS2CPacket;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.attachment.EffectData;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.attachment.Silence;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.AttachmentDataUtils;
import com.tacz.guns.util.CycleTaskHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModernKineticGunItem
extends AbstractGunItem
implements GunItemDataAccessor {
    public static final String TYPE_NAME = "modern_kinetic";

    public ModernKineticGunItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Override
    public void bolt(class_1799 gunItem) {
        if (this.getCurrentAmmoCount(gunItem) > 0) {
            this.reduceCurrentAmmoCount(gunItem);
            this.setBulletInBarrel(gunItem, true);
        }
    }

    @Override
    public void shoot(class_1799 gunItem, Supplier<Float> pitch, Supplier<Float> yaw, boolean tracer, class_1309 shooter) {
        class_2960 gunId = this.getGunId(gunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return;
        }
        CommonGunIndex gunIndex = gunIndexOptional.get();
        InaccuracyType inaccuracyState = InaccuracyType.getInaccuracyType(shooter);
        float[] inaccuracy = new float[]{gunIndex.getGunData().getInaccuracy(inaccuracyState)};
        int[] soundDistance = new int[]{(Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get()};
        boolean[] useSilenceSound = new boolean[]{false};
        AttachmentDataUtils.getAllAttachmentData(gunItem, gunIndex.getGunData(), attachmentData -> this.calculateAttachmentData((AttachmentData)attachmentData, inaccuracyState, inaccuracy, soundDistance, useSilenceSound));
        inaccuracy[0] = Math.max(0.0f, inaccuracy[0]);
        BulletData bulletData = gunIndex.getBulletData();
        class_2960 ammoId = gunIndex.getGunData().getAmmoId();
        FireMode fireMode = this.getFireMode(gunItem);
        float speed = class_3532.method_15363((float)(bulletData.getSpeed() / 20.0f), (float)0.0f, (float)Float.MAX_VALUE);
        int bulletAmount = Math.max(bulletData.getBulletAmount(), 1);
        int cycles = fireMode == FireMode.BURST ? gunIndex.getGunData().getBurstData().getCount() : 1;
        long period = fireMode == FireMode.BURST ? gunIndex.getGunData().getBurstShootInterval() : 1L;
        boolean consumeAmmo = IGunOperator.fromLivingEntity(shooter).consumesAmmoOrNot();
        CycleTaskHelper.addCycleTask(() -> {
            boolean fire;
            if (shooter.method_29504()) {
                return false;
            }
            if (consumeAmmo) {
                Bolt boltType = gunIndex.getGunData().getBolt();
                boolean hasAmmoInBarrel = this.hasBulletInBarrel(gunItem) && boltType != Bolt.OPEN_BOLT;
                int ammoCount = this.getCurrentAmmoCount(gunItem) + (hasAmmoInBarrel ? 1 : 0);
                if (ammoCount <= 0) {
                    return false;
                }
            }
            boolean bl = fire = !new GunFireEvent(shooter, gunItem, LogicalSide.SERVER).post();
            if (fire) {
                NetworkHandler.sendToTrackingEntity(new GunFireS2CPacket(shooter.method_5628(), gunItem), (class_1297)shooter);
                if (consumeAmmo) {
                    this.reduceAmmo(gunItem);
                }
                class_1937 world = shooter.method_37908();
                for (int i = 0; i < bulletAmount; ++i) {
                    this.doSpawnBulletEntity(world, shooter, ((Float)pitch.get()).floatValue(), ((Float)yaw.get()).floatValue(), speed, inaccuracy[0], ammoId, gunId, tracer, bulletData);
                }
                if (soundDistance[0] > 0) {
                    String soundId = useSilenceSound[0] ? SoundManager.SILENCE_3P_SOUND : SoundManager.SHOOT_3P_SOUND;
                    SoundManager.sendSoundToNearby(shooter, soundDistance[0], gunId, soundId, 0.8f, 0.9f + shooter.method_6051().method_43057() * 0.125f);
                }
            }
            return true;
        }, period, cycles);
    }

    @Override
    public void melee(class_1309 user, class_1799 gunItem) {
        class_2960 gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            GunMeleeData meleeData = gunIndex.getGunData().getMeleeData();
            float distance = meleeData.getDistance();
            class_2960 muzzleId = this.getAttachmentId(gunItem, AttachmentType.MUZZLE);
            MeleeData muzzleData = this.getMeleeData(muzzleId);
            if (muzzleData != null) {
                this.doMelee(user, distance, muzzleData.getDistance(), muzzleData.getRangeAngle(), muzzleData.getKnockback(), muzzleData.getDamage(), muzzleData.getEffects());
                return;
            }
            class_2960 stockId = this.getAttachmentId(gunItem, AttachmentType.STOCK);
            MeleeData stockData = this.getMeleeData(stockId);
            if (stockData != null) {
                this.doMelee(user, distance, stockData.getDistance(), stockData.getRangeAngle(), stockData.getKnockback(), stockData.getDamage(), stockData.getEffects());
                return;
            }
            GunDefaultMeleeData defaultData = meleeData.getDefaultMeleeData();
            if (defaultData == null) {
                return;
            }
            this.doMelee(user, distance, defaultData.getDistance(), defaultData.getRangeAngle(), defaultData.getKnockback(), defaultData.getDamage(), Collections.emptyList());
        });
    }

    private void doMelee(class_1309 user, float gunDistance, float meleeDistance, float rangeAngle, float knockback, float damage, List<EffectData> effects) {
        double distance = gunDistance + meleeDistance;
        float xRot = (float)Math.toRadians(-user.method_36455());
        float yRot = (float)Math.toRadians(-user.method_36454());
        class_243 eyeVec = new class_243(0.0, 0.0, 1.0).method_1037(xRot).method_1024(yRot).method_1029().method_1021(distance);
        class_243 centrePos = user.method_33571().method_1020(eyeVec);
        List entityList = user.method_37908().method_18467(class_1309.class, user.method_5829().method_1014(distance));
        for (class_1309 living : entityList) {
            double degree;
            class_243 targetVec = living.method_33571().method_1020(centrePos);
            double targetLength = targetVec.method_1033();
            if (targetLength < distance || !((degree = Math.toDegrees(Math.acos(targetVec.method_1026(eyeVec) / (targetLength * distance)))) < (double)(rangeAngle / 2.0f))) continue;
            ModernKineticGunItem.doPerLivingHurt(user, living, knockback, damage, effects);
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7322(0.1f);
        }
        if (DebugCommand.DEBUG) {
            GunMeleeDebug.showRange(user, (int)Math.round(distance), centrePos, eyeVec, rangeAngle);
        }
    }

    private static void doPerLivingHurt(class_1309 user, class_1309 target, float knockback, float damage, List<EffectData> effects) {
        if (target.equals((Object)user)) {
            return;
        }
        target.method_6005((double)knockback, (double)((float)Math.sin(Math.toRadians(user.method_36454()))), (double)((float)(-Math.cos(Math.toRadians(user.method_36454())))));
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            target.method_5643(user.method_48923().method_48802(player), damage);
        } else {
            target.method_5643(user.method_48923().method_48812(user), damage);
        }
        if (!target.method_5805()) {
            return;
        }
        for (EffectData effectData : effects) {
            class_1291 mobEffect = (class_1291)class_7923.field_41174.method_10223(effectData.getEffectId());
            if (mobEffect == null) continue;
            int time = Math.max(0, effectData.getTime() * 20);
            int amplifier = Math.max(0, effectData.getAmplifier());
            class_1293 effectInstance = new class_1293(mobEffect, time, amplifier, false, effectData.isHideParticles());
            target.method_6092(effectInstance);
        }
        class_1937 class_19372 = user.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int n = (int)((double)damage * 0.5);
            serverLevel.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), n, 0.1, 0.0, 0.1, 0.2);
        }
    }

    @Override
    public void fireSelect(class_1799 gunItem) {
        class_2960 gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> {
            FireMode fireMode = this.getFireMode(gunItem);
            List<FireMode> fireModeSet = gunIndex.getGunData().getFireModeSet();
            int nextIndex = (fireModeSet.indexOf((Object)fireMode) + 1) % fireModeSet.size();
            FireMode nextFireMode = fireModeSet.get(nextIndex);
            this.setFireMode(gunItem, nextFireMode);
            return nextFireMode;
        });
    }

    @Override
    public void reloadAmmo(class_1799 gunItem, int ammoCount, boolean loadBarrel) {
        class_2960 gunId = this.getGunId(gunItem);
        Bolt boltType = TimelessAPI.getCommonGunIndex(gunId).map(index -> index.getGunData().getBolt()).orElse(null);
        this.setCurrentAmmoCount(gunItem, ammoCount);
        if (loadBarrel && (boltType == Bolt.MANUAL_ACTION || boltType == Bolt.CLOSED_BOLT)) {
            this.reduceCurrentAmmoCount(gunItem);
            this.setBulletInBarrel(gunItem, true);
        }
    }

    protected void doSpawnBulletEntity(class_1937 world, class_1309 shooter, float pitch, float yaw, float speed, float inaccuracy, class_2960 ammoId, class_2960 gunId, boolean tracer, BulletData bulletData) {
        EntityKineticBullet bullet = new EntityKineticBullet(world, shooter, ammoId, gunId, tracer, bulletData);
        bullet.method_24919((class_1297)bullet, pitch, yaw, 0.0f, speed, inaccuracy);
        world.method_8649((class_1297)bullet);
    }

    @Override
    public int getLevel(int exp) {
        return 0;
    }

    @Override
    public int getExp(int level) {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }

    protected void reduceAmmo(class_1799 currentGunItem) {
        Bolt boltType = TimelessAPI.getCommonGunIndex(this.getGunId(currentGunItem)).map(index -> index.getGunData().getBolt()).orElse(null);
        if (boltType == null) {
            return;
        }
        if (boltType == Bolt.MANUAL_ACTION) {
            this.setBulletInBarrel(currentGunItem, false);
        } else if (boltType == Bolt.CLOSED_BOLT) {
            if (this.getCurrentAmmoCount(currentGunItem) > 0) {
                this.reduceCurrentAmmoCount(currentGunItem);
            } else {
                this.setBulletInBarrel(currentGunItem, false);
            }
        } else {
            this.reduceCurrentAmmoCount(currentGunItem);
        }
    }

    private void calculateAttachmentData(AttachmentData attachmentData, InaccuracyType inaccuracyState, float[] inaccuracy, int[] soundDistance, boolean[] useSilenceSound) {
        Silence silence;
        if (!inaccuracyState.isAim()) {
            inaccuracy[0] = inaccuracy[0] + attachmentData.getInaccuracyAddend();
        }
        if ((silence = attachmentData.getSilence()) != null) {
            soundDistance[0] = soundDistance[0] + silence.getDistanceAddend();
            if (silence.isUseSilenceSound()) {
                useSilenceSound[0] = true;
            }
        }
    }

    @Nullable
    private MeleeData getMeleeData(class_2960 attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

