/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.nbt.AmmoBoxItemDataAccessor;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.inventory.tooltip.AmmoBoxTooltip;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class AmmoBoxItem
extends class_1792
implements class_1768,
AmmoBoxItemDataAccessor {
    public static final class_2960 PROPERTY_NAME = new class_2960("tacz", "ammo_statue");
    public static final int IRON_LEVEL = 0;
    public static final int GOLD_LEVEL = 1;
    public static final int DIAMOND_LEVEL = 2;
    private static final String DISPLAY_TAG = "display";
    private static final String COLOR_TAG = "color";
    private static final int OPEN = 0;
    private static final int CLOSE = 1;
    private static final int CREATIVE_INDEX = 6;
    private static final int ALL_TYPE_CREATIVE_INDEX = 8;

    public AmmoBoxItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Environment(value=EnvType.CLIENT)
    public static int getColor(class_1799 stack, int tintIndex) {
        return tintIndex > 0 ? -1 : AmmoBoxItem.getTagColor(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public static float getStatue(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
        int openStatue = 0;
        int ammoLevel = 0;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IAmmoBox) {
            IAmmoBox iAmmoBox = (IAmmoBox)class_17922;
            if (iAmmoBox.isAllTypeCreative(stack)) {
                return 8.0f;
            }
            openStatue = AmmoBoxItem.getOpenStatue(stack, iAmmoBox);
            if (iAmmoBox.isCreative(stack)) {
                return openStatue + 6;
            }
            ammoLevel = AmmoBoxItem.getLevelStatue(stack, iAmmoBox);
        }
        return openStatue + 2 * ammoLevel;
    }

    private static int getOpenStatue(class_1799 stack, IAmmoBox iAmmoBox) {
        boolean countIsZero;
        boolean idIsEmpty = iAmmoBox.getAmmoId(stack).equals((Object)DefaultAssets.EMPTY_AMMO_ID);
        boolean bl = countIsZero = iAmmoBox.getAmmoCount(stack) <= 0;
        if (idIsEmpty || countIsZero) {
            return 0;
        }
        return 1;
    }

    private static int getLevelStatue(class_1799 stack, IAmmoBox iAmmoBox) {
        return iAmmoBox.getAmmoLevel(stack);
    }

    private static int getTagColor(class_1799 stack) {
        class_2487 compoundtag = stack.method_7941(DISPLAY_TAG);
        return compoundtag != null && compoundtag.method_10573(COLOR_TAG, 99) ? compoundtag.method_10550(COLOR_TAG) : 7503211;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public boolean method_31565(class_1799 ammoBox, class_1735 slot, class_5536 action, class_1657 player) {
        if (action == class_5536.field_27014) {
            class_1799 slotItem = slot.method_7677();
            class_2960 boxAmmoId = this.getAmmoId(ammoBox);
            if (slotItem.method_7960()) {
                if (this.isAllTypeCreative(ammoBox) || this.isCreative(ammoBox)) {
                    return false;
                }
                if (boxAmmoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                int boxAmmoCount = this.getAmmoCount(ammoBox);
                if (boxAmmoCount <= 0) {
                    return false;
                }
                TimelessAPI.getCommonAmmoIndex(boxAmmoId).ifPresent(index -> {
                    int takeCount = Math.min(index.getStackSize(), boxAmmoCount);
                    class_1799 takeAmmo = AmmoItemBuilder.create().setId(boxAmmoId).setCount(takeCount).build();
                    slot.method_32756(takeAmmo);
                    int remainCount = boxAmmoCount - takeCount;
                    this.setAmmoCount(ammoBox, remainCount);
                    if (remainCount <= 0) {
                        this.setAmmoId(ammoBox, DefaultAssets.EMPTY_AMMO_ID);
                    }
                    this.playRemoveOneSound((class_1297)player);
                });
                return true;
            }
            class_1792 class_17922 = slotItem.method_7909();
            if (class_17922 instanceof IAmmo) {
                IAmmo iAmmo = (IAmmo)class_17922;
                if (this.isAllTypeCreative(ammoBox)) {
                    return false;
                }
                class_2960 slotAmmoId = iAmmo.getAmmoId(slotItem);
                if (slotAmmoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                if (boxAmmoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                    this.setAmmoId(ammoBox, slotAmmoId);
                } else if (!slotAmmoId.equals((Object)boxAmmoId)) {
                    return false;
                }
                TimelessAPI.getCommonAmmoIndex(slotAmmoId).ifPresent(index -> {
                    if (this.isCreative(ammoBox)) {
                        this.setAmmoCount(ammoBox, Integer.MAX_VALUE);
                        return;
                    }
                    int boxAmmoCount = this.getAmmoCount(ammoBox);
                    int boxLevelMultiplier = this.getAmmoLevel(ammoBox) + 1;
                    int maxSize = index.getStackSize() * (Integer)SyncConfig.AMMO_BOX_STACK_SIZE.get() * boxLevelMultiplier;
                    int needCount = maxSize - boxAmmoCount;
                    class_1799 takeItem = slot.method_32753(slotItem.method_7947(), needCount, player);
                    this.setAmmoCount(ammoBox, boxAmmoCount + takeItem.method_7947());
                });
                this.playInsertSound((class_1297)player);
                return true;
            }
        }
        return false;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public boolean method_31567(class_1799 stack) {
        if (this.isAllTypeCreative(stack) || this.isCreative(stack)) {
            return false;
        }
        return !this.getAmmoId(stack).equals((Object)DefaultAssets.EMPTY_AMMO_ID) && this.getAmmoCount(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        class_2960 ammoId = this.getAmmoId(stack);
        int ammoCount = this.getAmmoCount(stack);
        int boxLevelMultiplier = this.getAmmoLevel(stack) + 1;
        double widthPercent = TimelessAPI.getCommonAmmoIndex(ammoId).map(index -> {
            double totalCount = index.getStackSize() * (Integer)SyncConfig.AMMO_BOX_STACK_SIZE.get() * boxLevelMultiplier;
            return (double)ammoCount / totalCount;
        }).orElse(0.0);
        return (int)Math.min(1.0 + 12.0 * widthPercent, 13.0);
    }

    public class_2561 method_7864(class_1799 stack) {
        if (this.isAllTypeCreative(stack)) {
            return class_2561.method_43471((String)"item.tacz.ammo_box.all_type_creative").method_27692(class_124.field_1064);
        }
        if (this.isCreative(stack)) {
            return class_2561.method_43471((String)"item.tacz.ammo_box.creative").method_27692(class_124.field_1064);
        }
        int ammoLevel = this.getAmmoLevel(stack);
        switch (ammoLevel) {
            case 1: {
                return class_2561.method_43471((String)"item.tacz.ammo_box.gold").method_27692(class_124.field_1054);
            }
            case 2: {
                return class_2561.method_43471((String)"item.tacz.ammo_box.diamond").method_27692(class_124.field_1075);
            }
        }
        return class_2561.method_43471((String)"item.tacz.ammo_box.iron");
    }

    public boolean method_7886(class_1799 stack) {
        if (this.isAllTypeCreative(stack) || this.isCreative(stack)) {
            return true;
        }
        return super.method_7886(stack);
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    public static void fillItemCategory(class_1761.class_7704 output) {
        class_1799 ammoBox = ModItems.AMMO_BOX.method_7854();
        class_1792 class_17922 = ammoBox.method_7909();
        if (class_17922 instanceof IAmmoBox) {
            IAmmoBox iAmmoBox = (IAmmoBox)class_17922;
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), 0));
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), 1));
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), 2));
            output.method_45420(iAmmoBox.setCreative(ammoBox.method_7972(), false));
            output.method_45420(iAmmoBox.setCreative(ammoBox.method_7972(), true));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IAmmoBox)) {
            return Optional.empty();
        }
        IAmmoBox iAmmoBox = (IAmmoBox)class_17922;
        class_2960 ammoId = iAmmoBox.getAmmoId(stack);
        if (ammoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
            return Optional.empty();
        }
        int ammoCount = iAmmoBox.getAmmoCount(stack);
        if (ammoCount <= 0) {
            return Optional.empty();
        }
        class_1799 ammoStack = AmmoItemBuilder.create().setId(ammoId).build();
        return Optional.of(new AmmoBoxTooltip(stack, ammoStack, ammoCount));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 pLevel, List<class_2561> components, class_1836 isAdvanced) {
        if (this.isAllTypeCreative(stack)) {
            components.add((class_2561)class_2561.method_43471((String)"tooltip.tacz.ammo_box.usage.all_type_creative").method_27692(class_124.field_1065));
            return;
        }
        if (this.isCreative(stack)) {
            components.add((class_2561)class_2561.method_43471((String)"tooltip.tacz.ammo_box.usage.creative.1").method_27692(class_124.field_1054));
            components.add((class_2561)class_2561.method_43471((String)"tooltip.tacz.ammo_box.usage.creative.2").method_27692(class_124.field_1054));
            return;
        }
        components.add((class_2561)class_2561.method_43471((String)"tooltip.tacz.ammo_box.usage.deposit").method_27692(class_124.field_1080));
        components.add((class_2561)class_2561.method_43471((String)"tooltip.tacz.ammo_box.usage.remove").method_27692(class_124.field_1080));
    }
}

