/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.iris;

import com.tacz.guns.compat.iris.legacy.IrisCompatLegacy;
import com.tacz.guns.compat.iris.newly.IrisCompatNewly;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_4597;

public final class IrisCompat {
    private static final Version VERSION;
    private static Function<class_4597.class_4598, Boolean> END_BATCH_FUNCTION;
    private static Supplier<Boolean> IS_RENDER_SHADOW_SUPPER;

    public static void initCompat() {
        FabricLoader.getInstance().getModContainer("iris").ifPresent(mod -> {
            if (mod.getMetadata().getVersion().compareTo((Object)VERSION) >= 0) {
                END_BATCH_FUNCTION = IrisCompatNewly::endBatch;
                IS_RENDER_SHADOW_SUPPER = IrisCompatNewly::isRenderShadow;
                IrisCompatNewly.registerPBRLoader();
            } else {
                END_BATCH_FUNCTION = IrisCompatLegacy::endBatch;
                IS_RENDER_SHADOW_SUPPER = IrisCompatLegacy::isRenderShadow;
                IrisCompatLegacy.registerPBRLoader();
            }
        });
    }

    public static boolean isRenderShadow() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return IS_RENDER_SHADOW_SUPPER.get();
        }
        return false;
    }

    public static boolean isUsingRenderPack() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean endBatch(class_4597.class_4598 bufferSource) {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return END_BATCH_FUNCTION.apply(bufferSource);
        }
        return false;
    }

    static {
        try {
            VERSION = Version.parse((String)"1.7.0");
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }
}

