/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.loader.asset;

import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_4228;
import net.minecraft.class_4231;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class SoundLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"SoundLoader");
    private static final Pattern SOUND_PATTERN = Pattern.compile("^(\\w+)/sounds/([\\w/]+)\\.ogg$");

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = SOUND_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            String namespace = TacPathVisitor.checkNamespace(matcher.group(1));
            String path = matcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            try (InputStream zipEntryStream = zipFile.getInputStream(entry);){
                boolean bl;
                try (class_4228 audioStream = new class_4228(zipEntryStream);){
                    ByteBuffer bytebuffer = audioStream.method_19721();
                    class_2960 registryName = new class_2960(namespace, path);
                    ClientAssetManager.INSTANCE.putSoundBuffer(registryName, new class_4231(bytebuffer, audioStream.method_19719()));
                    bl = true;
                }
                return bl;
            }
            catch (IOException ioe) {
                GunMod.LOGGER.warn(MARKER, "Failed to load sound: {}", (Object)zipPath);
                ioe.printStackTrace();
            }
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("sounds");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".ogg", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                     class_4228 audioStream = new class_4228(stream);){
                    ByteBuffer bytebuffer = audioStream.method_19721();
                    ClientAssetManager.INSTANCE.putSoundBuffer((class_2960)id, new class_4231(bytebuffer, audioStream.method_19719()));
                }
                catch (IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read sound file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }
}

