/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.loader.asset;

import com.google.common.collect.Maps;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2477;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class LanguageLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"LanguageLoader");
    private static final Pattern LANG_PATTERN = Pattern.compile("^\\w+/lang/(\\w+)\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = LANG_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String languageCode = TacPathVisitor.checkNamespace(matcher.group(1));
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream zipEntryStream = zipFile.getInputStream(entry);
                try {
                    HashMap languages = Maps.newHashMap();
                    class_2477.method_29425((InputStream)zipEntryStream, languages::put);
                    ClientAssetManager.INSTANCE.putLanguage(languageCode, languages);
                    bl = true;
                    if (zipEntryStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (zipEntryStream != null) {
                            try {
                                zipEntryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read language file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                zipEntryStream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("lang");
        if (!Files.isDirectory(filePath, new LinkOption[0])) {
            return;
        }
        File[] subFiles = filePath.toFile().listFiles((dir, name) -> true);
        if (subFiles == null) {
            return;
        }
        for (File file : subFiles) {
            String name2 = file.getName();
            if (!name2.endsWith(".json")) continue;
            String languageCode = name2.substring(0, name2.length() - 5);
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                HashMap languages = Maps.newHashMap();
                class_2477.method_29425((InputStream)inputStream, languages::put);
                ClientAssetManager.INSTANCE.putLanguage(languageCode, languages);
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read language file: {}", (Object)file);
                exception.printStackTrace();
            }
        }
    }
}

